/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users.repository;

import java.util.ArrayList;
import java.util.List;
import org.romaframework.aspect.persistence.PersistenceAspect;
import org.romaframework.aspect.persistence.Query;
import org.romaframework.aspect.persistence.QueryByFilter;
import org.romaframework.aspect.session.SessionAccount;
import org.romaframework.aspect.session.SessionInfo;
import org.romaframework.core.Roma;
import org.romaframework.core.repository.PersistenceAspectRepository;
import org.romaframework.module.users.domain.ActivityLog;
import org.romaframework.module.users.domain.BaseAccount;
import org.romaframework.module.users.domain.BaseAccountStatus;
import org.romaframework.module.users.domain.BaseGroup;
import org.romaframework.module.users.repository.ActivityLogRepository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseAccountRepository
extends PersistenceAspectRepository<BaseAccount> {
    public BaseAccount findByName(String iName) {
        return this.findByName(Roma.context().persistence(), iName);
    }

    public BaseAccount findByName(PersistenceAspect db, String iName) {
        QueryByFilter query = new QueryByFilter(BaseAccount.class);
        query.addItem("name", QueryByFilter.FIELD_EQUALS, (Object)iName);
        query.setMode("full");
        query.setStrategy((byte)2);
        return (BaseAccount)this.findFirstByCriteria(db, (Query)query);
    }

    public List<BaseAccount> findOfActiveAccountsOfGroups(BaseAccount iAccount) {
        QueryByFilter query = new QueryByFilter(BaseAccount.class, "or");
        query.setStrategy((byte)2);
        for (BaseGroup group : iAccount.getGroups()) {
            query.addItem("groups", QueryByFilter.FIELD_CONTAINS, (Object)group);
        }
        query.addOrder("name", "ASC");
        List queryResult = Roma.context().persistence().query((Query)query);
        List<BaseAccount> result = this.filterActiveAccounts(queryResult);
        return result;
    }

    private List<BaseAccount> filterActiveAccounts(List<BaseAccount> queryResult) {
        QueryByFilter acc = new QueryByFilter(BaseAccountStatus.class);
        acc.addItem("name", QueryByFilter.FIELD_EQUALS, (Object)"Account");
        acc.setStrategy((byte)2);
        BaseAccountStatus active = (BaseAccountStatus)Roma.context().persistence().queryOne((Query)acc);
        ArrayList<BaseAccount> result = new ArrayList<BaseAccount>();
        for (BaseAccount a : queryResult) {
            if (!a.getStatus().equals(active)) continue;
            result.add(a);
        }
        return result;
    }

    public BaseAccount update(BaseAccount object) {
        BaseAccount account = (BaseAccount)super.update((Object)object);
        SessionInfo sess = Roma.session().getActiveSessionInfo();
        if (sess != null && sess.getAccount() != null && sess.getAccount().equals(account)) {
            sess.setAccount((SessionAccount)account);
        }
        return account;
    }

    public void delete(Object[] iObjects) {
        for (Object o : iObjects) {
            this.delete((BaseAccount)o);
        }
    }

    public void delete(BaseAccount object) {
        if (Roma.existComponent(ActivityLogRepository.class)) {
            List<ActivityLog> logs = ((ActivityLogRepository)((Object)Roma.component(ActivityLogRepository.class))).findByAccount(object);
            ((ActivityLogRepository)((Object)Roma.component(ActivityLogRepository.class))).delete(logs.toArray());
        }
        super.delete((Object)object);
    }
}

