/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users.domain;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.romaframework.aspect.authentication.AuthenticationAspect;
import org.romaframework.aspect.core.annotation.AnnotationConstants;
import org.romaframework.aspect.session.SessionAccount;
import org.romaframework.aspect.view.annotation.ViewField;
import org.romaframework.core.Roma;
import org.romaframework.module.users.domain.AbstractAccount;
import org.romaframework.module.users.domain.BaseAccountStatus;
import org.romaframework.module.users.domain.BaseGroup;
import org.romaframework.module.users.domain.BaseProfile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseAccount
extends AbstractAccount
implements SessionAccount,
Serializable,
Cloneable {
    private static final long serialVersionUID = -2197776437029602641L;
    protected BaseProfile profile;
    protected Date signedOn;
    protected Date lastModified;
    protected Date lastPasswordUpdate;
    @ViewField(visible=AnnotationConstants.FALSE)
    protected String userIdentification;
    protected String notes;
    protected BaseAccountStatus status;
    protected Boolean changePasswordNextLogin;
    protected String email;
    protected Set<BaseGroup> groups;
    @ViewField(render="password")
    protected String password;
    @ViewField(visible=AnnotationConstants.FALSE)
    protected List<String> oldPasswords;

    public BaseAccount() {
    }

    public BaseAccount(String name, String password, BaseProfile iProfile) {
        this(name, password, iProfile, null);
    }

    public BaseAccount(String name, String password, BaseProfile iProfile, BaseAccountStatus iStatus) {
        this.name = name;
        this.setPassword(password);
        this.status = iStatus;
        this.profile = iProfile;
        this.lastModified = this.signedOn = new Date();
    }

    @Override
    public String toString() {
        return this.name;
    }

    public BaseProfile getProfile() {
        return this.profile;
    }

    public void setProfile(Object iProfile) {
        this.profile = (BaseProfile)iProfile;
    }

    public void setProfile(BaseProfile iProfile) {
        this.profile = iProfile;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String iPassword) {
        if (iPassword != null && iPassword.equals(this.password)) {
            return;
        }
        try {
            this.password = ((AuthenticationAspect)Roma.aspect(AuthenticationAspect.class)).encryptPassword(iPassword);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Date getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(Date lastModified) {
        this.lastModified = lastModified;
    }

    @ViewField(visible=AnnotationConstants.FALSE)
    public Date getLastPasswordUpdate() {
        return this.lastPasswordUpdate;
    }

    public void setLastPasswordUpdate(Date date) {
        this.lastPasswordUpdate = date;
    }

    public Date getSignedOn() {
        return this.signedOn;
    }

    public void setSignedOn(Date signedOn) {
        this.signedOn = signedOn;
    }

    public BaseAccountStatus getStatus() {
        return this.status;
    }

    public void setStatus(BaseAccountStatus status) {
        this.status = status;
    }

    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public Boolean isChangePasswordNextLogin() {
        return this.changePasswordNextLogin;
    }

    public void setChangePasswordNextLogin(Boolean changePasswordAtNextLogin) {
        this.changePasswordNextLogin = changePasswordAtNextLogin;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    @ViewField(visible=AnnotationConstants.FALSE)
    public BaseGroup getDefaultGroup() {
        if (this.groups != null && this.groups.size() == 1) {
            return this.groups.iterator().next();
        }
        return null;
    }

    public Set<BaseGroup> getGroups() {
        return this.groups;
    }

    public void setGroups(Set<BaseGroup> groups) {
        this.groups = groups;
    }

    public boolean addGroup(BaseGroup iGroup) {
        if (this.groups.contains(iGroup)) {
            return false;
        }
        this.groups.add(iGroup);
        return true;
    }

    public String getUserIdentification() {
        return this.userIdentification;
    }

    public void setUserIdentification(String userIdentification) {
        this.userIdentification = userIdentification;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseAccount other = (BaseAccount)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public List<String> getOldPasswords() {
        return this.oldPasswords;
    }

    public void setOldPasswords(List<String> oldPasswords) {
        this.oldPasswords = oldPasswords;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

