/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.users;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import org.romaframework.aspect.authentication.AuthenticationException;
import org.romaframework.aspect.persistence.Query;
import org.romaframework.aspect.persistence.QueryByFilter;
import org.romaframework.aspect.session.SessionAccount;
import org.romaframework.core.Roma;
import org.romaframework.module.users.AccountBinder;
import org.romaframework.module.users.SimpleAccountBinder;
import org.romaframework.module.users.UsersAuthentication;
import org.romaframework.module.users.domain.BaseAccount;
import org.romaframework.module.users.domain.BaseAccountStatus;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapAuthentication
extends UsersAuthentication {
    protected List<String> nonLdapUsers = new ArrayList<String>();
    protected String domain;
    protected String ldapHost;
    protected String searchBase;
    protected AccountBinder accountBinder;
    protected List<String> returnedAttributes;

    @Override
    public Object authenticate(String iUserName, String iUserPasswd, Map<String, String> iParameters) throws AuthenticationException {
        if (this.nonLdapUsers != null && this.nonLdapUsers.contains(iUserName)) {
            return super.authenticate(iUserName, iUserPasswd, iParameters);
        }
        Map<?, ?> authenticationResult = this.authenticateLdap(iUserName, iUserPasswd);
        BaseAccount account = null;
        AccountBinder binder = this.accountBinder;
        if (binder == null) {
            binder = new SimpleAccountBinder();
        }
        if (authenticationResult != null) {
            account = binder.getAccount(iUserName, authenticationResult);
        }
        if (account == null) {
            this.throwException("Authentication failed");
        }
        QueryByFilter byFilter = new QueryByFilter(BaseAccountStatus.class);
        byFilter.addItem("name", QueryByFilter.FIELD_EQUALS, (Object)"Active");
        BaseAccountStatus accountStatus = (BaseAccountStatus)Roma.context().persistence().queryOne((Query)byFilter);
        if (account.getStatus() == null || !account.getStatus().equals(accountStatus)) {
            this.throwException("Account " + iUserName + " is not active");
        }
        if (this.isSingleSessionPerUser()) {
            this.dropExistingSessions(account);
        }
        Roma.session().getActiveSessionInfo().setAccount((SessionAccount)account);
        return account;
    }

    public AccountBinder getAccountBinder() {
        return this.accountBinder;
    }

    public void setAccountBinder(AccountBinder accountBinder) {
        this.accountBinder = accountBinder;
    }

    protected Map<?, ?> authenticateLdap(String user, String pass) {
        String searchFilter = "(&(objectClass=user)(sAMAccountName=" + user + "))";
        SearchControls searchCtls = new SearchControls();
        if (this.returnedAttributes != null && this.returnedAttributes.size() > 0) {
            searchCtls.setReturningAttributes(this.returnedAttributes.toArray(new String[0]));
        }
        searchCtls.setSearchScope(2);
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", this.ldapHost);
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", user + "@" + this.domain);
        env.put("java.naming.security.credentials", pass);
        InitialLdapContext ctxGC = null;
        try {
            ctxGC = new InitialLdapContext(env, null);
            NamingEnumeration<SearchResult> answer = ctxGC.search(this.searchBase, searchFilter, searchCtls);
            if (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                HashMap<String, Object> amap = null;
                if (attrs != null) {
                    amap = new HashMap<String, Object>();
                    NamingEnumeration<? extends Attribute> ne = attrs.getAll();
                    while (ne.hasMore()) {
                        Attribute attr = ne.next();
                        amap.put(attr.getID(), attr.get());
                    }
                    ne.close();
                }
                return amap;
            }
        }
        catch (NamingException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getLdapHost() {
        return this.ldapHost;
    }

    public void setLdapHost(String ldapHost) {
        this.ldapHost = ldapHost;
    }

    public String getSearchBase() {
        return this.searchBase;
    }

    public void setSearchBase(String searchBase) {
        this.searchBase = searchBase;
    }

    public List<String> getReturnedAttributes() {
        return this.returnedAttributes;
    }

    public void setReturnedAttributes(List<String> returnedAttributes) {
        this.returnedAttributes = returnedAttributes;
    }

    public List<String> getNonLdapUsers() {
        return this.nonLdapUsers;
    }

    public void setNonLdapUsers(List<String> nonLdapUsers) {
        this.nonLdapUsers = nonLdapUsers;
    }
}

