/*
 * Decompiled with CFR 0.152.
 */
package org.romaframework.module.security.users;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import org.romaframework.aspect.authentication.AuthenticationAspect;
import org.romaframework.aspect.security.Secure;
import org.romaframework.aspect.security.SecurityAspectAbstract;
import org.romaframework.aspect.security.exception.SecurityException;
import org.romaframework.aspect.security.feature.SecurityActionFeatures;
import org.romaframework.aspect.security.feature.SecurityClassFeatures;
import org.romaframework.aspect.security.feature.SecurityEventFeatures;
import org.romaframework.aspect.security.feature.SecurityFieldFeatures;
import org.romaframework.aspect.view.feature.ViewFieldFeatures;
import org.romaframework.core.Roma;
import org.romaframework.core.schema.Feature;
import org.romaframework.core.schema.SchemaAction;
import org.romaframework.core.schema.SchemaClass;
import org.romaframework.core.schema.SchemaClassElement;
import org.romaframework.core.schema.SchemaEvent;
import org.romaframework.core.schema.SchemaField;
import org.romaframework.module.users.domain.AbstractAccount;
import org.romaframework.module.users.domain.BaseAccount;
import org.romaframework.module.users.domain.BaseGroup;

public class UsersSecurityAspect
extends SecurityAspectAbstract {
    public String aspectName() {
        return "security";
    }

    public void startup() {
        super.startup();
    }

    public Object getUnderlyingComponent() {
        return null;
    }

    public void configEvent(SchemaEvent event) {
    }

    private BaseAccount getAccount() {
        BaseAccount account = (BaseAccount)((AuthenticationAspect)Roma.aspect(AuthenticationAspect.class)).getCurrentAccount();
        return account;
    }

    public boolean canRead(Object obj, SchemaField iSchemaField) {
        if (obj instanceof Secure && !((Secure)obj).canRead()) {
            return false;
        }
        return this.canRead(obj, iSchemaField, this.getAccount());
    }

    public boolean canWrite(Object obj, SchemaField iSchemaField) {
        if (obj instanceof Secure && !((Secure)obj).canWrite()) {
            return false;
        }
        return this.canWrite(obj, iSchemaField, this.getAccount());
    }

    public boolean canExecute(Object obj, SchemaClassElement iSchemaElement) {
        return this.canExecute(obj, iSchemaElement, this.getAccount());
    }

    public boolean canRead(Object obj, SchemaField iSchemaField, AbstractAccount account) {
        String[] readRules = (String[])iSchemaField.getFeature(SecurityFieldFeatures.READ_ROLES);
        if (readRules == null || readRules.equals("")) {
            readRules = (String[])iSchemaField.getEntity().getFeature(SecurityClassFeatures.READ_ROLES);
        }
        return this.matchesRule(iSchemaField.toString(), account, readRules);
    }

    public boolean canWrite(Object obj, SchemaField iSchemaField, AbstractAccount account) {
        String[] readRules = (String[])iSchemaField.getFeature(SecurityFieldFeatures.WRITE_ROLES);
        if (readRules == null || readRules.equals("")) {
            readRules = (String[])iSchemaField.getEntity().getFeature(SecurityClassFeatures.WRITE_ROLES);
        }
        return this.matchesRule(iSchemaField.toString(), account, readRules);
    }

    public boolean canExecute(Object obj, SchemaClassElement iSchemaAction, AbstractAccount account) {
        String[] readRules = (String[])iSchemaAction.getFeature(SecurityActionFeatures.ROLES);
        if (readRules == null || readRules.equals("")) {
            readRules = (String[])iSchemaAction.getEntity().getFeature(SecurityClassFeatures.EXECUTE_ROLES);
        }
        return this.matchesRule(iSchemaAction.toString(), account, readRules);
    }

    public boolean matchesRule(String iResource, AbstractAccount account, String[] readRules) {
        if (readRules == null || readRules.length == 0) {
            return true;
        }
        if (account == null) {
            throw new SecurityException("The resource requested '" + iResource + "' is protected and need an authenticated account to access in");
        }
        for (String readRule : readRules) {
            if ((readRule = readRule.trim()).isEmpty()) {
                throw new IllegalArgumentException("Found an empty rule for the resource: " + iResource);
            }
            int split_idx = readRule.indexOf(58);
            if (split_idx == -1) {
                throw new IllegalArgumentException("Found wrong rule: '" + readRule + "' for the resource: " + iResource);
            }
            String target = readRule.substring(0, split_idx);
            String rule = readRule.substring(split_idx + 1);
            if ("user".equalsIgnoreCase(target) && Pattern.matches(rule, account.getName())) {
                return true;
            }
            if (!(account instanceof BaseAccount)) continue;
            BaseAccount baseAccount = (BaseAccount)account;
            if ("profile".equalsIgnoreCase(target) && baseAccount.getProfile() != null && baseAccount.getProfile().getName() != null && Pattern.matches(rule, baseAccount.getProfile().getName())) {
                return true;
            }
            if (!"group".equalsIgnoreCase(target)) continue;
            for (BaseGroup group : baseAccount.getGroups()) {
                if (!this.matchesRule(iResource, group, readRules)) continue;
                return true;
            }
        }
        return false;
    }

    public Object decrypt(Object obj, String fieldName) {
        throw new UnsupportedOperationException();
    }

    public Object encrypt(Object obj, String fieldName) {
        throw new UnsupportedOperationException();
    }

    public Object onAfterFieldRead(Object iContent, SchemaField iField, Object iCurrentValue) {
        if (iCurrentValue instanceof Collection) {
            Iterator iter = ((Collection)iCurrentValue).iterator();
            while (iter.hasNext()) {
                if (!this.hasToRemoveValue(iter.next())) continue;
                iter.remove();
            }
        }
        if (iCurrentValue instanceof Map) {
            Map map = (Map)iCurrentValue;
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry iter = iterator.next();
                Object key = iter.getKey();
                if (key != null && !this.allowClass(Roma.schema().getSchemaClass(key.getClass()))) {
                    iterator.remove();
                    continue;
                }
                if (iter.getValue() == null || this.allowClass(Roma.schema().getSchemaClass(iter.getValue().getClass()))) continue;
                iterator.remove();
            }
        }
        return iCurrentValue;
    }

    public Object onAfterFieldWrite(Object iContent, SchemaField iField, Object iCurrentValue) {
        return iCurrentValue;
    }

    public void onAfterAction(Object iContent, SchemaAction iAction, Object returnedValue) {
    }

    public boolean onBeforeAction(Object iContent, SchemaAction iAction) {
        if (this.canExecute(iContent, (SchemaClassElement)iAction)) {
            return true;
        }
        throw new SecurityException("Current account can't execute the action '" + iAction + "' because has no privileges");
    }

    public void onExceptionAction(Object iContent, SchemaAction iAction, Exception exception) {
    }

    public Object onBeforeFieldRead(Object iContent, SchemaField iField, Object iCurrentValue) {
        if (this.canRead(iContent, iField)) {
            Boolean enabled;
            if (!this.canWrite(iContent, iField) && ((enabled = (Boolean)iField.getFeature(ViewFieldFeatures.ENABLED)) == null || enabled.booleanValue())) {
                Roma.setFeature((Object)iContent, (String)iField.getName(), (Feature)ViewFieldFeatures.ENABLED, (Object)false);
            }
            return IGNORED;
        }
        Boolean enabled = (Boolean)iField.getFeature(ViewFieldFeatures.ENABLED);
        if (enabled == null || enabled.booleanValue()) {
            Roma.setFeature((Object)iContent, (String)iField.getName(), (Feature)ViewFieldFeatures.ENABLED, (Object)false);
        }
        return null;
    }

    public Object onBeforeFieldWrite(Object iContent, SchemaField iField, Object iCurrentValue) {
        if (this.canWrite(iContent, iField)) {
            return IGNORED;
        }
        Object result = iField.getValue(iContent);
        Boolean enabled = (Boolean)iField.getFeature(ViewFieldFeatures.ENABLED);
        if (enabled == null || enabled.booleanValue()) {
            Roma.setFeature((Object)iContent, (String)iField.getName(), (Feature)ViewFieldFeatures.ENABLED, (Object)false);
        }
        return result;
    }

    public boolean allowAction(SchemaAction iAction) {
        if (iAction == null) {
            return true;
        }
        String[] rule = (String[])iAction.getFeature(SecurityActionFeatures.ROLES);
        if (rule == null) {
            rule = (String[])iAction.getEntity().getFeature(SecurityClassFeatures.EXECUTE_ROLES);
        }
        if (rule == null) {
            return true;
        }
        return this.matchesRule(iAction.toString(), this.getAccount(), rule);
    }

    public boolean allowClass(SchemaClass iClass) {
        if (iClass == null) {
            return true;
        }
        String[] rule = (String[])iClass.getFeature(SecurityClassFeatures.READ_ROLES);
        if (rule == null) {
            return true;
        }
        return this.matchesRule(iClass.toString(), this.getAccount(), rule);
    }

    public boolean allowEvent(SchemaEvent iEvent) {
        if (iEvent == null) {
            return true;
        }
        String[] rule = (String[])iEvent.getFeature(SecurityEventFeatures.ROLES);
        if (rule == null) {
            rule = (String[])iEvent.getEntity().getFeature(SecurityClassFeatures.EXECUTE_ROLES);
        }
        if (rule == null) {
            return true;
        }
        return this.matchesRule(iEvent.toString(), this.getAccount(), rule);
    }

    public boolean allowField(SchemaField iField) {
        if (iField == null) {
            return true;
        }
        String[] rule = (String[])iField.getFeature(SecurityFieldFeatures.READ_ROLES);
        if (rule == null) {
            rule = (String[])iField.getEntity().getFeature(SecurityClassFeatures.READ_ROLES);
        }
        if (rule == null) {
            return true;
        }
        return this.matchesRule(iField.toString(), this.getAccount(), rule);
    }

    private boolean hasToRemoveValue(Object iValue) {
        if (iValue instanceof Secure && !((Secure)iValue).canRead()) {
            return true;
        }
        return iValue != null && !this.allowClass(Roma.schema().getSchemaClassIfExist(iValue.getClass()));
    }
}

