package org.romaframework.module.users.repository;

import java.util.List;

import org.romaframework.aspect.persistence.QueryByFilter;
import org.romaframework.core.repository.PersistenceAspectRepository;
import org.romaframework.module.users.domain.ActivityLog;
import org.romaframework.module.users.domain.BaseAccount;

/**
 * Repository class for BaseGroup entity. By default it extends the PersistenceAspectRepository class that delegates the execution
 * of all commands to the PersistenceAspect. <br/>
 * <br/>
 * This class was generated by Roma Meta Framework CRUD wizard.
 */
public class ActivityLogRepository extends PersistenceAspectRepository<ActivityLog> {
	public List<ActivityLog> findByAccount(BaseAccount iAccount) {
		QueryByFilter query = new QueryByFilter(ActivityLog.class);
		query.addItem("account", QueryByFilter.FIELD_EQUALS, iAccount);
		return findByCriteria(query);
	}
}
