/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.maven;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.rodnansol.core.action.DocumentGenerationAction;
import org.rodnansol.core.generator.template.TemplateType;
import org.rodnansol.core.generator.template.compiler.TemplateCompilerFactory;
import org.rodnansol.core.generator.template.customization.AsciiDocTemplateCustomization;
import org.rodnansol.core.generator.template.customization.HtmlTemplateCustomization;
import org.rodnansol.core.generator.template.customization.MarkdownTemplateCustomization;
import org.rodnansol.core.generator.template.customization.TemplateCustomization;
import org.rodnansol.core.generator.template.customization.XmlTemplateCustomization;
import org.rodnansol.core.project.Project;
import org.rodnansol.core.project.ProjectFactory;
import org.rodnansol.core.project.maven.MavenProject;

@Mojo(name="generate-property-document")
public class GeneratePropertyDocumentMojo
extends AbstractMojo {
    protected static final String GENERATE_PROPERTY_DOCUMENT = "generate-property-document";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    org.apache.maven.project.MavenProject project;
    @Parameter(property="name", defaultValue="${project.name}")
    String name;
    @Parameter(property="description", defaultValue="${project.description}")
    String description;
    @Parameter(property="template")
    String template;
    @Parameter(property="htmlCustomization")
    HtmlTemplateCustomization htmlCustomization;
    @Parameter(property="markdownCustomization")
    MarkdownTemplateCustomization markdownCustomization;
    @Parameter(property="asciiDocCustomization")
    AsciiDocTemplateCustomization asciiDocCustomization;
    @Parameter(property="xmlCustomization")
    XmlTemplateCustomization xmlCustomization;
    @Parameter(property="type", defaultValue="MARKDOWN")
    TemplateType type;
    @Parameter(property="metadataInput", defaultValue="target/classes/META-INF/spring-configuration-metadata.json")
    File metadataInput;
    @Parameter(property="outputFile")
    File outputFile;
    @Parameter(property="failOnError", defaultValue="false")
    boolean failOnError;
    @Parameter(property="templateCompilerName")
    String templateCompilerName = TemplateCompilerFactory.getDefaultCompilerName();
    @Parameter(property="excludedProperties")
    List<String> excludedProperties = new ArrayList<String>();
    @Parameter(property="includedProperties")
    List<String> includedProperties = new ArrayList<String>();
    @Parameter(property="excludedGroups")
    List<String> excludedGroups = new ArrayList<String>();
    @Parameter(property="includedGroups")
    List<String> includedGroups = new ArrayList<String>();
    @Parameter(property="failOnMissingInput", defaultValue="true")
    boolean failOnMissingInput;

    public void execute() {
        try {
            DocumentGenerationAction documentGenerationAction = this.setupAction();
            documentGenerationAction.execute();
        }
        catch (Exception e) {
            if (this.failOnError) {
                throw new RuntimeException(e);
            }
            this.getLog().warn((CharSequence)"Error during file generation, failOnError is set to false, check the logs please....", (Throwable)e);
        }
    }

    private DocumentGenerationAction setupAction() {
        MavenProject mavenProject = ProjectFactory.ofMavenProject((File)this.project.getBasedir(), (String)this.project.getName(), (List)this.project.getModules());
        DocumentGenerationAction documentGenerationAction = new DocumentGenerationAction((Project)mavenProject, this.name, this.getActualTemplateCustomization(), this.type, this.metadataInput);
        documentGenerationAction.setTemplateCompilerName(this.templateCompilerName);
        documentGenerationAction.setDescription(this.description);
        documentGenerationAction.setTemplate(this.template);
        documentGenerationAction.setOutputFile(this.outputFile);
        documentGenerationAction.setExcludedGroups(this.excludedGroups);
        documentGenerationAction.setIncludedGroups(this.includedGroups);
        documentGenerationAction.setExcludedProperties(this.excludedProperties);
        documentGenerationAction.setIncludedProperties(this.includedProperties);
        return documentGenerationAction;
    }

    private TemplateCustomization getActualTemplateCustomization() {
        switch (this.type) {
            case MARKDOWN: {
                return this.markdownCustomization;
            }
            case ADOC: {
                return this.asciiDocCustomization;
            }
            case HTML: {
                return this.htmlCustomization;
            }
            case XML: {
                return this.xmlCustomization;
            }
        }
        throw new IllegalStateException("There is no template customization set for the current run");
    }
}

