/*
 * Decompiled with CFR 0.152.
 */
package org.rodnansol.maven;

import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.rodnansol.core.generator.reader.MetadataReader;
import org.rodnansol.core.generator.resolver.MetadataInputResolverContext;
import org.rodnansol.core.generator.template.TemplateType;
import org.rodnansol.core.generator.template.compiler.TemplateCompilerFactory;
import org.rodnansol.core.generator.template.customization.AsciiDocTemplateCustomization;
import org.rodnansol.core.generator.template.customization.HtmlTemplateCustomization;
import org.rodnansol.core.generator.template.customization.MarkdownTemplateCustomization;
import org.rodnansol.core.generator.template.customization.TemplateCustomization;
import org.rodnansol.core.generator.template.customization.XmlTemplateCustomization;
import org.rodnansol.core.generator.writer.AggregationDocumenter;
import org.rodnansol.core.generator.writer.CombinedInput;
import org.rodnansol.core.generator.writer.CreateAggregationCommand;
import org.rodnansol.core.generator.writer.CustomTemplate;
import org.rodnansol.core.generator.writer.postprocess.PropertyGroupFilterService;
import org.rodnansol.core.project.Project;
import org.rodnansol.core.project.ProjectFactory;
import org.rodnansol.core.project.maven.MavenProject;
import org.rodnansol.maven.AggregationMojoInput;

@Mojo(name="generate-and-aggregate-documents")
public class GenerateAndAggregateDocumentsMojo
extends AbstractMojo {
    protected static final String GOAL_NAME = "generate-and-aggregate-documents";
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    org.apache.maven.project.MavenProject project;
    @Parameter(property="name", required=true, defaultValue="${project.name}")
    String name;
    @Parameter(property="description", defaultValue="${project.description}")
    String description;
    @Parameter(property="type", defaultValue="MARKDOWN")
    TemplateType type;
    @Parameter(property="htmlCustomization")
    HtmlTemplateCustomization htmlCustomization;
    @Parameter(property="markdownCustomization")
    MarkdownTemplateCustomization markdownCustomization;
    @Parameter(property="asciiDocCustomization")
    AsciiDocTemplateCustomization asciiDocCustomization;
    @Parameter(property="xmlCustomization")
    XmlTemplateCustomization xmlCustomization;
    @Parameter(property="inputs", required=true)
    List<AggregationMojoInput> inputs;
    @Parameter(property="outputFile", required=true)
    File outputFile;
    @Parameter(property="templateCompilerName")
    String templateCompilerName = TemplateCompilerFactory.getDefaultCompilerName();
    @Parameter(property="headerTemplate")
    String headerTemplate;
    @Parameter(property="contentTemplate")
    String contentTemplate;
    @Parameter(property="footerTemplate")
    String footerTemplate;
    @Parameter(property="failOnMissingInput", defaultValue="true")
    boolean failOnMissingInput;

    public void execute() {
        AggregationDocumenter aggregationDocumenter = new AggregationDocumenter(MetadataReader.INSTANCE, TemplateCompilerFactory.getInstance((String)this.templateCompilerName), MetadataInputResolverContext.INSTANCE, PropertyGroupFilterService.INSTANCE);
        CreateAggregationCommand createAggregationCommand = this.createAggregationCommand();
        aggregationDocumenter.createDocumentsAndAggregate(createAggregationCommand);
    }

    private CreateAggregationCommand createAggregationCommand() {
        List combinedInputs = this.inputs.stream().map(this::mapToCombinedInput).collect(Collectors.toList());
        MavenProject mavenProject = ProjectFactory.ofMavenProject((File)this.project.getBasedir(), (String)this.name, (List)this.project.getModules());
        CreateAggregationCommand createAggregationCommand = new CreateAggregationCommand((Project)mavenProject, this.name, combinedInputs, this.type, this.getActualTemplateCustomization(), this.outputFile);
        createAggregationCommand.setDescription(this.description);
        createAggregationCommand.setCustomTemplate(new CustomTemplate(this.headerTemplate, this.contentTemplate, this.footerTemplate));
        createAggregationCommand.setFailOnMissingInput(this.failOnMissingInput);
        return createAggregationCommand;
    }

    private CombinedInput mapToCombinedInput(AggregationMojoInput aggregationMojoInput) {
        CombinedInput combinedInput = new CombinedInput(aggregationMojoInput.getInput(), aggregationMojoInput.getName(), aggregationMojoInput.getDescription());
        combinedInput.setExcludedGroups(aggregationMojoInput.getExcludedGroups());
        combinedInput.setIncludedGroups(aggregationMojoInput.getIncludedGroups());
        combinedInput.setIncludedProperties(aggregationMojoInput.getIncludedProperties());
        combinedInput.setExcludedProperties(aggregationMojoInput.getExcludedProperties());
        return combinedInput;
    }

    private TemplateCustomization getActualTemplateCustomization() {
        switch (this.type) {
            case MARKDOWN: {
                return this.markdownCustomization;
            }
            case ADOC: {
                return this.asciiDocCustomization;
            }
            case HTML: {
                return this.htmlCustomization;
            }
            case XML: {
                return this.xmlCustomization;
            }
        }
        throw new IllegalStateException("There is no template customization set for the current run");
    }
}

