/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

public enum TickerType {
    BLOCK_CACHE_MISS(0),
    BLOCK_CACHE_HIT(1),
    BLOCK_CACHE_ADD(2),
    BLOCK_CACHE_ADD_FAILURES(3),
    BLOCK_CACHE_INDEX_MISS(4),
    BLOCK_CACHE_INDEX_HIT(5),
    BLOCK_CACHE_INDEX_ADD(6),
    BLOCK_CACHE_INDEX_BYTES_INSERT(7),
    BLOCK_CACHE_FILTER_MISS(8),
    BLOCK_CACHE_FILTER_HIT(9),
    BLOCK_CACHE_FILTER_ADD(10),
    BLOCK_CACHE_FILTER_BYTES_INSERT(11),
    BLOCK_CACHE_DATA_MISS(12),
    BLOCK_CACHE_DATA_HIT(13),
    BLOCK_CACHE_DATA_ADD(14),
    BLOCK_CACHE_DATA_BYTES_INSERT(15),
    BLOCK_CACHE_BYTES_READ(16),
    BLOCK_CACHE_BYTES_WRITE(17),
    BLOCK_CACHE_COMPRESSION_DICT_MISS(18),
    BLOCK_CACHE_COMPRESSION_DICT_HIT(19),
    BLOCK_CACHE_COMPRESSION_DICT_ADD(20),
    BLOCK_CACHE_COMPRESSION_DICT_BYTES_INSERT(21),
    BLOCK_CACHE_ADD_REDUNDANT(22),
    BLOCK_CACHE_INDEX_ADD_REDUNDANT(23),
    BLOCK_CACHE_FILTER_ADD_REDUNDANT(24),
    BLOCK_CACHE_DATA_ADD_REDUNDANT(25),
    BLOCK_CACHE_COMPRESSION_DICT_ADD_REDUNDANT(26),
    SECONDARY_CACHE_HITS(27),
    SECONDARY_CACHE_FILTER_HITS(28),
    SECONDARY_CACHE_INDEX_HITS(29),
    SECONDARY_CACHE_DATA_HITS(30),
    COMPRESSED_SECONDARY_CACHE_DUMMY_HITS(31),
    COMPRESSED_SECONDARY_CACHE_HITS(32),
    COMPRESSED_SECONDARY_CACHE_PROMOTIONS(33),
    COMPRESSED_SECONDARY_CACHE_PROMOTION_SKIPS(34),
    BLOOM_FILTER_USEFUL(35),
    BLOOM_FILTER_FULL_POSITIVE(36),
    BLOOM_FILTER_FULL_TRUE_POSITIVE(37),
    BLOOM_FILTER_PREFIX_CHECKED(38),
    BLOOM_FILTER_PREFIX_USEFUL(39),
    BLOOM_FILTER_PREFIX_TRUE_POSITIVE(40),
    PERSISTENT_CACHE_HIT(41),
    PERSISTENT_CACHE_MISS(42),
    SIM_BLOCK_CACHE_HIT(43),
    SIM_BLOCK_CACHE_MISS(44),
    MEMTABLE_HIT(45),
    MEMTABLE_MISS(46),
    GET_HIT_L0(47),
    GET_HIT_L1(48),
    GET_HIT_L2_AND_UP(49),
    COMPACTION_KEY_DROP_NEWER_ENTRY(50),
    COMPACTION_KEY_DROP_OBSOLETE(51),
    COMPACTION_KEY_DROP_RANGE_DEL(52),
    COMPACTION_KEY_DROP_USER(53),
    COMPACTION_RANGE_DEL_DROP_OBSOLETE(54),
    COMPACTION_OPTIMIZED_DEL_DROP_OBSOLETE(55),
    COMPACTION_CANCELLED(56),
    NUMBER_KEYS_WRITTEN(57),
    NUMBER_KEYS_READ(58),
    NUMBER_KEYS_UPDATED(59),
    BYTES_WRITTEN(60),
    BYTES_READ(61),
    NUMBER_DB_SEEK(62),
    NUMBER_DB_NEXT(63),
    NUMBER_DB_PREV(64),
    NUMBER_DB_SEEK_FOUND(65),
    NUMBER_DB_NEXT_FOUND(66),
    NUMBER_DB_PREV_FOUND(67),
    ITER_BYTES_READ(68),
    NUMBER_ITER_SKIP(69),
    NUMBER_OF_RESEEKS_IN_ITERATION(70),
    NO_ITERATOR_CREATED(71),
    NO_ITERATOR_DELETED(72),
    NO_FILE_OPENS(73),
    NO_FILE_ERRORS(74),
    STALL_MICROS(75),
    DB_MUTEX_WAIT_MICROS(76),
    NUMBER_MULTIGET_CALLS(77),
    NUMBER_MULTIGET_KEYS_READ(78),
    NUMBER_MULTIGET_BYTES_READ(79),
    NUMBER_MULTIGET_KEYS_FOUND(80),
    NUMBER_MERGE_FAILURES(81),
    GET_UPDATES_SINCE_CALLS(82),
    WAL_FILE_SYNCED(83),
    WAL_FILE_BYTES(84),
    WRITE_DONE_BY_SELF(85),
    WRITE_DONE_BY_OTHER(86),
    WRITE_WITH_WAL(87),
    COMPACT_READ_BYTES(88),
    COMPACT_WRITE_BYTES(89),
    FLUSH_WRITE_BYTES(90),
    COMPACT_READ_BYTES_MARKED(91),
    COMPACT_READ_BYTES_PERIODIC(92),
    COMPACT_READ_BYTES_TTL(93),
    COMPACT_WRITE_BYTES_MARKED(94),
    COMPACT_WRITE_BYTES_PERIODIC(95),
    COMPACT_WRITE_BYTES_TTL(96),
    NUMBER_DIRECT_LOAD_TABLE_PROPERTIES(97),
    NUMBER_SUPERVERSION_ACQUIRES(98),
    NUMBER_SUPERVERSION_RELEASES(99),
    NUMBER_SUPERVERSION_CLEANUPS(100),
    NUMBER_BLOCK_COMPRESSED(101),
    NUMBER_BLOCK_DECOMPRESSED(102),
    BYTES_COMPRESSED_FROM(103),
    BYTES_COMPRESSED_TO(104),
    BYTES_COMPRESSION_BYPASSED(105),
    BYTES_COMPRESSION_REJECTED(106),
    NUMBER_BLOCK_COMPRESSION_BYPASSED(107),
    NUMBER_BLOCK_COMPRESSION_REJECTED(108),
    BYTES_DECOMPRESSED_FROM(109),
    BYTES_DECOMPRESSED_TO(110),
    MERGE_OPERATION_TOTAL_TIME(111),
    FILTER_OPERATION_TOTAL_TIME(112),
    COMPACTION_CPU_TOTAL_TIME(113),
    ROW_CACHE_HIT(114),
    ROW_CACHE_MISS(115),
    READ_AMP_ESTIMATE_USEFUL_BYTES(116),
    READ_AMP_TOTAL_READ_BYTES(117),
    NUMBER_RATE_LIMITER_DRAINS(118),
    BLOB_DB_NUM_PUT(119),
    BLOB_DB_NUM_WRITE(120),
    BLOB_DB_NUM_GET(121),
    BLOB_DB_NUM_MULTIGET(122),
    BLOB_DB_NUM_SEEK(123),
    BLOB_DB_NUM_NEXT(124),
    BLOB_DB_NUM_PREV(125),
    BLOB_DB_NUM_KEYS_WRITTEN(126),
    BLOB_DB_NUM_KEYS_READ(127),
    BLOB_DB_BYTES_WRITTEN(-1),
    BLOB_DB_BYTES_READ(-2),
    BLOB_DB_WRITE_INLINED(-3),
    BLOB_DB_WRITE_INLINED_TTL(-4),
    BLOB_DB_WRITE_BLOB(-5),
    BLOB_DB_WRITE_BLOB_TTL(-6),
    BLOB_DB_BLOB_FILE_BYTES_WRITTEN(-7),
    BLOB_DB_BLOB_FILE_BYTES_READ(-8),
    BLOB_DB_BLOB_FILE_SYNCED(-9),
    BLOB_DB_BLOB_INDEX_EXPIRED_COUNT(-10),
    BLOB_DB_BLOB_INDEX_EXPIRED_SIZE(-11),
    BLOB_DB_BLOB_INDEX_EVICTED_COUNT(-12),
    BLOB_DB_BLOB_INDEX_EVICTED_SIZE(-13),
    BLOB_DB_GC_NUM_FILES(-14),
    BLOB_DB_GC_NUM_NEW_FILES(-15),
    BLOB_DB_GC_FAILURES(-16),
    BLOB_DB_GC_NUM_KEYS_RELOCATED(-17),
    BLOB_DB_GC_BYTES_RELOCATED(-18),
    BLOB_DB_FIFO_NUM_FILES_EVICTED(-19),
    BLOB_DB_FIFO_NUM_KEYS_EVICTED(-20),
    BLOB_DB_FIFO_BYTES_EVICTED(-21),
    BLOB_DB_CACHE_MISS(-22),
    BLOB_DB_CACHE_HIT(-23),
    BLOB_DB_CACHE_ADD(-24),
    BLOB_DB_CACHE_ADD_FAILURES(-25),
    BLOB_DB_CACHE_BYTES_READ(-26),
    BLOB_DB_CACHE_BYTES_WRITE(-27),
    TXN_PREPARE_MUTEX_OVERHEAD(-28),
    TXN_OLD_COMMIT_MAP_MUTEX_OVERHEAD(-29),
    TXN_DUPLICATE_KEY_OVERHEAD(-30),
    TXN_SNAPSHOT_MUTEX_OVERHEAD(-31),
    TXN_GET_TRY_AGAIN(-32),
    FILES_MARKED_TRASH(-33),
    FILES_DELETED_FROM_TRASH_QUEUE(-34),
    FILES_DELETED_IMMEDIATELY(-35),
    ERROR_HANDLER_BG_ERROR_COUNT(-36),
    ERROR_HANDLER_BG_IO_ERROR_COUNT(-37),
    ERROR_HANDLER_BG_RETRYABLE_IO_ERROR_COUNT(-38),
    ERROR_HANDLER_AUTORESUME_COUNT(-39),
    ERROR_HANDLER_AUTORESUME_RETRY_TOTAL_COUNT(-40),
    ERROR_HANDLER_AUTORESUME_SUCCESS_COUNT(-41),
    MEMTABLE_PAYLOAD_BYTES_AT_FLUSH(-42),
    MEMTABLE_GARBAGE_BYTES_AT_FLUSH(-43),
    VERIFY_CHECKSUM_READ_BYTES(-44),
    BACKUP_READ_BYTES(-45),
    BACKUP_WRITE_BYTES(-46),
    REMOTE_COMPACT_READ_BYTES(-47),
    REMOTE_COMPACT_WRITE_BYTES(-48),
    HOT_FILE_READ_BYTES(-49),
    WARM_FILE_READ_BYTES(-50),
    COLD_FILE_READ_BYTES(-51),
    HOT_FILE_READ_COUNT(-52),
    WARM_FILE_READ_COUNT(-53),
    COLD_FILE_READ_COUNT(-54),
    LAST_LEVEL_READ_BYTES(-55),
    LAST_LEVEL_READ_COUNT(-56),
    NON_LAST_LEVEL_READ_BYTES(-57),
    NON_LAST_LEVEL_READ_COUNT(-58),
    LAST_LEVEL_SEEK_FILTERED(-59),
    LAST_LEVEL_SEEK_FILTER_MATCH(-60),
    LAST_LEVEL_SEEK_DATA(-61),
    LAST_LEVEL_SEEK_DATA_USEFUL_NO_FILTER(-62),
    LAST_LEVEL_SEEK_DATA_USEFUL_FILTER_MATCH(-63),
    NON_LAST_LEVEL_SEEK_FILTERED(-64),
    NON_LAST_LEVEL_SEEK_FILTER_MATCH(-65),
    NON_LAST_LEVEL_SEEK_DATA(-66),
    NON_LAST_LEVEL_SEEK_DATA_USEFUL_NO_FILTER(-67),
    NON_LAST_LEVEL_SEEK_DATA_USEFUL_FILTER_MATCH(-68),
    BLOCK_CHECKSUM_COMPUTE_COUNT(-69),
    BLOCK_CHECKSUM_MISMATCH_COUNT(-70),
    MULTIGET_COROUTINE_COUNT(-71),
    READ_ASYNC_MICROS(-72),
    ASYNC_READ_ERROR_COUNT(-73),
    TABLE_OPEN_PREFETCH_TAIL_MISS(-74),
    TABLE_OPEN_PREFETCH_TAIL_HIT(-75),
    TIMESTAMP_FILTER_TABLE_CHECKED(-76),
    TIMESTAMP_FILTER_TABLE_FILTERED(-77),
    READAHEAD_TRIMMED(-78),
    FIFO_MAX_SIZE_COMPACTIONS(-79),
    FIFO_TTL_COMPACTIONS(-80),
    PREFETCH_BYTES(-81),
    PREFETCH_BYTES_USEFUL(-82),
    PREFETCH_HITS(-83),
    TICKER_ENUM_MAX(-84);

    private final byte value;

    private TickerType(byte by) {
        this.value = by;
    }

    public byte getValue() {
        return this.value;
    }

    public static TickerType getTickerType(byte by) {
        for (TickerType tickerType : TickerType.values()) {
            if (tickerType.getValue() != by) continue;
            return tickerType;
        }
        throw new IllegalArgumentException("Illegal value provided for TickerType.");
    }
}

