/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.util.List;
import org.rocksdb.ColumnFamilyDescriptor;
import org.rocksdb.ColumnFamilyHandle;
import org.rocksdb.DBOptions;
import org.rocksdb.Options;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksDBException;

public class TtlDB
extends RocksDB {
    public static TtlDB open(Options options, String string) throws RocksDBException {
        return TtlDB.open(options, string, 0, false);
    }

    public static TtlDB open(Options options, String string, int n, boolean bl) throws RocksDBException {
        TtlDB ttlDB = new TtlDB();
        ttlDB.open(options.nativeHandle_, string, n, bl);
        return ttlDB;
    }

    public static TtlDB open(DBOptions dBOptions, String string, List<ColumnFamilyDescriptor> list, List<ColumnFamilyHandle> list2, List<Integer> list3, boolean bl) throws RocksDBException {
        if (list.size() != list3.size()) {
            throw new IllegalArgumentException("There must be a ttl value per columnfamily handle.");
        }
        TtlDB ttlDB = new TtlDB();
        List<Long> list4 = ttlDB.openCF(dBOptions.nativeHandle_, string, list, list.size(), list3, bl);
        for (int i = 0; i < list.size(); ++i) {
            list2.add(new ColumnFamilyHandle(ttlDB, list4.get(i)));
        }
        return ttlDB;
    }

    public ColumnFamilyHandle createColumnFamilyWithTtl(ColumnFamilyDescriptor columnFamilyDescriptor, int n) throws RocksDBException {
        assert (this.isInitialized());
        return new ColumnFamilyHandle(this, this.createColumnFamilyWithTtl(this.nativeHandle_, columnFamilyDescriptor, n));
    }

    @Override
    public synchronized void close() {
        if (this.isInitialized()) {
            super.close();
        }
    }

    protected TtlDB() {
    }

    @Override
    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    private native void open(long var1, String var3, int var4, boolean var5) throws RocksDBException;

    private native List<Long> openCF(long var1, String var3, List<ColumnFamilyDescriptor> var4, int var5, List<Integer> var6, boolean var7) throws RocksDBException;

    private native long createColumnFamilyWithTtl(long var1, ColumnFamilyDescriptor var3, int var4) throws RocksDBException;
}

