/*
 * Decompiled with CFR 0.152.
 */
package org.rocksdb;

import java.io.File;
import org.rocksdb.RocksObject;

public class BackupableDBOptions
extends RocksObject {
    public BackupableDBOptions(String string) {
        File file;
        File file2 = file = string == null ? null : new File(string);
        if (file == null || !file.isDirectory() || !file.canWrite()) {
            throw new IllegalArgumentException("Illegal path provided.");
        }
        this.newBackupableDBOptions(string);
    }

    public String backupDir() {
        assert (this.isInitialized());
        return this.backupDir(this.nativeHandle_);
    }

    public BackupableDBOptions setShareTableFiles(boolean bl) {
        assert (this.isInitialized());
        this.setShareTableFiles(this.nativeHandle_, bl);
        return this;
    }

    public boolean shareTableFiles() {
        assert (this.isInitialized());
        return this.shareTableFiles(this.nativeHandle_);
    }

    public BackupableDBOptions setSync(boolean bl) {
        assert (this.isInitialized());
        this.setSync(this.nativeHandle_, bl);
        return this;
    }

    public boolean sync() {
        assert (this.isInitialized());
        return this.sync(this.nativeHandle_);
    }

    public BackupableDBOptions setDestroyOldData(boolean bl) {
        assert (this.isInitialized());
        this.setDestroyOldData(this.nativeHandle_, bl);
        return this;
    }

    public boolean destroyOldData() {
        assert (this.isInitialized());
        return this.destroyOldData(this.nativeHandle_);
    }

    public BackupableDBOptions setBackupLogFiles(boolean bl) {
        assert (this.isInitialized());
        this.setBackupLogFiles(this.nativeHandle_, bl);
        return this;
    }

    public boolean backupLogFiles() {
        assert (this.isInitialized());
        return this.backupLogFiles(this.nativeHandle_);
    }

    public BackupableDBOptions setBackupRateLimit(long l) {
        assert (this.isInitialized());
        l = l <= 0L ? 0L : l;
        this.setBackupRateLimit(this.nativeHandle_, l);
        return this;
    }

    public long backupRateLimit() {
        assert (this.isInitialized());
        return this.backupRateLimit(this.nativeHandle_);
    }

    public BackupableDBOptions setRestoreRateLimit(long l) {
        assert (this.isInitialized());
        l = l <= 0L ? 0L : l;
        this.setRestoreRateLimit(this.nativeHandle_, l);
        return this;
    }

    public long restoreRateLimit() {
        assert (this.isInitialized());
        return this.restoreRateLimit(this.nativeHandle_);
    }

    public BackupableDBOptions setShareFilesWithChecksum(boolean bl) {
        assert (this.isInitialized());
        this.setShareFilesWithChecksum(this.nativeHandle_, bl);
        return this;
    }

    public boolean shareFilesWithChecksum() {
        assert (this.isInitialized());
        return this.shareFilesWithChecksum(this.nativeHandle_);
    }

    @Override
    protected void disposeInternal() {
        this.disposeInternal(this.nativeHandle_);
    }

    private native void newBackupableDBOptions(String var1);

    private native String backupDir(long var1);

    private native void setShareTableFiles(long var1, boolean var3);

    private native boolean shareTableFiles(long var1);

    private native void setSync(long var1, boolean var3);

    private native boolean sync(long var1);

    private native void setDestroyOldData(long var1, boolean var3);

    private native boolean destroyOldData(long var1);

    private native void setBackupLogFiles(long var1, boolean var3);

    private native boolean backupLogFiles(long var1);

    private native void setBackupRateLimit(long var1, long var3);

    private native long backupRateLimit(long var1);

    private native void setRestoreRateLimit(long var1, long var3);

    private native long restoreRateLimit(long var1);

    private native void setShareFilesWithChecksum(long var1, boolean var3);

    private native boolean shareFilesWithChecksum(long var1);

    private native void disposeInternal(long var1);
}

