/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.mavenplugin.harvesters;

import java.io.File;
import java.util.LinkedHashSet;
import java.util.Set;
import org.codehaus.plexus.util.DirectoryScanner;
import org.robotframework.mavenplugin.harvesters.HarvestUtils;
import org.robotframework.mavenplugin.harvesters.NameHarvester;

public class SourceFileNameHarvester
implements NameHarvester {
    private final File baseDir;

    public SourceFileNameHarvester(File bDir) {
        this.baseDir = bDir;
    }

    @Override
    public Set<String> harvest(String antLikePattern) {
        int minPatternIndex = HarvestUtils.calculateMinimumPatternIndex(antLikePattern);
        int lastSlashBeforePatternSymbol = antLikePattern.lastIndexOf(47, minPatternIndex);
        int lastBackslashBeforePatternSymbol = antLikePattern.lastIndexOf(92, minPatternIndex);
        int maxSlashIndex = Math.max(lastSlashBeforePatternSymbol, lastBackslashBeforePatternSymbol);
        String baseDirectory = "";
        if (!HarvestUtils.isAbsolutePathFragment(antLikePattern)) {
            baseDirectory = this.baseDir.getAbsolutePath() + File.separator;
        }
        String patternString = "";
        if (maxSlashIndex > 0) {
            baseDirectory = baseDirectory + antLikePattern.substring(0, maxSlashIndex + 1);
            if (maxSlashIndex + 1 < antLikePattern.length()) {
                patternString = antLikePattern.substring(maxSlashIndex + 1);
            }
        } else {
            patternString = antLikePattern;
        }
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(baseDirectory);
        scanner.setCaseSensitive(true);
        scanner.setIncludes(new String[]{patternString});
        scanner.scan();
        String[] includedFiles = scanner.getIncludedFiles();
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        File bDir = scanner.getBasedir();
        for (String iF : includedFiles) {
            File tmp = new File(bDir, iF);
            result.add(tmp.getAbsolutePath());
        }
        return result;
    }
}

