/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.mavenplugin.harvesters;

import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.robotframework.mavenplugin.harvesters.AntPatternClassPredicate;
import org.robotframework.mavenplugin.harvesters.HarvestUtils;
import org.robotframework.mavenplugin.harvesters.NameHarvester;

public class ResourceNameHarvester
implements NameHarvester {
    @Override
    public Set<String> harvest(String antLikePattern) {
        int minPatternIndex = HarvestUtils.calculateMinimumPatternIndex(antLikePattern);
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (minPatternIndex >= 0) {
            try {
                AntPatternClassPredicate ap = new AntPatternClassPredicate(antLikePattern);
                ClassPath cp = ClassPath.from((ClassLoader)this.getClass().getClassLoader());
                for (ClassPath.ResourceInfo ri : cp.getResources()) {
                    String t = ri.getResourceName();
                    if (!ap.apply(t)) continue;
                    result.add(t);
                }
            }
            catch (IOException iOException) {}
        } else {
            result.add(antLikePattern);
        }
        return result;
    }
}

