/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.mavenplugin.harvesters;

import com.google.common.base.Predicate;
import java.io.File;
import org.codehaus.plexus.util.DirectoryScanner;

public class AntPatternClassPredicate
implements Predicate<String> {
    private final String pattern;

    public AntPatternClassPredicate(String aPattern) {
        this.pattern = aPattern.replace('.', File.separatorChar);
    }

    public boolean apply(String target) {
        String compatibleTarget;
        if (target.endsWith(".class")) {
            int classSuffixIndex = target.lastIndexOf(".class");
            compatibleTarget = target.substring(0, classSuffixIndex);
        } else {
            compatibleTarget = target;
        }
        compatibleTarget = compatibleTarget.replace('.', File.separatorChar);
        return DirectoryScanner.match((String)this.pattern, (String)compatibleTarget);
    }
}

