/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.mavenplugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.codehaus.plexus.util.StringUtils;
import org.robotframework.mavenplugin.Arguments;
import org.robotframework.mavenplugin.TestDocMojo;
import org.robotframework.mavenplugin.harvesters.HarvestUtils;
import org.robotframework.mavenplugin.harvesters.ResourceNameHarvester;
import org.robotframework.mavenplugin.harvesters.SourceFileNameHarvester;

public class TestDocConfiguration {
    private File outputDirectory;
    private File outputFile;
    private String dataSourceFile;
    private String title;
    private String name;
    private String doc;

    public List<String[]> generateRunArguments(File projectBaseDir) {
        ArrayList<String[]> result = new ArrayList<String[]>();
        ArrayList<String> fileArguments = this.harvestResourceOrFileCandidates(projectBaseDir, this.dataSourceFile);
        boolean multipleOutputs = fileArguments.size() > 1;
        for (String fileArgument : fileArguments) {
            Arguments generatedArguments = this.generateTestdocArgumentList(projectBaseDir, multipleOutputs, fileArgument);
            result.add(generatedArguments.toArray());
        }
        return result;
    }

    private Arguments generateTestdocArgumentList(File projectBaseDir, boolean multipleOutputs, String fileArgument) {
        Arguments result = new Arguments();
        result.add("testdoc");
        result.addNonEmptyStringToArguments(this.title, "--title");
        result.addNonEmptyStringToArguments(this.name, "--name");
        result.addNonEmptyStringToArguments(this.doc, "--doc");
        result.add(fileArgument);
        if (multipleOutputs) {
            String normalizedArgument = HarvestUtils.isAbsolutePathFragment(fileArgument) ? HarvestUtils.removePrefixDirectory(projectBaseDir, fileArgument) : fileArgument;
            result.add(this.outputDirectory + File.separator + HarvestUtils.generateIdName(normalizedArgument) + HarvestUtils.extractExtension(this.outputFile.getName()));
        } else if (this.outputFile.getName().contains("*")) {
            File tf = new File(fileArgument);
            result.add(this.outputDirectory + File.separator + tf.getName() + HarvestUtils.extractExtension(this.outputFile.getName()));
        } else {
            result.add(this.outputDirectory + File.separator + this.outputFile.getName());
        }
        return result;
    }

    private ArrayList<String> harvestResourceOrFileCandidates(File projectBaseDir, String pattern) {
        File entity = new File(pattern);
        ArrayList<String> fileArguments = new ArrayList<String>();
        if (entity.isFile()) {
            fileArguments.add(entity.getAbsolutePath());
        } else if (HarvestUtils.hasDirectoryStructure(pattern)) {
            SourceFileNameHarvester harv = new SourceFileNameHarvester(projectBaseDir);
            fileArguments.addAll(harv.harvest(pattern));
        } else {
            SourceFileNameHarvester harv = new SourceFileNameHarvester(projectBaseDir);
            Set<String> harvested = harv.harvest(pattern);
            if (harvested.size() > 0) {
                fileArguments.addAll(harvested);
            } else {
                ResourceNameHarvester rharv = new ResourceNameHarvester();
                fileArguments.addAll(rharv.harvest(pattern));
            }
        }
        return fileArguments;
    }

    public void ensureOutputDirectoryExists() throws IOException {
        if (this.outputDirectory == null) {
            String baseDir = System.getProperty("basedir");
            if (baseDir == null) {
                baseDir = ".";
            }
            this.outputDirectory = new File(this.joinPaths(baseDir, "target", "robotframework", "testdoc"));
        }
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new IOException("Target output directory cannot be created: " + this.outputDirectory.getAbsolutePath());
        }
    }

    private String joinPaths(String ... parts) {
        return StringUtils.join((Object[])parts, (String)File.separator);
    }

    public void populateDefaults(TestDocMojo defaults) {
        if (this.outputDirectory == null) {
            this.outputDirectory = defaults.defaultTestdocOutputDirectory;
        }
    }
}

