/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.mavenplugin;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;
import org.robotframework.RobotFramework;
import org.robotframework.mavenplugin.AbstractMojoWithLoadedClasspath;
import org.robotframework.mavenplugin.Arguments;
import org.robotframework.mavenplugin.PythonRunner;

public class RebotMojo
extends AbstractMojoWithLoadedClasspath {
    private File outputDirectory;
    private boolean merge;
    private String logLevel;
    private File output;
    private File log;
    private String logTitle;
    private File report;
    private String reportTitle;
    private String splitOutputs;
    private File xunitFile;
    private boolean rpa;
    private List<String> removeKeywords;
    private List<String> flattenKeywords;

    @Override
    protected void subclassExecute() throws MojoExecutionException, MojoFailureException {
        try {
            this.runRebot();
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to execute rebot script: " + e.getMessage());
        }
    }

    public void runRebot() throws IOException {
        this.ensureOutputDirectoryExists();
        if (this.externalRunner != null && this.externalRunner.getRunWithPython()) {
            PythonRunner.run(this.generateRunArguments());
        } else {
            RobotFramework.run((String[])this.generateRunArguments());
        }
    }

    public String[] generateRunArguments() {
        Arguments generatedArguments = new Arguments();
        generatedArguments.add("rebot");
        generatedArguments.addFileToArguments(this.outputDirectory, "-d");
        generatedArguments.addFileToArguments(this.output, "-o");
        generatedArguments.addFileToArguments(this.log, "-l");
        generatedArguments.addNonEmptyStringToArguments(this.logTitle, "--logtitle");
        generatedArguments.addFileToArguments(this.report, "-r");
        generatedArguments.addNonEmptyStringToArguments(this.reportTitle, "--reporttitle");
        generatedArguments.addNonEmptyStringToArguments(this.splitOutputs, "--splitoutputs");
        generatedArguments.addFlagToArguments(this.merge, "--merge");
        generatedArguments.addFileToArguments(this.xunitFile, "-x");
        generatedArguments.addNonEmptyStringToArguments(this.logLevel, "-L");
        generatedArguments.addFlagToArguments(true, "--xunitskipnoncritical");
        generatedArguments.addFlagToArguments(this.rpa, "--rpa");
        generatedArguments.addListToArguments(this.removeKeywords, "--removekeywords");
        generatedArguments.addListToArguments(this.flattenKeywords, "--flattenkeywords");
        generatedArguments.add(this.getOutputPath());
        return generatedArguments.toArray();
    }

    private String getOutputPath() {
        return this.outputDirectory + File.separator + "output*.xml";
    }

    public void ensureOutputDirectoryExists() throws IOException {
        if (this.outputDirectory == null) {
            String baseDir = System.getProperty("basedir");
            if (baseDir == null) {
                baseDir = ".";
            }
            this.outputDirectory = new File(this.joinPaths(baseDir, "target", "robotframework-reports"));
        }
        if (!this.outputDirectory.exists() && !this.outputDirectory.mkdirs()) {
            throw new IOException("Target output directory cannot be created: " + this.outputDirectory.getAbsolutePath());
        }
    }

    private String joinPaths(String ... parts) {
        return StringUtils.join((Object[])parts, (String)File.separator);
    }
}

