/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.mavenplugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.codehaus.plexus.util.StringUtils;

public class Arguments {
    private final List<String> arguments = new ArrayList<String>();

    public void addFileToArguments(File file, String flag) {
        if (this.isFileValid(file)) {
            String path = !file.getName().toUpperCase().equals("NONE") ? file.getPath() : file.getName();
            this.add(flag, path);
        }
    }

    protected boolean isFileValid(File file) {
        return file != null && file.getPath() != null && !file.getPath().equals("");
    }

    public void addNonEmptyStringToArguments(String variableToAdd, String flag) {
        if (!StringUtils.isEmpty((String)variableToAdd)) {
            this.addStringToArguments(variableToAdd, flag);
        }
    }

    public void addFlagToArguments(boolean flag, String argument) {
        if (flag) {
            this.add(argument);
        }
    }

    public void addStringToArguments(String variableToAdd, String flag) {
        this.add(flag, variableToAdd);
    }

    public void addListToArguments(String variablesToAdd, String flag) {
        if (variablesToAdd == null) {
            return;
        }
        this.addListToArguments(new ArrayList<String>(Arrays.asList(StringUtils.split((String)variablesToAdd, (String)","))), flag);
    }

    public void addListToArguments(List<String> variablesToAdd, String flag) {
        if (variablesToAdd == null) {
            return;
        }
        for (String variableToAdd : variablesToAdd) {
            if (StringUtils.isEmpty((String)variableToAdd)) continue;
            this.add(flag, variableToAdd);
        }
    }

    public void addFileListToArguments(List<File> variablesToAdd, String flag) {
        if (variablesToAdd == null) {
            return;
        }
        for (File variableToAdd : variablesToAdd) {
            this.addFileToArguments(variableToAdd, flag);
        }
    }

    public void add(String ... values) {
        for (String value : values) {
            this.arguments.add(value);
        }
    }

    public String[] toArray() {
        return this.arguments.toArray(new String[this.arguments.size()]);
    }
}

