/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.mavenplugin;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.plexus.util.StringUtils;
import org.robotframework.RobotFramework;
import org.robotframework.mavenplugin.AbstractMojoWithLoadedClasspath;
import org.robotframework.mavenplugin.Arguments;
import org.robotframework.mavenplugin.PythonRunner;
import org.robotframework.mavenplugin.StreamReader;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AcceptanceTestMojo
extends AbstractMojoWithLoadedClasspath {
    private File testCasesDirectory;
    private String name;
    private String document;
    private List<String> metadata;
    private List<String> tags;
    private List<String> tasks;
    private List<String> tests;
    private List<String> suites;
    private List<String> includes;
    private List<String> excludes;
    private List<String> skips;
    private List<String> skiponfailures;
    private String tests_cli;
    private String tasks_cli;
    private String suites_cli;
    private String includes_cli;
    private String excludes_cli;
    private String skips_cli;
    private String skiponfailures_cli;
    private List<String> criticalTags;
    private List<String> nonCriticalTags;
    private List<String> removeKeywords;
    private List<String> flattenKeywords;
    private String runMode;
    private boolean dryrun;
    private boolean skipTeardownOnExit;
    private boolean exitOnFailure;
    private String randomize;
    private List<String> variables;
    private String variables_cli;
    private List<String> variableFiles;
    private File outputDirectory;
    private File output;
    private File log;
    private File report;
    private File xunitFile;
    private File debugFile;
    private boolean timestampOutputs;
    private String splitOutputs;
    private String logTitle;
    private String reportTitle;
    private String summaryTitle;
    private String reportBackground;
    private String logLevel;
    private String suiteStatLevel;
    private List<String> tagStatIncludes;
    private List<String> tagStatExcludes;
    private List<String> combinedTagStats;
    private List<String> tagDocs;
    private List<String> tagStatLinks;
    private List<String> listeners;
    private String listener;
    private boolean warnOnSkippedFiles;
    private String consoleWidth;
    private String consoleColors;
    private String console;
    private File[] extraPathDirectories;
    private File defaultExtraPath;
    private File argumentFile;
    private boolean skipTests;
    private boolean skipATs;
    private boolean skipITs;
    private boolean skip;
    private boolean runEmptySuite;
    private boolean noStatusReturnCode;
    private boolean rpa;
    private boolean rerunFailed;

    @Override
    protected void subclassExecute() throws MojoExecutionException, MojoFailureException {
        if (this.shouldSkipTests()) {
            this.getLog().info((CharSequence)"RobotFramework tests are skipped.");
            return;
        }
        Object[] runArguments = this.generateRunArguments();
        this.getLog().debug((CharSequence)("robotframework arguments: " + StringUtils.join((Object[])runArguments, (String)" ")));
        this.evaluateReturnCode(this.executeRobot((String[])runArguments));
    }

    private int executeRobot(String[] runArguments) throws MojoExecutionException {
        if (this.externalRunner == null) {
            return RobotFramework.run((String[])runArguments);
        }
        return this.externalExecute(runArguments);
    }

    private int externalExecute(String[] runArguments) throws MojoExecutionException {
        try {
            if (this.externalRunner.getRunWithPython()) {
                return PythonRunner.exec("robot", runArguments);
            }
            return this.exec(this.externalRunner.getRunnerClass(), runArguments, this.externalRunner.getEnvironmentVariables());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Executing external robot failed.", (Exception)e);
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Executing external robot failed.", (Exception)e);
        }
    }

    public int exec(String runnerClass, String[] arguments, Map<String, String> environment) throws IOException, InterruptedException {
        String classpath;
        runnerClass = runnerClass == null ? RobotFramework.class.getCanonicalName() : runnerClass;
        ProcessBuilder builder = new ProcessBuilder(this.createExternalCommand(runnerClass, arguments, this.externalRunner.getJvmArgs()));
        Map<String, String> env = builder.environment();
        String string = classpath = this.externalRunner.getExcludeDependencies() ? this.getRobotJar() : this.getClassPathString();
        if (environment.containsKey("CLASSPATH")) {
            classpath = environment.get("CLASSPATH") + File.pathSeparator + classpath;
        }
        env.putAll(environment);
        env.put("CLASSPATH", classpath);
        Process process = builder.start();
        StreamReader stdout = new StreamReader(process.getInputStream());
        StreamReader stderr = new StreamReader(process.getErrorStream());
        stdout.start();
        stderr.start();
        return process.waitFor();
    }

    private List<String> createExternalCommand(String runnerClass, String[] arguments, List<String> jvmArgs) {
        String javaHome = System.getProperty("java.home");
        String javaBin = AcceptanceTestMojo.join(File.separator, javaHome, "bin", "java");
        ArrayList<String> cmd = new ArrayList<String>();
        cmd.add(javaBin);
        cmd.addAll(jvmArgs);
        cmd.add(runnerClass);
        cmd.addAll(Arrays.asList(arguments));
        System.out.println("Executing Robot with command:");
        System.out.println(cmd);
        return cmd;
    }

    protected void evaluateReturnCode(int robotRunReturnValue) throws MojoFailureException, MojoExecutionException {
        switch (robotRunReturnValue) {
            case 252: {
                this.writeXunitFileWithError("Invalid test data or command line options (Returncode 252).");
                break;
            }
            case 255: {
                this.writeXunitFileWithError("Unexpected internal error (Returncode 255).");
                break;
            }
        }
    }

    private void writeXunitFileWithError(String message) {
        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.newDocument();
            Element testsuite = document.createElement("testsuite");
            testsuite.setAttribute("errors", "1");
            testsuite.setAttribute("failures", "0");
            testsuite.setAttribute("tests", "0");
            testsuite.setAttribute("name", this.getTestSuiteName());
            Element testcase = document.createElement("testcase");
            testcase.setAttribute("classname", "ExecutionError");
            testcase.setAttribute("name", message);
            Element error = document.createElement("error");
            error.setAttribute("message", message);
            testcase.appendChild(error);
            testsuite.appendChild(testcase);
            document.appendChild(testsuite);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource xmlSource = new DOMSource(document);
            File output = this.makeAbsolute(this.outputDirectory, this.xunitFile);
            this.outputDirectory.mkdirs();
            StreamResult outputTarget = new StreamResult(output);
            transformer.transform(xmlSource, outputTarget);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private String getTestSuiteName() {
        String testSuiteName;
        if (this.name != null) {
            testSuiteName = this.name;
        } else {
            String delim = " -_";
            StringTokenizer tokenizer = new StringTokenizer(this.testCasesDirectory.getName(), delim, true);
            StringBuilder sb = new StringBuilder();
            while (tokenizer.hasMoreTokens()) {
                String tokenOrDelim = tokenizer.nextToken();
                if (delim.contains(tokenOrDelim)) {
                    sb.append(tokenOrDelim);
                    continue;
                }
                sb.append(StringUtils.capitalizeFirstLetter((String)tokenOrDelim));
            }
            testSuiteName = sb.toString();
        }
        return testSuiteName;
    }

    private boolean shouldSkipTests() {
        return this.skipTests || this.skipITs || this.skipATs || this.skip;
    }

    private String[] generateRunArguments() {
        Arguments generatedArguments = new Arguments();
        generatedArguments.addFileToArguments(this.outputDirectory, "-d");
        generatedArguments.addFileToArguments(this.output, "-o");
        generatedArguments.addFileToArguments(this.log, "-l");
        generatedArguments.addFileToArguments(this.report, "-r");
        generatedArguments.addFileToArguments(this.debugFile, "-b");
        generatedArguments.addFileToArguments(this.argumentFile, "-A");
        generatedArguments.addNonEmptyStringToArguments(this.console, "--console");
        generatedArguments.addNonEmptyStringToArguments(this.name, "-N");
        generatedArguments.addNonEmptyStringToArguments(this.document, "-D");
        generatedArguments.addNonEmptyStringToArguments(this.runMode, "--runmode");
        generatedArguments.addFlagToArguments(this.rpa, "--rpa");
        generatedArguments.addFlagToArguments(this.dryrun, "--dryrun");
        generatedArguments.addFlagToArguments(this.exitOnFailure, "--exitonfailure");
        generatedArguments.addFlagToArguments(this.skipTeardownOnExit, "--skipteardownonexit");
        generatedArguments.addNonEmptyStringToArguments(this.randomize, "--randomize");
        generatedArguments.addNonEmptyStringToArguments(this.splitOutputs, "--splitoutputs");
        generatedArguments.addNonEmptyStringToArguments(this.logTitle, "--logtitle");
        generatedArguments.addNonEmptyStringToArguments(this.reportTitle, "--reporttitle");
        generatedArguments.addNonEmptyStringToArguments(this.reportBackground, "--reportbackground");
        generatedArguments.addNonEmptyStringToArguments(this.summaryTitle, "--summarytitle");
        generatedArguments.addNonEmptyStringToArguments(this.logLevel, "-L");
        generatedArguments.addNonEmptyStringToArguments(this.suiteStatLevel, "--suitestatlevel");
        generatedArguments.addNonEmptyStringToArguments(this.consoleWidth, "--consolewidth");
        generatedArguments.addNonEmptyStringToArguments(this.consoleColors, "--consolecolors");
        generatedArguments.addNonEmptyStringToArguments(this.listener, "--listener");
        generatedArguments.addFlagToArguments(this.runEmptySuite, "--runemptysuite");
        generatedArguments.addFlagToArguments(this.noStatusReturnCode, "--nostatusrc");
        generatedArguments.addFlagToArguments(this.timestampOutputs, "-T");
        generatedArguments.addFlagToArguments(this.warnOnSkippedFiles, "--warnonskippedfiles");
        generatedArguments.addListToArguments(this.metadata, "-M");
        generatedArguments.addListToArguments(this.tags, "-G");
        generatedArguments.addListToArguments(this.removeKeywords, "--removekeywords");
        generatedArguments.addListToArguments(this.flattenKeywords, "--flattenkeywords");
        if (this.tests_cli != null) {
            generatedArguments.addListToArguments(this.tests_cli, "-t");
        } else {
            generatedArguments.addListToArguments(this.tests, "-t");
        }
        if (this.tasks_cli != null) {
            generatedArguments.addListToArguments(this.tasks_cli, "--task");
        } else {
            generatedArguments.addListToArguments(this.tasks, "--task");
        }
        if (this.suites_cli != null) {
            generatedArguments.addListToArguments(this.suites_cli, "-s");
        } else {
            generatedArguments.addListToArguments(this.suites, "-s");
        }
        if (this.includes_cli != null) {
            generatedArguments.addListToArguments(this.includes_cli, "-i");
        } else {
            generatedArguments.addListToArguments(this.includes, "-i");
        }
        if (this.excludes_cli != null) {
            generatedArguments.addListToArguments(this.excludes_cli, "-e");
        } else {
            generatedArguments.addListToArguments(this.excludes, "-e");
        }
        if (this.skips_cli != null) {
            generatedArguments.addListToArguments(this.skips_cli, "--skip");
        } else {
            generatedArguments.addListToArguments(this.skips, "--skip");
        }
        if (this.skiponfailures_cli != null) {
            generatedArguments.addListToArguments(this.skiponfailures_cli, "--skiponfailure");
        } else {
            generatedArguments.addListToArguments(this.skiponfailures, "--skiponfailure");
        }
        generatedArguments.addListToArguments(this.criticalTags, "-c");
        generatedArguments.addListToArguments(this.nonCriticalTags, "-n");
        generatedArguments.addListToArguments(this.variables, "-v");
        if (this.variables_cli != null) {
            generatedArguments.addListToArguments(this.variables_cli, "-v");
        }
        generatedArguments.addListToArguments(this.variableFiles, "-V");
        generatedArguments.addListToArguments(this.tagStatIncludes, "--tagstatinclude");
        generatedArguments.addListToArguments(this.tagStatExcludes, "--tagstatexclude");
        generatedArguments.addListToArguments(this.combinedTagStats, "--tagstatcombine");
        generatedArguments.addListToArguments(this.tagDocs, "--tagdoc");
        generatedArguments.addListToArguments(this.tagStatLinks, "--tagstatlink");
        generatedArguments.addListToArguments(this.listeners, "--listener");
        if (this.extraPathDirectories == null) {
            generatedArguments.addFileToArguments(this.defaultExtraPath, "-P");
        } else {
            generatedArguments.addFileListToArguments(Arrays.asList(this.extraPathDirectories), "-P");
        }
        if (this.xunitFile == null) {
            String testCasesFolderName = this.testCasesDirectory.getName();
            this.xunitFile = new File("TEST-" + testCasesFolderName.replace(' ', '_') + ".xml");
        }
        generatedArguments.addFileToArguments(this.xunitFile, "-x");
        generatedArguments.addFlagToArguments(true, "--xunitskipnoncritical");
        if (this.rerunFailed) {
            generatedArguments.addFileToArguments(this.output, "--rerunfailed");
        }
        generatedArguments.addFileToArguments(this.output, "-o");
        generatedArguments.add(this.testCasesDirectory.getPath());
        return generatedArguments.toArray();
    }
}

