/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;

public class TempDirectory {
    private final Path basePath;

    public TempDirectory() {
        this("test-dir");
    }

    public TempDirectory(String name) {
        try {
            String string = String.valueOf(name);
            this.basePath = Files.createTempDirectory(string.length() != 0 ? "robolectric-".concat(string) : new String("robolectric-"), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            @Override
            public void run() {
                TempDirectory.this.destroy();
            }
        }));
    }

    public Path createFile(String name, String contents) {
        Path path = this.basePath.resolve(name);
        try (BufferedWriter out = Files.newBufferedWriter(path, new OpenOption[0]);){
            out.write(contents);
        }
        catch (IOException e) {
            String string = String.valueOf(name);
            throw new RuntimeException(string.length() != 0 ? "failed writing to ".concat(string) : new String("failed writing to "), e);
        }
        return path;
    }

    public Path create(String name) {
        Path path = this.basePath.resolve(name);
        try {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    public Path createIfNotExists(String name) {
        Path path = this.basePath.resolve(name);
        try {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    public void destroy() {
        try {
            this.clearDirectory(this.basePath);
            Files.delete(this.basePath);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void clearDirectory(final Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(this){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                if (!dir.equals(directory)) {
                    Files.delete(dir);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

