/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.util;

public class Logger {
    private static final String LOGGING_ENABLED = "robolectric.logging.enabled";

    public static void strict(String message, Throwable e) {
        if (Logger.loggingEnabled()) {
            System.out.print("WARNING: ");
            System.out.println(message);
            e.printStackTrace();
        }
    }

    public static void strict(String message, Object ... args) {
        if (Logger.loggingEnabled()) {
            System.out.print("WARNING: ");
            System.out.printf(String.valueOf(message).concat("%n"), args);
        }
    }

    public static void info(String message, Object ... args) {
        if (Logger.loggingEnabled()) {
            System.out.print("INFO: ");
            System.out.printf(String.valueOf(message).concat("%n"), args);
        }
    }

    public static void warn(String message, Object ... args) {
        if (Logger.loggingEnabled()) {
            System.out.print("WARN: ");
            System.out.printf(String.valueOf(message).concat("%n"), args);
        }
    }

    public static void error(String message, Throwable e) {
        System.err.print("ERROR: ");
        System.err.println(message);
        e.printStackTrace();
    }

    public static void error(String message, Object ... args) {
        System.err.print("ERROR: ");
        System.err.printf(String.valueOf(message).concat("%n"), args);
    }

    public static void debug(String message, Object ... args) {
        if (Logger.loggingEnabled()) {
            System.out.print("DEBUG: ");
            System.out.printf(String.valueOf(message).concat("%n"), args);
        }
    }

    public static void lifecycle(String message, Object ... args) {
        if (Logger.loggingEnabled()) {
            System.out.printf(String.valueOf(message).concat("%n"), args);
        }
    }

    public static boolean loggingEnabled() {
        return Boolean.getBoolean(LOGGING_ENABLED);
    }
}

