/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ClipData;
import android.graphics.Rect;
import android.os.Binder;
import android.os.Build;
import android.os.IBinder;
import android.os.Looper;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.view.DisplayCutout;
import android.view.IWindow;
import android.view.IWindowManager;
import android.view.IWindowSession;
import android.view.InputChannel;
import android.view.InsetsSourceControl;
import android.view.InsetsState;
import android.view.InsetsVisibilities;
import android.view.Surface;
import android.view.SurfaceControl;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import androidx.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowView;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=WindowManagerGlobal.class, isInAndroidSdk=false, minSdk=17, looseSignatures=true)
public class ShadowWindowManagerGlobal {
    private static WindowSessionDelegate windowSessionDelegate;
    private static IWindowSession windowSession;

    @Resetter
    public static void reset() {
        ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).setDefaultWindowManager(null);
        windowSessionDelegate = null;
        windowSession = null;
    }

    private static synchronized WindowSessionDelegate getWindowSessionDelegate() {
        if (windowSessionDelegate == null) {
            int apiLevel = RuntimeEnvironment.getApiLevel();
            windowSessionDelegate = apiLevel >= 32 ? new WindowSessionDelegateSV2() : (apiLevel >= 31 ? new WindowSessionDelegateS() : (apiLevel >= 30 ? new WindowSessionDelegateR() : (apiLevel >= 29 ? new WindowSessionDelegateQ() : (apiLevel >= 28 ? new WindowSessionDelegateP() : (apiLevel >= 23 ? new WindowSessionDelegateM() : (apiLevel >= 22 ? new WindowSessionDelegateLMR1() : (apiLevel >= 17 ? new WindowSessionDelegateJBMR1() : new WindowSessionDelegateJB())))))));
        }
        return windowSessionDelegate;
    }

    public static boolean getInTouchMode() {
        return ShadowWindowManagerGlobal.getWindowSessionDelegate().getInTouchMode();
    }

    static void setInTouchMode(boolean inTouchMode) {
        ShadowWindowManagerGlobal.getWindowSessionDelegate().setInTouchMode(inTouchMode);
    }

    @Nullable
    public static ClipData getLastDragClipData() {
        return windowSessionDelegate != null ? ShadowWindowManagerGlobal.windowSessionDelegate.lastDragClipData : null;
    }

    public static void clearLastDragClipData() {
        if (windowSessionDelegate != null) {
            ShadowWindowManagerGlobal.windowSessionDelegate.lastDragClipData = null;
        }
    }

    @Implementation(minSdk=18)
    protected static synchronized IWindowSession getWindowSession() {
        if (windowSession == null) {
            windowSession = (IWindowSession)ReflectionHelpers.createDelegatingProxy(IWindowSession.class, (Object)ShadowWindowManagerGlobal.getWindowSessionDelegate());
        }
        return windowSession;
    }

    @Implementation(maxSdk=17)
    protected static Object getWindowSession(Looper looper) {
        return ShadowWindowManagerGlobal.getWindowSession();
    }

    @Implementation
    protected static synchronized IWindowSession peekWindowSession() {
        return windowSession;
    }

    @Implementation
    public static Object getWindowManagerService() throws RemoteException {
        IWindowManager service = ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).getWindowManagerService();
        if (service == null) {
            service = IWindowManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"window"));
            ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).setWindowManagerService(service);
            if (Build.VERSION.SDK_INT >= 30) {
                ((WindowManagerGlobalReflector)Reflector.reflector(WindowManagerGlobalReflector.class)).setUseBlastAdapter(service.useBLAST());
            }
        }
        return service;
    }

    private static class WindowSessionDelegateSV2
    extends WindowSessionDelegateS {
        private WindowSessionDelegateSV2() {
        }

        public int addToDisplayAsUser(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int displayId, int userId, InsetsVisibilities requestedVisibilities, InputChannel outInputChannel, InsetsState outInsetsState, InsetsSourceControl[] outActiveControls) {
            return this.getAddFlags();
        }
    }

    private static class WindowSessionDelegateS
    extends WindowSessionDelegateR {
        private WindowSessionDelegateS() {
        }

        public int addToDisplayAsUser(IWindow window, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, int userId, InsetsState requestedVisibility, InputChannel outInputChannel, InsetsState insetsState, InsetsSourceControl[] activeControls) {
            return this.getAddFlags();
        }
    }

    private static class WindowSessionDelegateR
    extends WindowSessionDelegateQ {
        private WindowSessionDelegateR() {
        }

        public int addToDisplayAsUser(IWindow window, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, int userId, Rect outFrame, Rect outContentInsets, Rect outStableInsets, DisplayCutout.ParcelableWrapper displayCutout, InputChannel outInputChannel, InsetsState insetsState, InsetsSourceControl[] activeControls) {
            return this.getAddFlags();
        }
    }

    private static class WindowSessionDelegateQ
    extends WindowSessionDelegateP {
        private WindowSessionDelegateQ() {
        }

        public int addToDisplay(IWindow window, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, Rect outFrame, Rect outContentInsets, Rect outStableInsets, Rect outOutsets, DisplayCutout.ParcelableWrapper displayCutout, InputChannel outInputChannel, InsetsState insetsState) {
            return this.getAddFlags();
        }
    }

    private static class WindowSessionDelegateP
    extends WindowSessionDelegateM {
        private WindowSessionDelegateP() {
        }

        public int addToDisplay(IWindow window, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, Rect outFrame, Rect outContentInsets, Rect outStableInsets, Rect outOutsets, DisplayCutout.ParcelableWrapper displayCutout, InputChannel outInputChannel) {
            return this.getAddFlags();
        }

        public IBinder performDrag(IWindow window, int flags, SurfaceControl surface, int touchSource, float touchX, float touchY, float thumbCenterX, float thumbCenterY, ClipData data) {
            this.lastDragClipData = data;
            return new Binder();
        }
    }

    private static class WindowSessionDelegateM
    extends WindowSessionDelegateLMR1 {
        private WindowSessionDelegateM() {
        }

        public int addToDisplay(IWindow window, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, Rect outContentInsets, Rect outStableInsets, Rect outInsets, InputChannel outInputChannel) {
            return this.getAddFlags();
        }
    }

    private static class WindowSessionDelegateLMR1
    extends WindowSessionDelegateJBMR1 {
        private WindowSessionDelegateLMR1() {
        }

        public int addToDisplay(IWindow window, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, Rect outContentInsets, Rect outStableInsets, InputChannel outInputChannel) {
            return this.getAddFlags();
        }
    }

    private static class WindowSessionDelegateJBMR1
    extends WindowSessionDelegateJB {
        private WindowSessionDelegateJBMR1() {
        }

        public int addToDisplay(IWindow window, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, Rect outContentInsets, InputChannel outInputChannel) {
            return this.getAddFlags();
        }
    }

    private static class WindowSessionDelegateJB
    extends WindowSessionDelegate {
        private WindowSessionDelegateJB() {
        }

        public int add(IWindow window, int seq, WindowManager.LayoutParams attrs, int viewVisibility, int layerStackId, Rect outContentInsets, InputChannel outInputChannel) {
            return this.getAddFlags();
        }
    }

    private static abstract class WindowSessionDelegate {
        static final int ADD_FLAG_IN_TOUCH_MODE = 1;
        static final int ADD_FLAG_APP_VISIBLE = 2;
        private boolean inTouchMode = ShadowView.useRealGraphics();
        @Nullable
        protected ClipData lastDragClipData;

        private WindowSessionDelegate() {
        }

        protected int getAddFlags() {
            int res = 0;
            if (ShadowView.useRealGraphics() || "true".equals(System.getProperty("robolectric.areWindowsMarkedVisible", "false"))) {
                res |= 2;
            }
            if (this.getInTouchMode()) {
                res |= 1;
            }
            return res;
        }

        public boolean getInTouchMode() {
            return this.inTouchMode;
        }

        public void setInTouchMode(boolean inTouchMode) {
            this.inTouchMode = inTouchMode;
        }

        public IBinder prepareDrag(IWindow window, int flags, int thumbnailWidth, int thumbnailHeight, Surface outSurface) {
            return new Binder();
        }

        public boolean performDrag(IWindow window, IBinder dragToken, float touchX, float touchY, float thumbCenterX, float thumbCenterY, ClipData data) {
            this.lastDragClipData = data;
            return true;
        }

        public boolean performDrag(IWindow window, IBinder dragToken, int touchSource, float touchX, float touchY, float thumbCenterX, float thumbCenterY, ClipData data) {
            this.lastDragClipData = data;
            return true;
        }
    }

    @ForType(value=WindowManagerGlobal.class)
    static interface WindowManagerGlobalReflector {
        @Accessor(value="sDefaultWindowManager")
        @Static
        public void setDefaultWindowManager(WindowManagerGlobal var1);

        @Static
        @Accessor(value="sWindowManagerService")
        public IWindowManager getWindowManagerService();

        @Static
        @Accessor(value="sWindowManagerService")
        public void setWindowManagerService(IWindowManager var1);

        @Static
        @Accessor(value="sUseBLASTAdapter")
        public void setUseBlastAdapter(boolean var1);
    }
}

