/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowValueAnimator;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=Settings.class)
public class ShadowSettings {
    private static boolean canDrawOverlays = false;

    public static void setAirplaneMode(boolean isAirplaneMode) {
        Settings.Global.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"airplane_mode_on", (int)(isAirplaneMode ? 1 : 0));
        Settings.System.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"airplane_mode_on", (int)(isAirplaneMode ? 1 : 0));
    }

    public static void setWifiOn(boolean isOn) {
        Settings.Global.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"wifi_on", (int)(isOn ? 1 : 0));
        Settings.System.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"wifi_on", (int)(isOn ? 1 : 0));
    }

    public static void set24HourTimeFormat(boolean use24HourTimeFormat) {
        Settings.System.putString((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"time_12_24", (String)(use24HourTimeFormat ? "24" : "12"));
    }

    @Implementation(minSdk=23)
    protected static boolean canDrawOverlays(Context context) {
        return canDrawOverlays;
    }

    public static void setCanDrawOverlays(boolean canDrawOverlays) {
        ShadowSettings.canDrawOverlays = canDrawOverlays;
    }

    public static void setAdbEnabled(boolean adbEnabled) {
        if (Build.VERSION.SDK_INT >= 17) {
            Settings.Global.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"adb_enabled", (int)(adbEnabled ? 1 : 0));
        }
        Settings.Secure.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"adb_enabled", (int)(adbEnabled ? 1 : 0));
    }

    public static void setInstallNonMarketApps(boolean installNonMarketApps) {
        if (Build.VERSION.SDK_INT >= 17) {
            Settings.Global.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"install_non_market_apps", (int)(installNonMarketApps ? 1 : 0));
        }
        Settings.Secure.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"install_non_market_apps", (int)(installNonMarketApps ? 1 : 0));
    }

    public static void setLockScreenShowNotifications(boolean lockScreenShowNotifications) {
        Settings.Secure.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"lock_screen_show_notifications", (int)(lockScreenShowNotifications ? 1 : 0));
    }

    public static void setLockScreenAllowPrivateNotifications(boolean lockScreenAllowPrivateNotifications) {
        Settings.Secure.putInt((ContentResolver)RuntimeEnvironment.getApplication().getContentResolver(), (String)"lock_screen_allow_private_notifications", (int)(lockScreenAllowPrivateNotifications ? 1 : 0));
    }

    @Resetter
    public static void reset() {
        canDrawOverlays = false;
    }

    @Implements(value=Settings.Global.class, minSdk=17)
    public static class ShadowGlobal {
        private static final ImmutableMap<String, Optional<Object>> DEFAULTS = ImmutableMap.builder().put((Object)"animator_duration_scale", Optional.of(1)).build();
        private static final Map<String, Optional<Object>> settings = new ConcurrentHashMap<String, Optional<Object>>((Map<String, Optional<Object>>)DEFAULTS);

        @Implementation
        protected static boolean putInt(ContentResolver cr, String name, int value) {
            return ShadowGlobal.put(cr, name, value);
        }

        @Implementation
        protected static int getInt(ContentResolver cr, String name, int def) {
            return ShadowGlobal.get(Integer.class, name).orElse(def);
        }

        @Implementation
        protected static int getInt(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            return ShadowGlobal.get(Integer.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name));
        }

        @Implementation
        protected static boolean putString(ContentResolver cr, String name, String value) {
            return ShadowGlobal.put(cr, name, value);
        }

        @Implementation
        protected static String getString(ContentResolver cr, String name) {
            return ShadowGlobal.get(String.class, name).orElse(null);
        }

        @Implementation(minSdk=17)
        protected static String getStringForUser(ContentResolver cr, String name, int userHandle) {
            return ShadowGlobal.getString(cr, name);
        }

        @Implementation
        protected static boolean putLong(ContentResolver cr, String name, long value) {
            return ShadowGlobal.put(cr, name, value);
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name, long def) {
            return ShadowGlobal.get(Long.class, name).orElse(def);
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            return ShadowGlobal.get(Long.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name));
        }

        @Implementation
        protected static boolean putFloat(ContentResolver cr, String name, float value) {
            boolean result = ShadowGlobal.put(cr, name, Float.valueOf(value));
            if ("animator_duration_scale".equals(name)) {
                ShadowValueAnimator.setDurationScale(value);
            }
            return result;
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name, float def) {
            return ShadowGlobal.get(Float.class, name).orElse(Float.valueOf(def)).floatValue();
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            return ShadowGlobal.get(Float.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name)).floatValue();
        }

        private static boolean put(ContentResolver cr, String name, Object value) {
            if (!Objects.equals(settings.put(name, Optional.ofNullable(value)), Optional.ofNullable(value)) && cr != null) {
                cr.notifyChange(Settings.Global.getUriFor((String)name), null);
            }
            return true;
        }

        private static <T> Optional<T> get(Class<T> type, String name) {
            return settings.getOrDefault(name, Optional.empty()).filter(type::isInstance).map(type::cast);
        }

        @Resetter
        public static void reset() {
            settings.clear();
            settings.putAll((Map<String, Optional<Object>>)DEFAULTS);
        }
    }

    @Implements(value=Settings.Secure.class)
    public static class ShadowSecure {
        private static final HashMap<String, Optional<Object>> SECURE_DEFAULTS = new HashMap();
        static final boolean INITIAL_GPS_PROVIDER_STATE = true;
        static final boolean INITIAL_NETWORK_PROVIDER_STATE = false;
        private static final Map<String, Optional<Object>> dataMap;

        @Implementation(minSdk=17, maxSdk=28)
        protected static boolean setLocationProviderEnabledForUser(ContentResolver cr, String provider, boolean enabled, int uid) {
            return ShadowSecure.updateEnabledProviders(cr, provider, enabled);
        }

        @Implementation(maxSdk=16)
        protected static void setLocationProviderEnabled(ContentResolver cr, String provider, boolean enabled) {
            ShadowSecure.updateEnabledProviders(cr, provider, enabled);
        }

        static boolean updateEnabledProviders(ContentResolver cr, String provider, boolean enabled) {
            HashSet<String> providers = new HashSet<String>();
            String oldProviders = Settings.Secure.getString((ContentResolver)cr, (String)"location_providers_allowed");
            if (!TextUtils.isEmpty((CharSequence)oldProviders)) {
                providers.addAll(Arrays.asList(oldProviders.split(",")));
            }
            if (enabled == oldProviders.contains(provider)) {
                return true;
            }
            if (enabled) {
                providers.add(provider);
            } else {
                providers.remove(provider);
            }
            String newProviders = TextUtils.join((CharSequence)",", (Object[])providers.toArray());
            boolean r = Settings.Secure.putString((ContentResolver)cr, (String)"location_providers_allowed", (String)newProviders);
            Intent providersBroadcast = new Intent("android.location.PROVIDERS_CHANGED");
            if (RuntimeEnvironment.getApiLevel() >= 29) {
                providersBroadcast.putExtra("android.location.extra.PROVIDER_NAME", provider);
            }
            if (RuntimeEnvironment.getApiLevel() >= 30) {
                providersBroadcast.putExtra("android.location.extra.PROVIDER_ENABLED", enabled);
            }
            RuntimeEnvironment.getApplication().sendBroadcast(providersBroadcast);
            return r;
        }

        @Implementation
        protected static boolean putInt(ContentResolver cr, String name, int value) {
            boolean changed;
            boolean bl = changed = !Objects.equals(dataMap.put(name, Optional.of(value)), Optional.of(value));
            if ("location_mode".equals(name)) {
                if (RuntimeEnvironment.getApiLevel() <= 28) {
                    boolean gps = value == 1 || value == 3;
                    boolean network = value == 2 || value == 3;
                    Settings.Secure.setLocationProviderEnabled((ContentResolver)cr, (String)"gps", (boolean)gps);
                    Settings.Secure.setLocationProviderEnabled((ContentResolver)cr, (String)"network", (boolean)network);
                }
                Intent modeBroadcast = new Intent("android.location.MODE_CHANGED");
                if (RuntimeEnvironment.getApiLevel() >= 30) {
                    modeBroadcast.putExtra("android.location.extra.LOCATION_ENABLED", value != 0);
                }
                RuntimeEnvironment.getApplication().sendBroadcast(modeBroadcast);
            }
            if (changed && cr != null) {
                cr.notifyChange(Settings.Secure.getUriFor((String)name), null);
            }
            return true;
        }

        @Implementation(minSdk=21)
        protected static boolean putIntForUser(ContentResolver cr, String name, int value, int userHandle) {
            ShadowSecure.putInt(cr, name, value);
            return true;
        }

        @Implementation(minSdk=17)
        protected static int getIntForUser(ContentResolver cr, String name, int def, int userHandle) {
            return ShadowSecure.getInt(cr, name, def);
        }

        @Implementation(minSdk=17)
        protected static int getIntForUser(ContentResolver cr, String name, int userHandle) throws Settings.SettingNotFoundException {
            return ShadowSecure.getInt(cr, name);
        }

        @Implementation
        protected static int getInt(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            if ("location_mode".equals(name) && RuntimeEnvironment.getApiLevel() >= 19 && RuntimeEnvironment.getApiLevel() < 28) {
                return (Integer)Shadow.directlyOn(Settings.Secure.class, (String)"getLocationModeForUser", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(ContentResolver.class, (Object)cr), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0)});
            }
            return ShadowSecure.get(Integer.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name));
        }

        @Implementation
        protected static int getInt(ContentResolver cr, String name, int def) {
            if ("location_mode".equals(name) && RuntimeEnvironment.getApiLevel() >= 19 && RuntimeEnvironment.getApiLevel() < 28) {
                return (Integer)Shadow.directlyOn(Settings.Secure.class, (String)"getLocationModeForUser", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(ContentResolver.class, (Object)cr), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0)});
            }
            return ShadowSecure.get(Integer.class, name).orElse(def);
        }

        @Implementation
        protected static boolean putString(ContentResolver cr, String name, String value) {
            return ShadowSecure.put(cr, name, value);
        }

        @Implementation
        protected static String getString(ContentResolver cr, String name) {
            return ShadowSecure.get(String.class, name).orElse(null);
        }

        @Implementation(minSdk=17)
        protected static String getStringForUser(ContentResolver cr, String name, int userHandle) {
            return ShadowSecure.getString(cr, name);
        }

        @Implementation
        protected static boolean putLong(ContentResolver cr, String name, long value) {
            return ShadowSecure.put(cr, name, value);
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name, long def) {
            return ShadowSecure.get(Long.class, name).orElse(def);
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            return ShadowSecure.get(Long.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name));
        }

        @Implementation
        protected static boolean putFloat(ContentResolver cr, String name, float value) {
            return ShadowSecure.put(cr, name, Float.valueOf(value));
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name, float def) {
            return ShadowSecure.get(Float.class, name).orElse(Float.valueOf(def)).floatValue();
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            return ShadowSecure.get(Float.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name)).floatValue();
        }

        private static boolean put(ContentResolver cr, String name, Object value) {
            if (!Objects.equals(dataMap.put(name, Optional.ofNullable(value)), Optional.ofNullable(value)) && cr != null) {
                cr.notifyChange(Settings.Secure.getUriFor((String)name), null);
            }
            return true;
        }

        private static <T> Optional<T> get(Class<T> type, String name) {
            return dataMap.getOrDefault(name, Optional.empty()).filter(type::isInstance).map(type::cast);
        }

        @Resetter
        public static void reset() {
            dataMap.clear();
            dataMap.putAll(SECURE_DEFAULTS);
        }

        static {
            SECURE_DEFAULTS.put("location_mode", Optional.of(1));
            SECURE_DEFAULTS.put("location_providers_allowed", Optional.of("gps"));
            dataMap = new ConcurrentHashMap<String, Optional<Object>>(SECURE_DEFAULTS);
        }
    }

    @Implements(value=Settings.System.class)
    public static class ShadowSystem {
        private static final ImmutableMap<String, Optional<Object>> DEFAULTS = ImmutableMap.builder().put((Object)"animator_duration_scale", Optional.of(1)).build();
        private static final Map<String, Optional<Object>> settings = new ConcurrentHashMap<String, Optional<Object>>((Map<String, Optional<Object>>)DEFAULTS);

        @Implementation
        protected static boolean putInt(ContentResolver cr, String name, int value) {
            return ShadowSystem.put(cr, name, value);
        }

        @Implementation
        protected static int getInt(ContentResolver cr, String name, int def) {
            return ShadowSystem.get(Integer.class, name).orElse(def);
        }

        @Implementation
        protected static int getInt(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            return ShadowSystem.get(Integer.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name));
        }

        @Implementation
        protected static boolean putString(ContentResolver cr, String name, String value) {
            return ShadowSystem.put(cr, name, value);
        }

        @Implementation
        protected static String getString(ContentResolver cr, String name) {
            return ShadowSystem.get(String.class, name).orElse(null);
        }

        @Implementation(minSdk=17)
        protected static String getStringForUser(ContentResolver cr, String name, int userHandle) {
            return ShadowSystem.get(String.class, name).orElse(null);
        }

        @Implementation
        protected static boolean putLong(ContentResolver cr, String name, long value) {
            return ShadowSystem.put(cr, name, value);
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name, long def) {
            return ShadowSystem.get(Long.class, name).orElse(def);
        }

        @Implementation
        protected static long getLong(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            return ShadowSystem.get(Long.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name));
        }

        @Implementation
        protected static boolean putFloat(ContentResolver cr, String name, float value) {
            boolean result = ShadowSystem.put(cr, name, Float.valueOf(value));
            if ("window_animation_scale".equals(name)) {
                ShadowValueAnimator.setDurationScale(value);
            }
            return result;
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name, float def) {
            return ShadowSystem.get(Float.class, name).orElse(Float.valueOf(def)).floatValue();
        }

        @Implementation
        protected static float getFloat(ContentResolver cr, String name) throws Settings.SettingNotFoundException {
            return ShadowSystem.get(Float.class, name).orElseThrow(() -> new Settings.SettingNotFoundException(name)).floatValue();
        }

        private static boolean put(ContentResolver cr, String name, Object value) {
            if (!Objects.equals(settings.put(name, Optional.ofNullable(value)), Optional.ofNullable(value)) && cr != null) {
                cr.notifyChange(Settings.System.getUriFor((String)name), null);
            }
            return true;
        }

        private static <T> Optional<T> get(Class<T> type, String name) {
            return settings.getOrDefault(name, Optional.empty()).filter(type::isInstance).map(type::cast);
        }

        @Resetter
        public static void reset() {
            settings.clear();
            settings.putAll((Map<String, Optional<Object>>)DEFAULTS);
        }
    }
}

