/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.Icon;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import androidx.annotation.Nullable;
import java.util.concurrent.Executor;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Icon.class, minSdk=23)
public class ShadowIcon {
    @Nullable
    private static Executor executorOverride;
    @RealObject
    private Icon realIcon;

    public static void overrideExecutor(Executor executor) {
        executorOverride = executor;
    }

    @HiddenApi
    @Implementation
    public int getType() {
        return ((IconReflector)Reflector.reflector(IconReflector.class, (Object)this.realIcon)).getType();
    }

    @HiddenApi
    @Implementation
    public int getResId() {
        return ((IconReflector)Reflector.reflector(IconReflector.class, (Object)this.realIcon)).getResId();
    }

    @HiddenApi
    @Implementation
    public Bitmap getBitmap() {
        return ((IconReflector)Reflector.reflector(IconReflector.class, (Object)this.realIcon)).getBitmap();
    }

    @HiddenApi
    @Implementation
    public Uri getUri() {
        return ((IconReflector)Reflector.reflector(IconReflector.class, (Object)this.realIcon)).getUri();
    }

    @HiddenApi
    @Implementation
    public int getDataLength() {
        return ((IconReflector)Reflector.reflector(IconReflector.class, (Object)this.realIcon)).getDataLength();
    }

    @HiddenApi
    @Implementation
    public int getDataOffset() {
        return ((IconReflector)Reflector.reflector(IconReflector.class, (Object)this.realIcon)).getDataOffset();
    }

    @HiddenApi
    @Implementation
    public byte[] getDataBytes() {
        return ((IconReflector)Reflector.reflector(IconReflector.class, (Object)this.realIcon)).getDataBytes();
    }

    @Implementation
    protected void loadDrawableAsync(Context context, Message andThen) {
        if (executorOverride != null) {
            executorOverride.execute(() -> {
                andThen.obj = this.realIcon.loadDrawable(context);
                andThen.sendToTarget();
            });
        } else {
            ((IconReflector)Reflector.reflector(IconReflector.class, (Object)this.realIcon)).loadDrawableAsync(context, andThen);
        }
    }

    @Implementation
    protected void loadDrawableAsync(Context context, Icon.OnDrawableLoadedListener listener, Handler handler) {
        if (executorOverride != null) {
            executorOverride.execute(() -> {
                Drawable result = this.realIcon.loadDrawable(context);
                handler.post(() -> listener.onDrawableLoaded(result));
            });
        } else {
            ((IconReflector)Reflector.reflector(IconReflector.class, (Object)this.realIcon)).loadDrawableAsync(context, listener, handler);
        }
    }

    @ForType(value=Icon.class)
    static interface IconReflector {
        @Direct
        public int getType();

        @Direct
        public int getResId();

        @Direct
        public Bitmap getBitmap();

        @Direct
        public Uri getUri();

        @Direct
        public int getDataLength();

        @Direct
        public int getDataOffset();

        @Direct
        public byte[] getDataBytes();

        @Direct
        public void loadDrawableAsync(Context var1, Message var2);

        @Direct
        public void loadDrawableAsync(Context var1, Icon.OnDrawableLoadedListener var2, Handler var3);
    }
}

