/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.graphics.Bitmap;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowBitmap;
import org.robolectric.shadows.ShadowBitmapDrawable;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Drawable.class)
public class ShadowDrawable {
    private static int defaultIntrinsicWidth = -1;
    private static int defaultIntrinsicHeight = -1;
    static final List<String> corruptStreamSources = new ArrayList<String>();
    @RealObject
    Drawable realDrawable;
    int createdFromResId = -1;
    InputStream createdFromInputStream;
    private int intrinsicWidth = defaultIntrinsicWidth;
    private int intrinsicHeight = defaultIntrinsicHeight;
    private boolean wasInvalidated;

    @Implementation
    protected static Drawable createFromStream(InputStream is, String srcName) {
        if (corruptStreamSources.contains(srcName)) {
            return null;
        }
        BitmapDrawable drawable = new BitmapDrawable((Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]));
        ShadowBitmapDrawable shadowBitmapDrawable = (ShadowBitmapDrawable)Shadow.extract((Object)drawable);
        shadowBitmapDrawable.createdFromInputStream = is;
        shadowBitmapDrawable.drawableCreateFromStreamSource = srcName;
        shadowBitmapDrawable.validate();
        return drawable;
    }

    @Implementation
    protected static Drawable createFromPath(String pathName) {
        BitmapDrawable drawable = new BitmapDrawable((Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]));
        ShadowBitmapDrawable shadowBitmapDrawable = (ShadowBitmapDrawable)Shadow.extract((Object)drawable);
        shadowBitmapDrawable.drawableCreateFromPath = pathName;
        shadowBitmapDrawable.validate();
        return drawable;
    }

    public static Drawable createFromResourceId(int resourceId) {
        Bitmap bitmap = (Bitmap)ReflectionHelpers.callConstructor(Bitmap.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[0]);
        ShadowBitmap shadowBitmap = (ShadowBitmap)Shadow.extract((Object)bitmap);
        shadowBitmap.createdFromResId = resourceId;
        BitmapDrawable drawable = new BitmapDrawable(bitmap);
        ShadowBitmapDrawable shadowBitmapDrawable = (ShadowBitmapDrawable)Shadow.extract((Object)drawable);
        shadowBitmapDrawable.validate();
        shadowBitmapDrawable.createdFromResId = resourceId;
        return drawable;
    }

    protected void setCreatedFromResId(int createdFromResId, String resourceName) {
        this.createdFromResId = createdFromResId;
    }

    @Implementation
    protected int getIntrinsicWidth() {
        return this.intrinsicWidth;
    }

    @Implementation
    protected int getIntrinsicHeight() {
        return this.intrinsicHeight;
    }

    public static void addCorruptStreamSource(String src) {
        corruptStreamSources.add(src);
    }

    @Resetter
    public static void clearCorruptStreamSources() {
        corruptStreamSources.clear();
    }

    public static void setDefaultIntrinsicWidth(int defaultIntrinsicWidth) {
        ShadowDrawable.defaultIntrinsicWidth = defaultIntrinsicWidth;
    }

    public static void setDefaultIntrinsicHeight(int defaultIntrinsicHeight) {
        ShadowDrawable.defaultIntrinsicHeight = defaultIntrinsicHeight;
    }

    public void setIntrinsicWidth(int intrinsicWidth) {
        this.intrinsicWidth = intrinsicWidth;
    }

    public void setIntrinsicHeight(int intrinsicHeight) {
        this.intrinsicHeight = intrinsicHeight;
    }

    public InputStream getInputStream() {
        return this.createdFromInputStream;
    }

    @Implementation
    protected void invalidateSelf() {
        this.wasInvalidated = true;
        ((DrawableReflector)Reflector.reflector(DrawableReflector.class, (Object)this.realDrawable)).invalidateSelf();
    }

    public int getCreatedFromResId() {
        return this.createdFromResId;
    }

    public boolean wasInvalidated() {
        return this.wasInvalidated;
    }

    public void validate() {
        this.wasInvalidated = false;
    }

    @ForType(value=Drawable.class)
    static interface DrawableReflector {
        @Direct
        public void invalidateSelf();
    }
}

