/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.speech.IRecognitionService;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import java.util.Queue;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;
import org.robolectric.util.reflector.Static;

@Implements(value=SpeechRecognizer.class)
public class ShadowSpeechRecognizer {
    @RealObject
    SpeechRecognizer realSpeechRecognizer;
    private static SpeechRecognizer latestSpeechRecognizer;
    private Intent recognizerIntent;
    private RecognitionListener recognitionListener;

    public static SpeechRecognizer getLatestSpeechRecognizer() {
        return latestSpeechRecognizer;
    }

    public Intent getLastRecognizerIntent() {
        return this.recognizerIntent;
    }

    @Resetter
    public static void reset() {
        latestSpeechRecognizer = null;
    }

    @Implementation
    protected static SpeechRecognizer createSpeechRecognizer(Context context, ComponentName serviceComponent) {
        SpeechRecognizer result;
        latestSpeechRecognizer = result = ((SpeechRecognizerReflector)Reflector.reflector(SpeechRecognizerReflector.class)).createSpeechRecognizer(context, serviceComponent);
        return result;
    }

    @Implementation
    protected void startListening(Intent recognizerIntent) {
        this.recognizerIntent = recognizerIntent;
        Handler mainHandler = new Handler(Looper.getMainLooper());
        mainHandler.post(() -> {
            SpeechRecognizerReflector recognizerReflector = (SpeechRecognizerReflector)Reflector.reflector(SpeechRecognizerReflector.class, (Object)this.realSpeechRecognizer);
            recognizerReflector.setService((IRecognitionService)ReflectionHelpers.createNullProxy(IRecognitionService.class));
            Queue<Message> pendingTasks = recognizerReflector.getPendingTasks();
            while (!pendingTasks.isEmpty()) {
                recognizerReflector.getHandler().sendMessage(pendingTasks.poll());
            }
        });
    }

    @Implementation
    protected void handleChangeListener(RecognitionListener listener) {
        this.recognitionListener = listener;
    }

    public void triggerOnEndOfSpeech() {
        this.recognitionListener.onEndOfSpeech();
    }

    public void triggerOnError(int error) {
        this.recognitionListener.onError(error);
    }

    public void triggerOnReadyForSpeech(Bundle bundle) {
        this.recognitionListener.onReadyForSpeech(bundle);
    }

    public void triggerOnPartialResults(Bundle bundle) {
        this.recognitionListener.onPartialResults(bundle);
    }

    public void triggerOnResults(Bundle bundle) {
        this.recognitionListener.onResults(bundle);
    }

    public void triggerOnRmsChanged(float rmsdB) {
        this.recognitionListener.onRmsChanged(rmsdB);
    }

    @ForType(value=SpeechRecognizer.class)
    static interface SpeechRecognizerReflector {
        @Static
        @Direct
        public SpeechRecognizer createSpeechRecognizer(Context var1, ComponentName var2);

        @Accessor(value="mService")
        public void setService(IRecognitionService var1);

        @Accessor(value="mPendingTasks")
        public Queue<Message> getPendingTasks();

        @Accessor(value="mHandler")
        public Handler getHandler();
    }
}

