/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ComponentName;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.InstallSourceInfo;
import android.content.pm.ModuleInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageParser;
import android.content.pm.PackageStats;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.Signature;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Binder;
import android.os.Build;
import android.os.PersistableBundle;
import android.os.Process;
import android.os.RemoteException;
import android.os.UserHandle;
import android.util.Log;
import android.util.Pair;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadows.ShadowPackageParser;
import org.robolectric.shadows.ShadowResolveInfo;
import org.robolectric.shadows.SystemFeatureListInitializer;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=PackageManager.class)
public class ShadowPackageManager {
    static final String TAG = "PackageManager";
    @RealObject
    PackageManager realPackageManager;
    static final Object lock = new Object();
    static Map<String, Boolean> permissionRationaleMap = new HashMap<String, Boolean>();
    static List<FeatureInfo> systemAvailableFeatures = new ArrayList<FeatureInfo>();
    static final List<String> systemSharedLibraryNames = new ArrayList<String>();
    @GuardedBy(value="lock")
    static final Map<String, PackageInfo> packageInfos = new LinkedHashMap<String, PackageInfo>();
    @GuardedBy(value="lock")
    static final Map<String, ModuleInfo> moduleInfos = new LinkedHashMap<String, ModuleInfo>();
    static final Set<Object> permissionListeners = new CopyOnWriteArraySet<Object>();
    static final SortedMap<ComponentName, List<IntentFilter>> activityFilters = new TreeMap<ComponentName, List<IntentFilter>>();
    static final SortedMap<ComponentName, List<IntentFilter>> serviceFilters = new TreeMap<ComponentName, List<IntentFilter>>();
    static final SortedMap<ComponentName, List<IntentFilter>> providerFilters = new TreeMap<ComponentName, List<IntentFilter>>();
    static final SortedMap<ComponentName, List<IntentFilter>> receiverFilters = new TreeMap<ComponentName, List<IntentFilter>>();
    private static Map<String, PackageInfo> packageArchiveInfo = new HashMap<String, PackageInfo>();
    static final Map<String, PackageStats> packageStatsMap = new HashMap<String, PackageStats>();
    static final Map<String, String> packageInstallerMap = new HashMap<String, String>();
    static final Map<String, Object> packageInstallSourceInfoMap = new HashMap<String, Object>();
    static final Map<Integer, String[]> packagesForUid = new HashMap<Integer, String[]>();
    static final Map<String, Integer> uidForPackage = new HashMap<String, Integer>();
    static final Map<Integer, String> namesForUid = new HashMap<Integer, String>();
    static final Map<Integer, Integer> verificationResults = new HashMap<Integer, Integer>();
    static final Map<Integer, Long> verificationTimeoutExtension = new HashMap<Integer, Long>();
    static final Map<String, String> currentToCanonicalNames = new HashMap<String, String>();
    static final Map<String, String> canonicalToCurrentNames = new HashMap<String, String>();
    static final Map<ComponentName, ComponentState> componentList = new LinkedHashMap<ComponentName, ComponentState>();
    static final Map<ComponentName, Drawable> drawableList = new LinkedHashMap<ComponentName, Drawable>();
    static final Map<String, Drawable> applicationIcons = new HashMap<String, Drawable>();
    static final Map<String, Drawable> unbadgedApplicationIcons = new HashMap<String, Drawable>();
    static final Map<String, Boolean> systemFeatureList = new LinkedHashMap<String, Boolean>((Map<String, Boolean>)SystemFeatureListInitializer.getSystemFeatures());
    static final SortedMap<ComponentName, List<IntentFilter>> preferredActivities = new TreeMap<ComponentName, List<IntentFilter>>();
    static final SortedMap<ComponentName, List<IntentFilter>> persistentPreferredActivities = new TreeMap<ComponentName, List<IntentFilter>>();
    static final Map<Pair<String, Integer>, Drawable> drawables = new LinkedHashMap<Pair<String, Integer>, Drawable>();
    static final Map<String, Map<Integer, String>> stringResources = new HashMap<String, Map<Integer, String>>();
    static final Map<String, Integer> applicationEnabledSettingMap = new HashMap<String, Integer>();
    static Map<String, PermissionInfo> extraPermissions = new HashMap<String, PermissionInfo>();
    static Map<String, PermissionGroupInfo> permissionGroups = new HashMap<String, PermissionGroupInfo>();
    static Map<String, Map<String, Integer>> permissionFlags = new HashMap<String, Map<String, Integer>>();
    public static Map<String, Resources> resources = new HashMap<String, Resources>();
    static final Map<Intent, List<ResolveInfo>> resolveInfoForIntent = new TreeMap<Intent, List<ResolveInfo>>(new IntentComparator());
    static Set<String> deletedPackages = new HashSet<String>();
    static Map<String, IPackageDeleteObserver> pendingDeleteCallbacks = new HashMap<String, IPackageDeleteObserver>();
    static Set<String> hiddenPackages = new HashSet<String>();
    static Multimap<Integer, String> sequenceNumberChangedPackagesMap = HashMultimap.create();
    static boolean canRequestPackageInstalls = false;
    static boolean safeMode = false;
    static boolean whitelisted = false;
    boolean shouldShowActivityChooser = false;
    static final Map<String, Integer> distractingPackageRestrictions = new ConcurrentHashMap<String, Integer>();
    static final Map<String, PackageSetting> packageSettings = new HashMap<String, PackageSetting>();

    public ActivityInfo addActivityIfNotPresent(ComponentName componentName) {
        return this.addComponent(activityFilters, (Function<PackageInfo, C[]>)((Function)p -> p.activities), (p, a) -> {
            p.activities = a;
        }, this.updateName(componentName, new ActivityInfo()), false);
    }

    public ServiceInfo addServiceIfNotPresent(ComponentName componentName) {
        return this.addComponent(serviceFilters, (Function<PackageInfo, C[]>)((Function)p -> p.services), (p, a) -> {
            p.services = a;
        }, this.updateName(componentName, new ServiceInfo()), false);
    }

    public ActivityInfo addReceiverIfNotPresent(ComponentName componentName) {
        return this.addComponent(receiverFilters, (Function<PackageInfo, C[]>)((Function)p -> p.receivers), (p, a) -> {
            p.receivers = a;
        }, this.updateName(componentName, new ActivityInfo()), false);
    }

    public ProviderInfo addProviderIfNotPresent(ComponentName componentName) {
        return this.addComponent(providerFilters, (Function<PackageInfo, C[]>)((Function)p -> p.providers), (p, a) -> {
            p.providers = a;
        }, this.updateName(componentName, new ProviderInfo()), false);
    }

    private <C extends ComponentInfo> C updateName(ComponentName name, C component) {
        component.name = name.getClassName();
        component.packageName = name.getPackageName();
        if (component.applicationInfo != null) {
            component.applicationInfo.packageName = component.packageName;
        }
        return component;
    }

    public void addOrUpdateActivity(ActivityInfo activityInfo) {
        this.addComponent(activityFilters, (Function<PackageInfo, C[]>)((Function)p -> p.activities), (p, a) -> {
            p.activities = a;
        }, new ActivityInfo(activityInfo), true);
    }

    public void addOrUpdateService(ServiceInfo serviceInfo) {
        this.addComponent(serviceFilters, (Function<PackageInfo, C[]>)((Function)p -> p.services), (p, a) -> {
            p.services = a;
        }, new ServiceInfo(serviceInfo), true);
    }

    public void addOrUpdateReceiver(ActivityInfo receiverInfo) {
        this.addComponent(receiverFilters, (Function<PackageInfo, C[]>)((Function)p -> p.receivers), (p, a) -> {
            p.receivers = a;
        }, new ActivityInfo(receiverInfo), true);
    }

    public void addOrUpdateProvider(ProviderInfo providerInfo) {
        this.addComponent(providerFilters, (Function<PackageInfo, C[]>)((Function)p -> p.providers), (p, a) -> {
            p.providers = a;
        }, new ProviderInfo(providerInfo), true);
    }

    @Nullable
    public ActivityInfo removeActivity(ComponentName componentName) {
        return (ActivityInfo)this.removeComponent(componentName, activityFilters, (Function<PackageInfo, C[]>)((Function)p -> p.activities), (p, a) -> {
            p.activities = a;
        });
    }

    @Nullable
    public ServiceInfo removeService(ComponentName componentName) {
        return (ServiceInfo)this.removeComponent(componentName, serviceFilters, (Function<PackageInfo, C[]>)((Function)p -> p.services), (p, a) -> {
            p.services = a;
        });
    }

    @Nullable
    public ProviderInfo removeProvider(ComponentName componentName) {
        return (ProviderInfo)this.removeComponent(componentName, providerFilters, (Function<PackageInfo, C[]>)((Function)p -> p.providers), (p, a) -> {
            p.providers = a;
        });
    }

    @Nullable
    public ActivityInfo removeReceiver(ComponentName componentName) {
        return (ActivityInfo)this.removeComponent(componentName, receiverFilters, (Function<PackageInfo, C[]>)((Function)p -> p.receivers), (p, a) -> {
            p.receivers = a;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <C extends ComponentInfo> C addComponent(SortedMap<ComponentName, List<IntentFilter>> filtersMap, Function<PackageInfo, C[]> componentArrayInPackage, BiConsumer<PackageInfo, C[]> componentsSetter, C newComponent, boolean updateIfExists) {
        Object object = lock;
        synchronized (object) {
            String packageName = newComponent.packageName;
            if (packageName == null && newComponent.applicationInfo != null) {
                packageName = newComponent.applicationInfo.packageName;
            }
            if (packageName == null) {
                throw new IllegalArgumentException("Component needs a package name");
            }
            if (newComponent.name == null) {
                throw new IllegalArgumentException("Component needs a name");
            }
            PackageInfo packageInfo = packageInfos.get(packageName);
            if (packageInfo == null) {
                packageInfo = new PackageInfo();
                packageInfo.packageName = packageName;
                packageInfo.applicationInfo = newComponent.applicationInfo;
                this.installPackage(packageInfo);
                packageInfo = packageInfos.get(packageName);
            }
            newComponent.applicationInfo = packageInfo.applicationInfo;
            ComponentInfo[] components = (ComponentInfo[])componentArrayInPackage.apply((Object)packageInfo);
            if (components == null) {
                ComponentInfo[] newComponentArray;
                components = newComponentArray = (ComponentInfo[])Array.newInstance(newComponent.getClass(), 0);
            } else {
                for (int i = 0; i < components.length; ++i) {
                    if (!newComponent.name.equals(components[i].name)) continue;
                    if (updateIfExists) {
                        components[i] = newComponent;
                    }
                    return (C)components[i];
                }
            }
            components = Arrays.copyOf(components, components.length + 1);
            componentsSetter.accept(packageInfo, components);
            components[components.length - 1] = newComponent;
            filtersMap.put(new ComponentName(newComponent.packageName, newComponent.name), new ArrayList());
            return newComponent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <C extends ComponentInfo> C removeComponent(ComponentName componentName, SortedMap<ComponentName, List<IntentFilter>> filtersMap, Function<PackageInfo, C[]> componentArrayInPackage, BiConsumer<PackageInfo, C[]> componentsSetter) {
        Object object = lock;
        synchronized (object) {
            filtersMap.remove(componentName);
            String packageName = componentName.getPackageName();
            PackageInfo packageInfo = packageInfos.get(packageName);
            if (packageInfo == null) {
                return null;
            }
            ComponentInfo[] components = (ComponentInfo[])componentArrayInPackage.apply((Object)packageInfo);
            if (components == null) {
                return null;
            }
            for (int i = 0; i < components.length; ++i) {
                ComponentInfo[] newComponents;
                ComponentInfo component = components[i];
                if (!componentName.getClassName().equals(component.name)) continue;
                if (components.length == 1) {
                    newComponents = null;
                } else {
                    newComponents = Arrays.copyOf(components, components.length - 1);
                    System.arraycopy(components, i + 1, newComponents, i, components.length - i - 1);
                }
                componentsSetter.accept(packageInfo, newComponents);
                return (C)component;
            }
            return null;
        }
    }

    static int compareSignature(Signature[] signatures1, Signature[] signatures2) {
        HashSet<Signature> signatures2set;
        if (signatures1 == null) {
            return signatures2 == null ? 1 : -1;
        }
        if (signatures2 == null) {
            return -2;
        }
        if (signatures1.length != signatures2.length) {
            return -3;
        }
        HashSet<Signature> signatures1set = new HashSet<Signature>(Arrays.asList(signatures1));
        return signatures1set.equals(signatures2set = new HashSet<Signature>(Arrays.asList(signatures2))) ? 0 : -3;
    }

    private static void setUpPackageStorage(ApplicationInfo applicationInfo) {
        if (applicationInfo.sourceDir == null) {
            applicationInfo.sourceDir = ShadowPackageManager.createTempDir(applicationInfo.packageName + "-sourceDir");
        }
        if (applicationInfo.dataDir == null) {
            applicationInfo.dataDir = ShadowPackageManager.createTempDir(applicationInfo.packageName + "-dataDir");
        }
        if (applicationInfo.publicSourceDir == null) {
            applicationInfo.publicSourceDir = applicationInfo.sourceDir;
        }
        if (RuntimeEnvironment.getApiLevel() >= 24) {
            applicationInfo.credentialProtectedDataDir = ShadowPackageManager.createTempDir("userDataDir");
            applicationInfo.deviceProtectedDataDir = ShadowPackageManager.createTempDir("deviceDataDir");
        }
    }

    private static String createTempDir(String name) {
        return RuntimeEnvironment.getTempDirectory().createIfNotExists(name).toAbsolutePath().toString();
    }

    @Deprecated
    public void setResolveInfosForIntent(Intent intent, List<ResolveInfo> info) {
        resolveInfoForIntent.remove(intent);
        for (ResolveInfo resolveInfo : info) {
            this.addResolveInfoForIntent(intent, resolveInfo);
        }
    }

    @Deprecated
    public void addResolveInfoForIntent(Intent intent, List<ResolveInfo> info) {
        this.setResolveInfosForIntent(intent, info);
    }

    @Deprecated
    public void addResolveInfoForIntent(Intent intent, ResolveInfo info) {
        ComponentInfo[] componentInfos;
        info.isDefault = true;
        for (ComponentInfo component : componentInfos = new ComponentInfo[]{info.activityInfo, info.serviceInfo, Build.VERSION.SDK_INT >= 19 ? info.providerInfo : null}) {
            if (component == null || component.applicationInfo == null) continue;
            component.applicationInfo.flags |= 0x800000;
            if (component.applicationInfo.processName != null) continue;
            component.applicationInfo.processName = component.applicationInfo.packageName;
        }
        if (info.match == 0) {
            info.match = Integer.MAX_VALUE;
        }
        this.addResolveInfoForIntentNoDefaults(intent, info);
    }

    @Deprecated
    public void addResolveInfoForIntentNoDefaults(Intent intent, ResolveInfo info) {
        Preconditions.checkNotNull((Object)info);
        List<ResolveInfo> infoList = resolveInfoForIntent.get(intent);
        if (infoList == null) {
            infoList = new ArrayList<ResolveInfo>();
            resolveInfoForIntent.put(intent, infoList);
        }
        infoList.add(info);
    }

    @Deprecated
    public void removeResolveInfosForIntent(Intent intent, String packageName) {
        List<ResolveInfo> infoList = resolveInfoForIntent.get(intent);
        if (infoList == null) {
            infoList = new ArrayList<ResolveInfo>();
            resolveInfoForIntent.put(intent, infoList);
        }
        Iterator<ResolveInfo> iterator = infoList.iterator();
        while (iterator.hasNext()) {
            ResolveInfo resolveInfo = iterator.next();
            if (!ShadowPackageManager.getPackageName(resolveInfo).equals(packageName)) continue;
            iterator.remove();
        }
    }

    private static String getPackageName(ResolveInfo resolveInfo) {
        if (resolveInfo.resolvePackageName != null) {
            return resolveInfo.resolvePackageName;
        }
        if (resolveInfo.activityInfo != null) {
            return resolveInfo.activityInfo.packageName;
        }
        if (resolveInfo.serviceInfo != null) {
            return resolveInfo.serviceInfo.packageName;
        }
        if (resolveInfo.providerInfo != null) {
            return resolveInfo.providerInfo.packageName;
        }
        throw new IllegalStateException("Could not find package name for ResolveInfo " + resolveInfo.toString());
    }

    public void addActivityIcon(ComponentName component, Drawable drawable2) {
        drawableList.put(component, drawable2);
    }

    public void addActivityIcon(Intent intent, Drawable drawable2) {
        drawableList.put(intent.getComponent(), drawable2);
    }

    public void setApplicationIcon(String packageName, Drawable drawable2) {
        applicationIcons.put(packageName, drawable2);
    }

    public void setUnbadgedApplicationIcon(String packageName, Drawable drawable2) {
        unbadgedApplicationIcons.put(packageName, drawable2);
    }

    public int getComponentEnabledSettingFlags(ComponentName componentName) {
        ComponentState state = componentList.get(componentName);
        return state != null ? state.flags : 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void installModule(Object moduleInfoObject) {
        Object object = lock;
        synchronized (object) {
            ModuleInfo moduleInfo = (ModuleInfo)moduleInfoObject;
            if (moduleInfo != null) {
                moduleInfos.put(moduleInfo.getPackageName(), moduleInfo);
                if (packageInfos.get(moduleInfo.getPackageName()) == null) {
                    ApplicationInfo applicationInfo = new ApplicationInfo();
                    applicationInfo.packageName = moduleInfo.getPackageName();
                    applicationInfo.name = moduleInfo.getName().toString();
                    PackageInfo packageInfo = new PackageInfo();
                    packageInfo.applicationInfo = applicationInfo;
                    packageInfo.packageName = moduleInfo.getPackageName();
                    this.installPackage(packageInfo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object deleteModule(String packageName) {
        Object object = lock;
        synchronized (object) {
            return moduleInfos.remove(packageName);
        }
    }

    public void installPackage(PackageInfo packageInfo) {
        ApplicationInfo appInfo = packageInfo.applicationInfo;
        if (appInfo == null) {
            packageInfo.applicationInfo = appInfo = new ApplicationInfo();
        }
        if (appInfo.packageName == null) {
            appInfo.packageName = packageInfo.packageName;
        }
        if (appInfo.processName == null) {
            appInfo.processName = appInfo.packageName;
        }
        appInfo.flags |= 0x800000;
        ComponentInfo[][] componentInfoArrays = new ComponentInfo[][]{packageInfo.activities, packageInfo.services, packageInfo.providers, packageInfo.receivers};
        int uniqueNameCounter = 0;
        for (ComponentInfo[] componentInfos : componentInfoArrays) {
            if (componentInfos == null) continue;
            for (ComponentInfo componentInfo : componentInfos) {
                if (componentInfo.name == null) {
                    componentInfo.name = appInfo.packageName + ".DefaultName" + uniqueNameCounter++;
                    componentInfo.packageName = packageInfo.packageName;
                }
                componentInfo.applicationInfo = appInfo;
                componentInfo.packageName = appInfo.packageName;
                if (componentInfo.processName != null) continue;
                componentInfo.processName = appInfo.processName;
            }
        }
        this.addPackageNoDefaults(packageInfo);
    }

    public void setInstallSourceInfo(String packageName, String initiatingPackage, String installerPackage) {
        packageInstallSourceInfoMap.put(packageName, new InstallSourceInfo(initiatingPackage, null, null, installerPackage));
    }

    public void addPackageNoDefaults(PackageInfo packageInfo) {
        PackageStats packageStats = new PackageStats(packageInfo.packageName);
        this.addPackage(packageInfo, packageStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPackage(PackageInfo packageInfo, PackageStats packageStats) {
        Object object = lock;
        synchronized (object) {
            if (packageInfo.applicationInfo != null && (packageInfo.applicationInfo.flags & 0x800000) == 0) {
                Log.w((String)TAG, (String)("Adding not installed package: " + packageInfo.packageName));
            }
            Preconditions.checkArgument((boolean)packageInfo.packageName.equals(packageStats.packageName));
            packageInfos.put(packageInfo.packageName, packageInfo);
            packageStatsMap.put(packageInfo.packageName, packageStats);
            packageSettings.put(packageInfo.packageName, new PackageSetting());
            applicationEnabledSettingMap.put(packageInfo.packageName, 0);
            if (packageInfo.applicationInfo != null) {
                uidForPackage.put(packageInfo.packageName, packageInfo.applicationInfo.uid);
                namesForUid.put(packageInfo.applicationInfo.uid, packageInfo.packageName);
            }
        }
    }

    @Deprecated
    public void addPackage(String packageName) {
        PackageInfo packageInfo = new PackageInfo();
        packageInfo.packageName = packageName;
        ApplicationInfo applicationInfo = new ApplicationInfo();
        applicationInfo.packageName = packageName;
        ShadowPackageManager.setUpPackageStorage(applicationInfo);
        packageInfo.applicationInfo = applicationInfo;
        this.installPackage(packageInfo);
    }

    @Deprecated
    public void addPackage(PackageInfo packageInfo) {
        this.installPackage(packageInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PackageInfo getInternalMutablePackageInfo(String packageName) {
        Object object = lock;
        synchronized (object) {
            return packageInfos.get(packageName);
        }
    }

    @Deprecated
    public PackageInfo getPackageInfoForTesting(String packageName) {
        return this.getInternalMutablePackageInfo(packageName);
    }

    public void addPermissionInfo(PermissionInfo permissionInfo) {
        extraPermissions.put(permissionInfo.name, permissionInfo);
    }

    public void addChangedPackage(int sequenceNumber, String packageName) {
        if (sequenceNumber < 0) {
            return;
        }
        sequenceNumberChangedPackagesMap.put((Object)sequenceNumber, (Object)packageName);
    }

    public void addPermissionGroupInfo(PermissionGroupInfo permissionGroupInfo) {
        permissionGroups.put(permissionGroupInfo.name, permissionGroupInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePackage(String packageName) {
        Object object = lock;
        synchronized (object) {
            packageInfos.remove(packageName);
            packageSettings.remove(packageName);
        }
    }

    public void setSystemFeature(String name, boolean supported) {
        systemFeatureList.put(name, supported);
    }

    public void addDrawableResolution(String packageName, int resourceId, Drawable drawable2) {
        drawables.put((Pair<String, Integer>)new Pair((Object)packageName, (Object)resourceId), drawable2);
    }

    public void setNameForUid(int uid, String name) {
        namesForUid.put(uid, name);
    }

    public void setPackagesForCallingUid(String ... packagesForCallingUid) {
        packagesForUid.put(Binder.getCallingUid(), packagesForCallingUid);
        for (String packageName : packagesForCallingUid) {
            uidForPackage.put(packageName, Binder.getCallingUid());
        }
    }

    public void setPackagesForUid(int uid, String ... packagesForCallingUid) {
        packagesForUid.put(uid, packagesForCallingUid);
        for (String packageName : packagesForCallingUid) {
            uidForPackage.put(packageName, uid);
        }
    }

    @Implementation
    @Nullable
    protected String[] getPackagesForUid(int uid) {
        return packagesForUid.get(uid);
    }

    public void setPackageArchiveInfo(String archiveFilePath, PackageInfo packageInfo) {
        packageArchiveInfo.put(archiveFilePath, packageInfo);
    }

    public int getVerificationResult(int id2) {
        Integer result = verificationResults.get(id2);
        if (result == null) {
            return 0;
        }
        return result;
    }

    public long getVerificationExtendedTimeout(int id2) {
        Long result = verificationTimeoutExtension.get(id2);
        if (result == null) {
            return 0L;
        }
        return result;
    }

    public void setShouldShowRequestPermissionRationale(String permission2, boolean show) {
        permissionRationaleMap.put(permission2, show);
    }

    public void addSystemAvailableFeature(FeatureInfo featureInfo) {
        systemAvailableFeatures.add(featureInfo);
    }

    public void clearSystemAvailableFeatures() {
        systemAvailableFeatures.clear();
    }

    public void addSystemSharedLibraryName(String name) {
        systemSharedLibraryNames.add(name);
    }

    public void clearSystemSharedLibraryNames() {
        systemSharedLibraryNames.clear();
    }

    @Deprecated
    public void addCurrentToCannonicalName(String currentName, String canonicalName) {
        currentToCanonicalNames.put(currentName, canonicalName);
    }

    public void addCanonicalName(String currentName, String canonicalName) {
        currentToCanonicalNames.put(currentName, canonicalName);
        canonicalToCurrentNames.put(canonicalName, currentName);
    }

    public void setCanRequestPackageInstalls(boolean canRequestPackageInstalls) {
        ShadowPackageManager.canRequestPackageInstalls = canRequestPackageInstalls;
    }

    @Implementation(minSdk=24)
    protected List<ResolveInfo> queryBroadcastReceiversAsUser(Intent intent, int flags, UserHandle userHandle) {
        return null;
    }

    @Implementation(minSdk=17)
    protected List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags, int userId) {
        return null;
    }

    @Implementation
    protected PackageInfo getPackageArchiveInfo(String archiveFilePath, int flags) {
        PackageInfo shadowPackageInfo = this.getShadowPackageArchiveInfo(archiveFilePath, flags);
        if (shadowPackageInfo != null) {
            return shadowPackageInfo;
        }
        return ((PackageManagerReflector)Reflector.reflector(PackageManagerReflector.class, (Object)this.realPackageManager)).getPackageArchiveInfo(archiveFilePath, flags);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PackageInfo getShadowPackageArchiveInfo(String archiveFilePath, int flags) {
        Object object = lock;
        synchronized (object) {
            if (packageArchiveInfo.containsKey(archiveFilePath)) {
                return packageArchiveInfo.get(archiveFilePath);
            }
            ArrayList<PackageInfo> result = new ArrayList<PackageInfo>();
            for (PackageInfo packageInfo : packageInfos.values()) {
                if (applicationEnabledSettingMap.get(packageInfo.packageName) == 2 && (flags & 0x2000) != 8192) continue;
                result.add(packageInfo);
            }
            ArrayList<PackageInfo> packages = result;
            for (PackageInfo aPackage : packages) {
                ApplicationInfo appInfo = aPackage.applicationInfo;
                if (appInfo == null || !archiveFilePath.equals(appInfo.sourceDir)) continue;
                return aPackage;
            }
            return null;
        }
    }

    @Implementation
    protected void freeStorageAndNotify(long freeStorageSize, IPackageDataObserver observer) {
    }

    @Implementation
    protected void freeStorage(long freeStorageSize, IntentSender pi) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deletePackage(String packageName) {
        Object object = lock;
        synchronized (object) {
            deletedPackages.add(packageName);
            packageInfos.remove(packageName);
            ShadowPackageManager.mapForPackage(activityFilters, packageName).clear();
            ShadowPackageManager.mapForPackage(serviceFilters, packageName).clear();
            ShadowPackageManager.mapForPackage(providerFilters, packageName).clear();
            ShadowPackageManager.mapForPackage(receiverFilters, packageName).clear();
            moduleInfos.remove(packageName);
        }
    }

    @Implementation
    protected void deletePackage(String packageName, IPackageDeleteObserver observer, int flags) {
        pendingDeleteCallbacks.put(packageName, observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doPendingUninstallCallbacks() {
        Object object = lock;
        synchronized (object) {
            boolean hasDeletePackagesPermission = false;
            String[] requestedPermissions = ShadowPackageManager.packageInfos.get((Object)RuntimeEnvironment.getApplication().getPackageName()).requestedPermissions;
            if (requestedPermissions != null) {
                for (String permission2 : requestedPermissions) {
                    if (!"android.permission.DELETE_PACKAGES".equals(permission2)) continue;
                    hasDeletePackagesPermission = true;
                    break;
                }
            }
            for (String packageName : pendingDeleteCallbacks.keySet()) {
                int resultCode = -1;
                PackageInfo removed = packageInfos.get(packageName);
                if (hasDeletePackagesPermission && removed != null) {
                    this.deletePackage(packageName);
                    resultCode = 1;
                }
                try {
                    pendingDeleteCallbacks.get(packageName).packageDeleted(packageName, resultCode);
                }
                catch (RemoteException e) {
                    throw new RuntimeException(e);
                }
            }
            pendingDeleteCallbacks.clear();
        }
    }

    public Set<String> getDeletedPackages() {
        return deletedPackages;
    }

    protected List<ResolveInfo> queryOverriddenIntents(Intent intent, int flags) {
        List<ResolveInfo> overrides = resolveInfoForIntent.get(intent);
        if (overrides == null) {
            return Collections.emptyList();
        }
        ArrayList<ResolveInfo> result = new ArrayList<ResolveInfo>(overrides.size());
        for (ResolveInfo resolveInfo : overrides) {
            result.add(ShadowResolveInfo.newResolveInfo(resolveInfo));
        }
        return result;
    }

    public void addPackageInternal(PackageParser.Package appPackage) {
        int flags = 851967;
        for (PackageParser.PermissionGroup permissionGroup : appPackage.permissionGroups) {
            PermissionGroupInfo permissionGroupInfo = PackageParser.generatePermissionGroupInfo((PackageParser.PermissionGroup)permissionGroup, (int)flags);
            this.addPermissionGroupInfo(permissionGroupInfo);
        }
        PackageInfo packageInfo = this.generatePackageInfo(appPackage, flags);
        packageInfo.applicationInfo.uid = Process.myUid();
        packageInfo.applicationInfo.dataDir = ShadowPackageManager.createTempDir(packageInfo.packageName + "-dataDir");
        this.installPackage(packageInfo);
        this.addFilters(activityFilters, appPackage.activities);
        this.addFilters(serviceFilters, appPackage.services);
        this.addFilters(providerFilters, appPackage.providers);
        this.addFilters(receiverFilters, appPackage.receivers);
    }

    protected PackageInfo generatePackageInfo(PackageParser.Package appPackage, int flags) {
        return ((ShadowPackageParser._PackageParser_)Reflector.reflector(ShadowPackageParser._PackageParser_.class)).generatePackageInfo(appPackage, new int[]{0}, flags, 0L, 0L);
    }

    private void addFilters(Map<ComponentName, List<IntentFilter>> componentMap, List<? extends PackageParser.Component<?>> components) {
        if (components == null) {
            return;
        }
        for (PackageParser.Component<?> component : components) {
            ComponentName componentName = component.getComponentName();
            List<IntentFilter> registeredFilters = componentMap.get(componentName);
            if (registeredFilters == null) {
                registeredFilters = new ArrayList<IntentFilter>();
                componentMap.put(componentName, registeredFilters);
            }
            for (PackageParser.IntentInfo intentInfo : component.intents) {
                registeredFilters.add(new IntentFilter((IntentFilter)intentInfo));
            }
        }
    }

    public List<IntentFilter> getIntentFiltersForActivity(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return this.getIntentFiltersForComponent(componentName, activityFilters);
    }

    public List<IntentFilter> getIntentFiltersForService(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return this.getIntentFiltersForComponent(componentName, serviceFilters);
    }

    public List<IntentFilter> getIntentFiltersForReceiver(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return this.getIntentFiltersForComponent(componentName, receiverFilters);
    }

    public List<IntentFilter> getIntentFiltersForProvider(ComponentName componentName) throws PackageManager.NameNotFoundException {
        return this.getIntentFiltersForComponent(componentName, providerFilters);
    }

    public void addIntentFilterForActivity(ComponentName componentName, IntentFilter filter) throws PackageManager.NameNotFoundException {
        this.addIntentFilterForComponent(componentName, filter, activityFilters);
    }

    public void addIntentFilterForService(ComponentName componentName, IntentFilter filter) throws PackageManager.NameNotFoundException {
        this.addIntentFilterForComponent(componentName, filter, serviceFilters);
    }

    public void addIntentFilterForReceiver(ComponentName componentName, IntentFilter filter) throws PackageManager.NameNotFoundException {
        this.addIntentFilterForComponent(componentName, filter, receiverFilters);
    }

    public void addIntentFilterForProvider(ComponentName componentName, IntentFilter filter) throws PackageManager.NameNotFoundException {
        this.addIntentFilterForComponent(componentName, filter, providerFilters);
    }

    public void clearIntentFilterForActivity(ComponentName componentName) throws PackageManager.NameNotFoundException {
        this.clearIntentFilterForComponent(componentName, activityFilters);
    }

    public void clearIntentFilterForService(ComponentName componentName) throws PackageManager.NameNotFoundException {
        this.clearIntentFilterForComponent(componentName, serviceFilters);
    }

    public void clearIntentFilterForReceiver(ComponentName componentName) throws PackageManager.NameNotFoundException {
        this.clearIntentFilterForComponent(componentName, receiverFilters);
    }

    public void clearIntentFilterForProvider(ComponentName componentName) throws PackageManager.NameNotFoundException {
        this.clearIntentFilterForComponent(componentName, providerFilters);
    }

    private void addIntentFilterForComponent(ComponentName componentName, IntentFilter filter, Map<ComponentName, List<IntentFilter>> filterMap) throws PackageManager.NameNotFoundException {
        List<IntentFilter> filters = filterMap.get(componentName);
        if (filters != null) {
            filters.add(filter);
            return;
        }
        throw new PackageManager.NameNotFoundException(componentName + " doesn't exist");
    }

    private void clearIntentFilterForComponent(ComponentName componentName, Map<ComponentName, List<IntentFilter>> filterMap) throws PackageManager.NameNotFoundException {
        List<IntentFilter> filters = filterMap.get(componentName);
        if (filters != null) {
            filters.clear();
            return;
        }
        throw new PackageManager.NameNotFoundException(componentName + " doesn't exist");
    }

    private List<IntentFilter> getIntentFiltersForComponent(ComponentName componentName, Map<ComponentName, List<IntentFilter>> filterMap) throws PackageManager.NameNotFoundException {
        List<IntentFilter> filters = filterMap.get(componentName);
        if (filters != null) {
            return new ArrayList<IntentFilter>(filters);
        }
        throw new PackageManager.NameNotFoundException(componentName + " doesn't exist");
    }

    public int getPersistentPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        return ShadowPackageManager.getPreferredActivitiesInternal(outFilters, outActivities, packageName, persistentPreferredActivities);
    }

    protected static int getPreferredActivitiesInternal(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName, SortedMap<ComponentName, List<IntentFilter>> preferredActivitiesMap) {
        SortedMap<ComponentName, List<IntentFilter>> preferredMap = preferredActivitiesMap;
        if (packageName != null) {
            preferredMap = ShadowPackageManager.mapForPackage(preferredActivitiesMap, packageName);
        }
        int result = 0;
        for (Map.Entry<ComponentName, List<IntentFilter>> entry : preferredMap.entrySet()) {
            int filterCount = entry.getValue().size();
            result += filterCount;
            Object[] componentNames = new ComponentName[filterCount];
            Arrays.fill(componentNames, entry.getKey());
            outActivities.addAll(Arrays.asList(componentNames));
            outFilters.addAll((Collection<IntentFilter>)entry.getValue());
        }
        return result;
    }

    void clearPackagePersistentPreferredActivities(String packageName) {
        ShadowPackageManager.clearPackagePreferredActivitiesInternal(packageName, persistentPreferredActivities);
    }

    protected static void clearPackagePreferredActivitiesInternal(String packageName, SortedMap<ComponentName, List<IntentFilter>> preferredActivitiesMap) {
        ShadowPackageManager.mapForPackage(preferredActivitiesMap, packageName).clear();
    }

    void addPersistentPreferredActivity(IntentFilter filter, ComponentName activity) {
        ShadowPackageManager.addPreferredActivityInternal(filter, activity, persistentPreferredActivities);
    }

    protected static void addPreferredActivityInternal(IntentFilter filter, ComponentName activity, SortedMap<ComponentName, List<IntentFilter>> preferredActivitiesMap) {
        ArrayList<IntentFilter> filters = (ArrayList<IntentFilter>)preferredActivitiesMap.get(activity);
        if (filters == null) {
            filters = new ArrayList<IntentFilter>();
            preferredActivitiesMap.put(activity, filters);
        }
        filters.add(filter);
    }

    protected static <V> SortedMap<ComponentName, V> mapForPackage(SortedMap<ComponentName, V> input, @Nullable String packageName) {
        if (packageName == null) {
            return input;
        }
        if (packageName == null) {
            return input;
        }
        return input.subMap(new ComponentName(packageName, ""), new ComponentName(packageName + " ", ""));
    }

    static boolean isComponentEnabled(@Nullable ComponentInfo componentInfo) {
        if (componentInfo == null) {
            return true;
        }
        if (componentInfo.applicationInfo == null || componentInfo.applicationInfo.packageName == null || componentInfo.name == null) {
            return componentInfo.enabled;
        }
        ComponentName name = new ComponentName(componentInfo.applicationInfo.packageName, componentInfo.name);
        ComponentState componentState = componentList.get(name);
        if (componentState == null || componentState.newState == 0) {
            return componentInfo.enabled;
        }
        return componentState.newState == 1;
    }

    public PackageSetting getPackageSetting(String packageName) {
        PackageSetting setting = packageSettings.get(packageName);
        return setting == null ? null : new PackageSetting(setting);
    }

    public void setShouldShowActivityChooser(boolean shouldShowActivityChooser) {
        this.shouldShowActivityChooser = shouldShowActivityChooser;
    }

    public void setSafeMode(boolean safeMode) {
        ShadowPackageManager.safeMode = safeMode;
    }

    public int getDistractingPackageRestrictions(String pkg) {
        return distractingPackageRestrictions.getOrDefault(pkg, 0);
    }

    public void addStringResource(String packageName, int resId, String text) {
        if (!stringResources.containsKey(packageName)) {
            stringResources.put(packageName, new HashMap());
        }
        stringResources.get(packageName).put(resId, text);
    }

    public void setAutoRevokeWhitelisted(boolean whitelisted) {
        ShadowPackageManager.whitelisted = whitelisted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Resetter
    public static void reset() {
        Object object = lock;
        synchronized (object) {
            permissionRationaleMap.clear();
            systemAvailableFeatures.clear();
            systemSharedLibraryNames.clear();
            packageInfos.clear();
            packageArchiveInfo.clear();
            packageStatsMap.clear();
            packageInstallerMap.clear();
            packageInstallSourceInfoMap.clear();
            packagesForUid.clear();
            uidForPackage.clear();
            namesForUid.clear();
            verificationResults.clear();
            verificationTimeoutExtension.clear();
            currentToCanonicalNames.clear();
            canonicalToCurrentNames.clear();
            componentList.clear();
            drawableList.clear();
            applicationIcons.clear();
            unbadgedApplicationIcons.clear();
            systemFeatureList.clear();
            systemFeatureList.putAll((Map<String, Boolean>)SystemFeatureListInitializer.getSystemFeatures());
            preferredActivities.clear();
            persistentPreferredActivities.clear();
            drawables.clear();
            stringResources.clear();
            applicationEnabledSettingMap.clear();
            extraPermissions.clear();
            permissionGroups.clear();
            permissionFlags.clear();
            resources.clear();
            resolveInfoForIntent.clear();
            deletedPackages.clear();
            pendingDeleteCallbacks.clear();
            hiddenPackages.clear();
            sequenceNumberChangedPackagesMap.clear();
            activityFilters.clear();
            serviceFilters.clear();
            providerFilters.clear();
            receiverFilters.clear();
            packageSettings.clear();
            safeMode = false;
            whitelisted = false;
        }
    }

    @ForType(value=PackageManager.class)
    static interface PackageManagerReflector {
        @Direct
        public PackageInfo getPackageArchiveInfo(String var1, int var2);
    }

    protected static class ComponentState {
        public int newState;
        public int flags;

        public ComponentState(int newState, int flags) {
            this.newState = newState;
            this.flags = flags;
        }
    }

    static class ResolveInfoComparator
    implements Comparator<ResolveInfo> {
        ResolveInfoComparator() {
        }

        @Override
        public int compare(ResolveInfo o1, ResolveInfo o2) {
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            if (o1.preferredOrder != o2.preferredOrder) {
                return -Integer.compare(o1.preferredOrder, o2.preferredOrder);
            }
            if (o1.priority != o2.priority) {
                return -Integer.compare(o1.priority, o2.priority);
            }
            if (o1.match != o2.match) {
                return -Integer.compare(o1.match, o2.match);
            }
            return 0;
        }
    }

    public static class IntentComparator
    implements Comparator<Intent> {
        @Override
        public int compare(Intent i1, Intent i2) {
            if (i1 == null && i2 == null) {
                return 0;
            }
            if (i1 == null && i2 != null) {
                return -1;
            }
            if (i1 != null && i2 == null) {
                return 1;
            }
            if (i1.equals(i2)) {
                return 0;
            }
            String action1 = i1.getAction();
            String action2 = i2.getAction();
            if (action1 == null && action2 != null) {
                return -1;
            }
            if (action1 != null && action2 == null) {
                return 1;
            }
            if (action1 != null && action2 != null && !action1.equals(action2)) {
                return action1.compareTo(action2);
            }
            Uri data1 = i1.getData();
            Uri data2 = i2.getData();
            if (data1 == null && data2 != null) {
                return -1;
            }
            if (data1 != null && data2 == null) {
                return 1;
            }
            if (data1 != null && data2 != null && !data1.equals((Object)data2)) {
                return data1.compareTo(data2);
            }
            ComponentName component1 = i1.getComponent();
            ComponentName component2 = i2.getComponent();
            if (component1 == null && component2 != null) {
                return -1;
            }
            if (component1 != null && component2 == null) {
                return 1;
            }
            if (component1 != null && component2 != null && !component1.equals((Object)component2)) {
                return component1.compareTo(component2);
            }
            String package1 = i1.getPackage();
            String package2 = i2.getPackage();
            if (package1 == null && package2 != null) {
                return -1;
            }
            if (package1 != null && package2 == null) {
                return 1;
            }
            if (package1 != null && package2 != null && !package1.equals(package2)) {
                return package1.compareTo(package2);
            }
            Set categories1 = i1.getCategories();
            Set categories2 = i2.getCategories();
            if (categories1 == null) {
                return categories2 == null ? 0 : -1;
            }
            if (categories2 == null) {
                return 1;
            }
            if (categories1.size() > categories2.size()) {
                return 1;
            }
            if (categories1.size() < categories2.size()) {
                return -1;
            }
            Object[] array1 = categories1.toArray(new String[0]);
            Object[] array2 = categories2.toArray(new String[0]);
            Arrays.sort(array1);
            Arrays.sort(array2);
            for (int i = 0; i < array1.length; ++i) {
                int val = ((String)array1[i]).compareTo((String)array2[i]);
                if (val == 0) continue;
                return val;
            }
            return 0;
        }
    }

    public static class PackageSetting {
        private boolean suspended = false;
        private String dialogMessage = null;
        private Object dialogInfo = null;
        private PersistableBundle suspendedAppExtras = null;
        private PersistableBundle suspendedLauncherExtras = null;

        public PackageSetting() {
        }

        public PackageSetting(PackageSetting that) {
            this.suspended = that.suspended;
            this.dialogMessage = that.dialogMessage;
            this.dialogInfo = that.dialogInfo;
            this.suspendedAppExtras = PackageSetting.deepCopyNullablePersistableBundle(that.suspendedAppExtras);
            this.suspendedLauncherExtras = PackageSetting.deepCopyNullablePersistableBundle(that.suspendedLauncherExtras);
        }

        void setSuspended(boolean suspended, String dialogMessage, Object dialogInfo, PersistableBundle appExtras, PersistableBundle launcherExtras) {
            Preconditions.checkArgument((dialogMessage == null || dialogInfo == null ? 1 : 0) != 0);
            this.suspended = suspended;
            this.dialogMessage = suspended ? dialogMessage : null;
            this.dialogInfo = suspended ? dialogInfo : null;
            this.suspendedAppExtras = suspended ? PackageSetting.deepCopyNullablePersistableBundle(appExtras) : null;
            this.suspendedLauncherExtras = suspended ? PackageSetting.deepCopyNullablePersistableBundle(launcherExtras) : null;
        }

        public boolean isSuspended() {
            return this.suspended;
        }

        public String getDialogMessage() {
            return this.dialogMessage;
        }

        public Object getDialogInfo() {
            return this.dialogInfo;
        }

        public PersistableBundle getSuspendedAppExtras() {
            return this.suspendedAppExtras;
        }

        public PersistableBundle getSuspendedLauncherExtras() {
            return this.suspendedLauncherExtras;
        }

        private static PersistableBundle deepCopyNullablePersistableBundle(PersistableBundle bundle) {
            return bundle == null ? null : bundle.deepCopy();
        }
    }
}

