/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.companion.AssociationRequest;
import android.companion.CompanionDeviceManager;
import android.content.ComponentName;
import android.os.Handler;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=CompanionDeviceManager.class, minSdk=26)
public class ShadowCompanionDeviceManager {
    private final Set<String> associations = new HashSet<String>();
    private final Set<ComponentName> hasNotificationAccess = new HashSet<ComponentName>();
    private ComponentName lastRequestedNotificationAccess;
    private AssociationRequest lastAssociationRequest;
    private CompanionDeviceManager.Callback lastAssociationCallback;

    @Implementation
    protected List<String> getAssociations() {
        return ImmutableList.copyOf(this.associations);
    }

    public void addAssociation(String newAssociation) {
        this.associations.add(newAssociation);
    }

    @Implementation
    protected void disassociate(String deviceMacAddress) {
        if (!this.associations.remove(deviceMacAddress)) {
            throw new IllegalArgumentException("Association does not exist");
        }
    }

    @Implementation
    protected boolean hasNotificationAccess(ComponentName component) {
        this.checkHasAssociation();
        return this.hasNotificationAccess.contains(component);
    }

    public void setNotificationAccess(ComponentName component, boolean hasAccess) {
        if (hasAccess) {
            this.hasNotificationAccess.add(component);
        } else {
            this.hasNotificationAccess.remove(component);
        }
    }

    @Implementation
    protected void requestNotificationAccess(ComponentName component) {
        this.checkHasAssociation();
        this.lastRequestedNotificationAccess = component;
    }

    @Implementation
    protected void associate(AssociationRequest request, CompanionDeviceManager.Callback callback, Handler handler) {
        this.lastAssociationRequest = request;
        this.lastAssociationCallback = callback;
    }

    public AssociationRequest getLastAssociationRequest() {
        return this.lastAssociationRequest;
    }

    public CompanionDeviceManager.Callback getLastAssociationCallback() {
        return this.lastAssociationCallback;
    }

    public ComponentName getLastRequestedNotificationAccess() {
        return this.lastRequestedNotificationAccess;
    }

    private void checkHasAssociation() {
        if (this.associations.isEmpty()) {
            throw new IllegalStateException("App must have an association before calling this API");
        }
    }
}

