/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothManager;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.ImmutableIntArray;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.AutoValue_ShadowBluetoothManager_BleDevice;

@Implements(value=BluetoothManager.class, minSdk=18)
public class ShadowBluetoothManager {
    private static final ImmutableIntArray VALID_STATES = ImmutableIntArray.of((int)2, (int)1, (int)0, (int)3);
    private final ArrayList<BleDevice> bleDevices = new ArrayList();

    @Implementation
    protected BluetoothAdapter getAdapter() {
        return BluetoothAdapter.getDefaultAdapter();
    }

    @Implementation
    protected List<BluetoothDevice> getDevicesMatchingConnectionStates(int profile, int[] states) {
        Preconditions.checkArgument((boolean)this.isProfileValid(profile), (String)"Profile not supported: %s", (int)profile);
        if (states == null) {
            return ImmutableList.of();
        }
        ImmutableList.Builder result = ImmutableList.builder();
        ImmutableIntArray stateArray = ImmutableIntArray.copyOf((int[])states);
        for (BleDevice ble : this.bleDevices) {
            if (ble.profile() != profile || !stateArray.contains(ble.state())) continue;
            result.add((Object)ble.device());
        }
        return result.build();
    }

    public void addDevice(int profile, int state, BluetoothDevice device) {
        if (this.isProfileValid(profile) && VALID_STATES.contains(state)) {
            this.bleDevices.add(BleDevice.builder().setProfile(profile).setState(state).setDevice(device).build());
        }
    }

    private boolean isProfileValid(int profile) {
        return profile == 7 || profile == 8;
    }

    @AutoValue
    static abstract class BleDevice {
        BleDevice() {
        }

        abstract int profile();

        abstract int state();

        abstract BluetoothDevice device();

        static Builder builder() {
            return new AutoValue_ShadowBluetoothManager_BleDevice.Builder();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setProfile(int var1);

            abstract Builder setState(int var1);

            abstract Builder setDevice(BluetoothDevice var1);

            abstract BleDevice build();
        }
    }
}

