/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.bluetooth.BluetoothA2dp;
import android.bluetooth.BluetoothDevice;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=BluetoothA2dp.class)
public class ShadowBluetoothA2dp {
    private final Map<BluetoothDevice, Integer> bluetoothDevices = new HashMap<BluetoothDevice, Integer>();
    private int dynamicBufferSupportType = 0;
    private final int[] bufferLengthMillisArray = new int[6];

    public void addDevice(BluetoothDevice bluetoothDevice, int connectionState) {
        this.bluetoothDevices.put(bluetoothDevice, connectionState);
    }

    public void removeDevice(BluetoothDevice bluetoothDevice) {
        this.bluetoothDevices.remove(bluetoothDevice);
    }

    @Implementation
    protected List<BluetoothDevice> getConnectedDevices() {
        return this.getDevicesMatchingConnectionStates(new int[]{2});
    }

    @Implementation
    protected List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] states) {
        ArrayList<BluetoothDevice> deviceList = new ArrayList<BluetoothDevice>();
        for (Map.Entry<BluetoothDevice, Integer> entry : this.bluetoothDevices.entrySet()) {
            for (int state : states) {
                if (entry.getValue() != state) continue;
                deviceList.add(entry.getKey());
            }
        }
        return ImmutableList.copyOf(deviceList);
    }

    @Implementation
    protected int getConnectionState(BluetoothDevice device) {
        return this.bluetoothDevices.containsKey(device) ? this.bluetoothDevices.get(device) : 0;
    }

    public void setDynamicBufferSupport(int type) {
        this.dynamicBufferSupportType = type;
    }

    @Implementation(minSdk=31)
    protected int getDynamicBufferSupport() {
        return this.dynamicBufferSupportType;
    }

    @Implementation(minSdk=31)
    protected boolean setBufferLengthMillis(int codec, int value) {
        if (codec >= this.bufferLengthMillisArray.length || codec < 0 || value < 0) {
            return false;
        }
        this.bufferLengthMillisArray[codec] = value;
        return true;
    }

    public int getBufferLengthMillis(int codec) {
        return this.bufferLengthMillisArray[codec];
    }
}

