/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.RequiresPermission;
import android.content.Context;
import android.hardware.biometrics.BiometricManager;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(className="android.hardware.biometrics.BiometricManager", minSdk=29, isInAndroidSdk=false)
public class ShadowBiometricManager {
    protected boolean biometricServiceConnected = true;
    @RealObject
    private BiometricManager realBiometricManager;

    @Implementation
    @RequiresPermission(value="android.permission.USE_BIOMETRIC")
    protected int canAuthenticate() {
        if (RuntimeEnvironment.getApiLevel() >= 30) {
            return ((BiometricManagerReflector)Reflector.reflector(BiometricManagerReflector.class, (Object)this.realBiometricManager)).canAuthenticate();
        }
        if (this.biometricServiceConnected) {
            return 0;
        }
        boolean hasBiomatrics = (Boolean)ReflectionHelpers.callStaticMethod(BiometricManager.class, (String)"hasBiometrics", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)RuntimeEnvironment.getApplication().getApplicationContext())});
        if (!hasBiomatrics) {
            return 12;
        }
        return 1;
    }

    public void setCanAuthenticate(boolean flag) {
        this.biometricServiceConnected = flag;
    }

    @Implementation(minSdk=30)
    protected int canAuthenticate(int userId, int authenticators) {
        return this.biometricServiceConnected ? 0 : 12;
    }

    @ForType(value=BiometricManager.class)
    static interface BiometricManagerReflector {
        @Direct
        public int canAuthenticate();
    }
}

