/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.speech.IRecognitionService;
import android.speech.RecognitionListener;
import android.speech.SpeechRecognizer;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowContextWrapper;
import org.robolectric.shadows.ShadowSettings;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=SpeechRecognizer.class)
public class ShadowSpeechRecognizer {
    @RealObject
    SpeechRecognizer realSpeechRecognizer;
    private static SpeechRecognizer latestSpeechRecognizer;
    private RecognitionListener recognitionListener;

    public static SpeechRecognizer getLatestSpeechRecognizer() {
        return latestSpeechRecognizer;
    }

    @Resetter
    public static void reset() {
        latestSpeechRecognizer = null;
    }

    @Implementation
    protected static SpeechRecognizer createSpeechRecognizer(Context context, ComponentName serviceComponent) {
        SpeechRecognizer result;
        latestSpeechRecognizer = result = (SpeechRecognizer)Shadow.directlyOn(SpeechRecognizer.class, (String)"createSpeechRecognizer", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Context.class, (Object)context), ReflectionHelpers.ClassParameter.from(ComponentName.class, (Object)serviceComponent)});
        return result;
    }

    @Implementation
    protected void startListening(Intent recognizerIntent) {
        SpeechRecognizerReflector reflector = (SpeechRecognizerReflector)Reflector.reflector(SpeechRecognizerReflector.class, (Object)this.realSpeechRecognizer);
        Binder recognitionServiceBinder = new Binder();
        recognitionServiceBinder.attachInterface((IInterface)ReflectionHelpers.createNullProxy(IRecognitionService.class), IRecognitionService.class.getName());
        Intent serviceIntent = new Intent("android.speech.RecognitionService");
        ComponentName componentName = reflector.getServiceComponent();
        if (componentName == null) {
            componentName = new ComponentName("org.robolectric", "FakeSpeechRecognizerService");
            ShadowSettings.ShadowSecure.putString(reflector.getContext().getContentResolver(), "voice_recognition_service", componentName.flattenToString());
        }
        serviceIntent.setComponent(componentName);
        ShadowContextWrapper.getShadowInstrumentation().setComponentNameAndServiceForBindServiceForIntent(serviceIntent, reflector.getServiceComponent(), (IBinder)recognitionServiceBinder);
        ((SpeechRecognizer)Shadow.directlyOn((Object)this.realSpeechRecognizer, SpeechRecognizer.class)).startListening(recognizerIntent);
    }

    @Implementation
    protected void handleChangeListener(RecognitionListener listener) {
        this.recognitionListener = listener;
    }

    public void triggerOnError(int error) {
        this.recognitionListener.onError(error);
    }

    public void triggerOnPartialResults(Bundle bundle) {
        this.recognitionListener.onPartialResults(bundle);
    }

    public void triggerOnResults(Bundle bundle) {
        this.recognitionListener.onResults(bundle);
    }

    public void triggerOnRmsChanged(float rmsdB) {
        this.recognitionListener.onRmsChanged(rmsdB);
    }

    @ForType(value=SpeechRecognizer.class)
    static interface SpeechRecognizerReflector {
        @Accessor(value="mConnection")
        public Object getConnection();

        @Accessor(value="mServiceComponent")
        public ComponentName getServiceComponent();

        @Accessor(value="mContext")
        public Context getContext();
    }
}

