/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.telephony.ims.RcsUceAdapter;
import java.util.HashSet;
import java.util.Set;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=RcsUceAdapter.class, isInAndroidSdk=false, minSdk=30)
public class ShadowRcsUceAdapter {
    private static final Set<Integer> subscriptionIdsWithUceSettingEnabled = new HashSet<Integer>();
    @RealObject
    private RcsUceAdapter realRcsUceAdapter;

    public static void setUceSettingEnabledForSubscriptionId(int subscriptionId, boolean uceSettingEnabled) {
        if (uceSettingEnabled) {
            subscriptionIdsWithUceSettingEnabled.add(subscriptionId);
        } else {
            subscriptionIdsWithUceSettingEnabled.remove(subscriptionId);
        }
    }

    @Resetter
    public static void reset() {
        subscriptionIdsWithUceSettingEnabled.clear();
    }

    @Implementation
    protected boolean isUceSettingEnabled() {
        int subscriptionId = ((ReflectorRcsUceAdapter)Reflector.reflector(ReflectorRcsUceAdapter.class, (Object)this.realRcsUceAdapter)).getSubId();
        return subscriptionIdsWithUceSettingEnabled.contains(subscriptionId);
    }

    @ForType(value=RcsUceAdapter.class)
    private static interface ReflectorRcsUceAdapter {
        @Accessor(value="mSubId")
        public int getSubId();
    }
}

