/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.AssetManager;
import android.graphics.fonts.Font;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.res.android.ApkAssetsCookie;
import org.robolectric.res.android.Asset;
import org.robolectric.res.android.CppAssetManager2;
import org.robolectric.res.android.Registries;
import org.robolectric.shadows.ShadowArscAssetManager10;

@Implements(value=Font.Builder.class, minSdk=29)
public class ShadowFontBuilder {
    @Implementation(maxSdk=29)
    protected static long nGetNativeAsset(AssetManager assetMgr, String path, boolean isAsset, int cookie) {
        Preconditions.checkNotNull((Object)assetMgr);
        Preconditions.checkNotNull((Object)path);
        CppAssetManager2 mgr = ShadowArscAssetManager10.AssetManagerForJavaObject(assetMgr);
        if (mgr == null) {
            return 0L;
        }
        Asset asset = isAsset ? mgr.Open(path, Asset.AccessMode.ACCESS_BUFFER) : (cookie > 0 ? mgr.OpenNonAsset(path, ApkAssetsCookie.forInt((int)(cookie - 1)), Asset.AccessMode.ACCESS_BUFFER) : mgr.OpenNonAsset(path, Asset.AccessMode.ACCESS_BUFFER));
        return Registries.NATIVE_ASSET_REGISTRY.register((Object)asset);
    }

    @Implementation(maxSdk=29)
    protected static ByteBuffer nGetAssetBuffer(long nativeAsset) {
        Asset asset = (Asset)Registries.NATIVE_ASSET_REGISTRY.getNativeObject(nativeAsset);
        return ByteBuffer.wrap(asset.getBuffer(false));
    }

    @Implementation(maxSdk=29)
    protected static long nGetReleaseNativeAssetFunc() {
        return 0L;
    }

    @Implementation(minSdk=30)
    protected static ByteBuffer createBuffer(AssetManager am, String path, boolean isAsset, int cookie) throws IOException {
        Preconditions.checkNotNull((Object)am, (Object)"assetManager can not be null");
        Preconditions.checkNotNull((Object)path, (Object)"path can not be null");
        try (InputStream assetStream = isAsset ? am.open(path, 3) : am.openNonAsset(cookie, path, 3);){
            int capacity = assetStream.available();
            ByteBuffer buffer = ByteBuffer.allocate(capacity);
            buffer.order(ByteOrder.nativeOrder());
            assetStream.read(buffer.array(), buffer.arrayOffset(), assetStream.available());
            if (assetStream.read() != -1) {
                String string2 = String.valueOf(path);
                throw new IOException(string2.length() != 0 ? "Unable to access full contents of ".concat(string2) : new String("Unable to access full contents of "));
            }
            ByteBuffer byteBuffer = buffer;
            return byteBuffer;
        }
    }
}

