/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.Environment;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Environment.class)
public class ShadowEnvironment {
    private static String externalStorageState = "removed";
    private static final Map<File, Boolean> STORAGE_EMULATED = new HashMap<File, Boolean>();
    private static final Map<File, Boolean> STORAGE_REMOVABLE = new HashMap<File, Boolean>();
    private static boolean sIsExternalStorageEmulated;
    private static boolean isExternalStorageLegacy;
    private static Path tmpExternalFilesDirBase;
    private static final List<File> externalDirs;
    private static Map<Path, String> storageState;
    static Path EXTERNAL_CACHE_DIR;
    static Path EXTERNAL_FILES_DIR;

    @Implementation
    protected static String getExternalStorageState() {
        return externalStorageState;
    }

    public static void setExternalStorageState(String externalStorageState) {
        ShadowEnvironment.externalStorageState = externalStorageState;
    }

    public static void setIsExternalStorageEmulated(boolean emulated) {
        sIsExternalStorageEmulated = emulated;
    }

    public static void setIsExternalStorageLegacy(boolean legacy) {
        isExternalStorageLegacy = legacy;
    }

    public static void setExternalStorageDirectory(Path directory) {
        EXTERNAL_CACHE_DIR = directory;
    }

    @Implementation
    protected static File getExternalStorageDirectory() {
        if (EXTERNAL_CACHE_DIR == null) {
            EXTERNAL_CACHE_DIR = RuntimeEnvironment.getTempDirectory().createIfNotExists("external-cache");
        }
        return EXTERNAL_CACHE_DIR.toFile();
    }

    @Implementation(minSdk=19)
    protected static File[] buildExternalStorageAppCacheDirs(String packageName) {
        Path externalStorageDirectoryPath = ShadowEnvironment.getExternalStorageDirectory().toPath();
        String cacheDirectory = String.valueOf(packageName).concat("-cache");
        Path path = externalStorageDirectoryPath.resolve(cacheDirectory);
        try {
            Files.createDirectory(path, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException e) {
            return new File[]{path.toFile()};
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return new File[]{path.toFile()};
    }

    @Implementation(maxSdk=18)
    protected static File getExternalStorageAppCacheDirectory(String packageName) {
        return ShadowEnvironment.buildExternalStorageAppCacheDirs(packageName)[0];
    }

    @Implementation
    protected static File getExternalStoragePublicDirectory(String type) {
        if (EXTERNAL_FILES_DIR == null) {
            EXTERNAL_FILES_DIR = RuntimeEnvironment.getTempDirectory().createIfNotExists("external-files");
        }
        if (type == null) {
            return EXTERNAL_FILES_DIR.toFile();
        }
        Path path = EXTERNAL_FILES_DIR.resolve(type);
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path.toFile();
    }

    @Resetter
    public static void reset() {
        EXTERNAL_CACHE_DIR = null;
        EXTERNAL_FILES_DIR = null;
        STORAGE_EMULATED.clear();
        STORAGE_REMOVABLE.clear();
        storageState = new HashMap<Path, String>();
        externalDirs.clear();
        sIsExternalStorageEmulated = false;
        isExternalStorageLegacy = false;
    }

    @Implementation
    protected static boolean isExternalStorageRemovable() {
        Boolean exists = STORAGE_REMOVABLE.get(ShadowEnvironment.getExternalStorageDirectory());
        return exists != null ? exists : false;
    }

    @Implementation(minSdk=19)
    protected static String getStorageState(File directory) {
        Path directoryPath = directory.toPath();
        for (Map.Entry<Path, String> entry : storageState.entrySet()) {
            if (!directoryPath.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Implementation(minSdk=21)
    protected static String getExternalStorageState(File directory) {
        Path directoryPath = directory.toPath();
        for (Map.Entry<Path, String> entry : storageState.entrySet()) {
            if (!directoryPath.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    @Implementation(minSdk=21)
    protected static boolean isExternalStorageRemovable(File path) {
        Boolean exists = STORAGE_REMOVABLE.get(path);
        return exists != null ? exists : false;
    }

    @Implementation(minSdk=21)
    protected static boolean isExternalStorageEmulated(File path) {
        Boolean emulated = STORAGE_EMULATED.get(path);
        return emulated != null ? emulated : false;
    }

    @Implementation
    protected static boolean isExternalStorageEmulated() {
        return sIsExternalStorageEmulated;
    }

    @Implementation(minSdk=29)
    protected static boolean isExternalStorageLegacy(File path) {
        return isExternalStorageLegacy;
    }

    @Implementation(minSdk=29)
    protected static boolean isExternalStorageLegacy() {
        return isExternalStorageLegacy;
    }

    public static void setExternalStorageRemovable(File file, boolean isRemovable) {
        STORAGE_REMOVABLE.put(file, isRemovable);
    }

    public static void setExternalStorageEmulated(File file, boolean isEmulated) {
        STORAGE_EMULATED.put(file, isEmulated);
    }

    public static File addExternalDir(String path) {
        Path externalFileDir;
        if (path == null) {
            externalFileDir = null;
        } else {
            try {
                if (tmpExternalFilesDirBase == null) {
                    tmpExternalFilesDirBase = RuntimeEnvironment.getTempDirectory().create("external-files-base");
                }
                externalFileDir = tmpExternalFilesDirBase.resolve(path);
                Files.createDirectories(externalFileDir, new FileAttribute[0]);
                externalDirs.add(externalFileDir.toFile());
            }
            catch (IOException e) {
                throw new RuntimeException("Could not create external files dir", e);
            }
        }
        if (RuntimeEnvironment.getApiLevel() >= 17 && RuntimeEnvironment.getApiLevel() < 19) {
            if (externalDirs.size() == 1 && externalFileDir != null) {
                Environment.UserEnvironment userEnvironment = (Environment.UserEnvironment)ReflectionHelpers.getStaticField(Environment.class, (String)"sCurrentUser");
                ((_UserEnvironment_)Reflector.reflector(_UserEnvironment_.class, (Object)userEnvironment)).setExternalStorageAndroidData(externalFileDir.toFile());
            }
        } else if (RuntimeEnvironment.getApiLevel() >= 19 && RuntimeEnvironment.getApiLevel() < 23) {
            Environment.UserEnvironment userEnvironment = (Environment.UserEnvironment)ReflectionHelpers.getStaticField(Environment.class, (String)"sCurrentUser");
            ((_UserEnvironment_)Reflector.reflector(_UserEnvironment_.class, (Object)userEnvironment)).setExternalDirsForApp(externalDirs.toArray(new File[0]));
        }
        if (externalFileDir == null) {
            return null;
        }
        return externalFileDir.toFile();
    }

    public static void setExternalStorageState(File directory, String state) {
        storageState.put(directory.toPath(), state);
    }

    static {
        externalDirs = new ArrayList<File>();
        storageState = new HashMap<Path, String>();
    }

    @ForType(className="android.os.Environment$UserEnvironment")
    static interface _UserEnvironment_ {
        @Accessor(value="mExternalDirsForApp")
        public void setExternalDirsForApp(File[] var1);

        @Accessor(value="mExternalStorageAndroidData")
        public void setExternalStorageAndroidData(File var1);
    }

    @Implements(className="android.os.Environment$UserEnvironment", isInAndroidSdk=false, minSdk=17)
    public static class ShadowUserEnvironment {
        @Implementation(minSdk=23)
        protected File[] getExternalDirs() {
            return externalDirs.toArray(new File[externalDirs.size()]);
        }
    }
}

