/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.DownloadManager;
import android.database.Cursor;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.util.Pair;
import com.android.internal.util.ArrayUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.fakes.BaseCursor;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=DownloadManager.class)
public class ShadowDownloadManager {
    private long queueCounter = -1L;
    private Map<Long, DownloadManager.Request> requestMap = new TreeMap<Long, DownloadManager.Request>();

    @Implementation
    protected long enqueue(DownloadManager.Request request) {
        ++this.queueCounter;
        this.requestMap.put(this.queueCounter, request);
        return this.queueCounter;
    }

    @Implementation
    protected int remove(long ... ids) {
        int removeCount = 0;
        for (long id2 : ids) {
            if (this.requestMap.remove(id2) == null) continue;
            ++removeCount;
        }
        return removeCount;
    }

    @Implementation
    protected Cursor query(DownloadManager.Query query) {
        ResultCursor result = new ResultCursor();
        ShadowQuery shadow = (ShadowQuery)Shadow.extract((Object)query);
        long[] ids = shadow.getIds();
        if (ids != null) {
            for (long id2 : ids) {
                DownloadManager.Request request = this.requestMap.get(id2);
                if (request == null) continue;
                result.requests.add(request);
            }
        } else {
            result.requests.addAll(this.requestMap.values());
        }
        return result;
    }

    public DownloadManager.Request getRequest(long id2) {
        return this.requestMap.get(id2);
    }

    public int getRequestCount() {
        return this.requestMap.size();
    }

    private static <T> T getFieldReflectively(String fieldName, Object object, Class<T> clazz) {
        return clazz.cast(ReflectionHelpers.getField((Object)object, (String)fieldName));
    }

    private static class ResultCursor
    extends BaseCursor {
        private static final int COLUMN_INDEX_LOCAL_FILENAME = 0;
        private static final int COLUMN_INDEX_DESCRIPTION = 1;
        private static final int COLUMN_INDEX_REASON = 2;
        private static final int COLUMN_INDEX_STATUS = 3;
        private static final int COLUMN_INDEX_URI = 4;
        private static final int COLUMN_INDEX_LOCAL_URI = 5;
        private static final int COLUMN_INDEX_TITLE = 6;
        public List<DownloadManager.Request> requests = new ArrayList<DownloadManager.Request>();
        private int positionIndex = -1;
        private boolean closed;

        private ResultCursor() {
        }

        @Override
        public int getCount() {
            this.checkClosed();
            return this.requests.size();
        }

        @Override
        public int getPosition() {
            return this.positionIndex;
        }

        @Override
        public boolean moveToFirst() {
            this.checkClosed();
            this.positionIndex = 0;
            return !this.requests.isEmpty();
        }

        @Override
        public boolean moveToNext() {
            this.checkClosed();
            ++this.positionIndex;
            return this.positionIndex < this.requests.size();
        }

        @Override
        public int getColumnIndex(String columnName) {
            this.checkClosed();
            if ("local_filename".equals(columnName)) {
                return 0;
            }
            if ("description".equals(columnName)) {
                return 1;
            }
            if ("reason".equals(columnName)) {
                return 2;
            }
            if ("status".equals(columnName)) {
                return 3;
            }
            if ("uri".equals(columnName)) {
                return 4;
            }
            if ("local_uri".equals(columnName)) {
                return 5;
            }
            if ("title".equals(columnName)) {
                return 6;
            }
            return -1;
        }

        @Override
        public int getColumnIndexOrThrow(String columnName) throws IllegalArgumentException {
            this.checkClosed();
            int columnIndex = this.getColumnIndex(columnName);
            if (columnIndex == -1) {
                throw new IllegalArgumentException("Column not found.");
            }
            return columnIndex;
        }

        @Override
        public void close() {
            this.closed = true;
        }

        @Override
        public boolean isClosed() {
            return this.closed;
        }

        @Override
        public String getString(int columnIndex) {
            this.checkClosed();
            ShadowRequest request = (ShadowRequest)Shadow.extract((Object)this.requests.get(this.positionIndex));
            switch (columnIndex) {
                case 0: {
                    return "local file name not implemented";
                }
                case 2: {
                    return "reason not implemented";
                }
                case 1: {
                    return request.getDescription().toString();
                }
                case 4: {
                    return request.getUri().toString();
                }
                case 5: {
                    return request.getDestination().toString();
                }
                case 6: {
                    return request.getTitle().toString();
                }
            }
            return new StringBuilder(31).append("Unknown ColumnIndex ").append(columnIndex).toString();
        }

        @Override
        public int getInt(int columnIndex) {
            this.checkClosed();
            ShadowRequest request = (ShadowRequest)Shadow.extract((Object)this.requests.get(this.positionIndex));
            if (columnIndex == 3) {
                return request.getStatus();
            }
            return 0;
        }

        private void checkClosed() {
            if (this.closed) {
                throw new IllegalStateException("Cursor is already closed.");
            }
        }
    }

    @Implements(value=DownloadManager.Query.class)
    public static class ShadowQuery {
        @RealObject
        DownloadManager.Query realObject;

        public long[] getIds() {
            return (long[])ShadowDownloadManager.getFieldReflectively("mIds", this.realObject, long[].class);
        }
    }

    @Implements(value=DownloadManager.Request.class)
    public static class ShadowRequest {
        @RealObject
        DownloadManager.Request realObject;
        private int status;

        public int getStatus() {
            return this.status;
        }

        public void setStatus(int status) {
            this.status = status;
        }

        public Uri getUri() {
            return (Uri)ShadowDownloadManager.getFieldReflectively("mUri", this.realObject, Uri.class);
        }

        public Uri getDestination() {
            return (Uri)ShadowDownloadManager.getFieldReflectively("mDestinationUri", this.realObject, Uri.class);
        }

        public CharSequence getTitle() {
            return (CharSequence)ShadowDownloadManager.getFieldReflectively("mTitle", this.realObject, CharSequence.class);
        }

        public CharSequence getDescription() {
            return (CharSequence)ShadowDownloadManager.getFieldReflectively("mDescription", this.realObject, CharSequence.class);
        }

        public CharSequence getMimeType() {
            return (CharSequence)ShadowDownloadManager.getFieldReflectively("mMimeType", this.realObject, CharSequence.class);
        }

        public int getNotificationVisibility() {
            return (Integer)ShadowDownloadManager.getFieldReflectively("mNotificationVisibility", this.realObject, Integer.class);
        }

        public int getAllowedNetworkTypes() {
            return (Integer)ShadowDownloadManager.getFieldReflectively("mAllowedNetworkTypes", this.realObject, Integer.class);
        }

        public boolean getAllowedOverRoaming() {
            return (Boolean)ShadowDownloadManager.getFieldReflectively("mRoamingAllowed", this.realObject, Boolean.class);
        }

        public boolean getAllowedOverMetered() {
            return (Boolean)ShadowDownloadManager.getFieldReflectively("mMeteredAllowed", this.realObject, Boolean.class);
        }

        public boolean getVisibleInDownloadsUi() {
            return (Boolean)ShadowDownloadManager.getFieldReflectively("mIsVisibleInDownloadsUi", this.realObject, Boolean.class);
        }

        public List<Pair<String, String>> getRequestHeaders() {
            return (List)ShadowDownloadManager.getFieldReflectively("mRequestHeaders", this.realObject, List.class);
        }

        @Implementation
        protected DownloadManager.Request setDestinationInExternalPublicDir(String dirType, String subPath) throws Exception {
            File file = Environment.getExternalStoragePublicDirectory((String)dirType);
            if (file == null) {
                throw new IllegalStateException("Failed to get external storage public directory");
            }
            if (Build.VERSION.SDK_INT >= 29 && !ArrayUtils.contains((Object[])Environment.STANDARD_DIRECTORIES, (Object)dirType)) {
                String string2 = String.valueOf(dirType);
                throw new IllegalStateException(string2.length() != 0 ? "Not one of standard directories: ".concat(string2) : new String("Not one of standard directories: "));
            }
            if (file.exists()) {
                if (!file.isDirectory()) {
                    throw new IllegalStateException(String.valueOf(file.getAbsolutePath()).concat(" already exists and is not a directory"));
                }
            } else if (!file.mkdirs()) {
                String string3 = String.valueOf(file.getAbsolutePath());
                throw new IllegalStateException(string3.length() != 0 ? "Unable to create directory: ".concat(string3) : new String("Unable to create directory: "));
            }
            this.setDestinationFromBase(file, subPath);
            return this.realObject;
        }

        private void setDestinationFromBase(File base, String subPath) {
            if (subPath == null) {
                throw new NullPointerException("subPath cannot be null");
            }
            ReflectionHelpers.setField((Object)this.realObject, (String)"mDestinationUri", (Object)Uri.withAppendedPath((Uri)Uri.fromFile((File)base), (String)subPath));
        }
    }
}

