/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.media.AudioFormat;
import android.media.AudioTrack;
import android.util.Log;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;

@Implements(value=AudioTrack.class, looseSignatures=true)
public class ShadowAudioTrack {
    protected static final int DEFAULT_MIN_BUFFER_SIZE = 1024;
    private static final String TAG = "ShadowAudioTrack";
    private static int minBufferSize = 1024;
    private static final List<OnAudioDataWrittenListener> audioDataWrittenListeners = new CopyOnWriteArrayList<OnAudioDataWrittenListener>();
    private int numBytesReceived;
    @RealObject
    AudioTrack audioTrack;

    public static void setMinBufferSize(int bufferSize) {
        minBufferSize = bufferSize;
    }

    @Implementation(minSdk=24, maxSdk=28)
    protected static int native_get_FCC_8() {
        return 8;
    }

    @Implementation
    protected static int native_get_min_buff_size(int sampleRateInHz, int channelConfig, int audioFormat) {
        return minBufferSize;
    }

    @Implementation(minSdk=23)
    protected final int native_write_byte(byte[] audioData, int offsetInBytes, int sizeInBytes, int format, boolean isBlocking) {
        return sizeInBytes;
    }

    @Implementation(minSdk=21)
    protected int write(ByteBuffer audioData, int sizeInBytes, int writeMode) {
        if (writeMode != 0 && writeMode != 1) {
            Log.e((String)TAG, (String)"ShadowAudioTrack.write() called with invalid blocking mode");
            return -2;
        }
        if (sizeInBytes < 0 || sizeInBytes > audioData.remaining()) {
            Log.e((String)TAG, (String)new StringBuilder(69).append("ShadowAudioTrack.write() called with invalid size (").append(sizeInBytes).append(") value").toString());
            return -2;
        }
        byte[] receivedBytes = new byte[sizeInBytes];
        audioData.get(receivedBytes);
        this.numBytesReceived += sizeInBytes;
        for (OnAudioDataWrittenListener listener : audioDataWrittenListeners) {
            listener.onAudioDataWritten(this, receivedBytes, this.audioTrack.getFormat());
        }
        return sizeInBytes;
    }

    @Implementation
    protected int getPlaybackHeadPosition() {
        return this.numBytesReceived / this.audioTrack.getFormat().getFrameSizeInBytes();
    }

    @Implementation
    protected void flush() {
        this.numBytesReceived = 0;
    }

    public static void addAudioDataListener(OnAudioDataWrittenListener listener) {
        audioDataWrittenListeners.add(listener);
    }

    public static void removeAudioDataListener(OnAudioDataWrittenListener listener) {
        audioDataWrittenListeners.remove(listener);
    }

    @Resetter
    public static void resetTest() {
        audioDataWrittenListeners.clear();
    }

    public static interface OnAudioDataWrittenListener {
        public void onAudioDataWritten(ShadowAudioTrack var1, byte[] var2, AudioFormat var3);
    }
}

