/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ActivityThread;
import android.app.Application;
import android.app.Instrumentation;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;

@Implements(value=ActivityThread.class, isInAndroidSdk=false, looseSignatures=true)
public class ShadowActivityThread {
    private static ApplicationInfo applicationInfo;

    @Implementation
    public static Object getPackageManager() {
        Class<?> iPackageManagerClass;
        ClassLoader classLoader = ShadowActivityThread.class.getClassLoader();
        try {
            iPackageManagerClass = classLoader.loadClass("android.content.pm.IPackageManager");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return Proxy.newProxyInstance(classLoader, new Class[]{iPackageManagerClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, @Nonnull Method method, Object[] args) throws Exception {
                if (method.getName().equals("getApplicationInfo")) {
                    String packageName = (String)args[0];
                    int flags = (Integer)args[1];
                    if (packageName.equals(applicationInfo.packageName)) {
                        return applicationInfo;
                    }
                    try {
                        return RuntimeEnvironment.application.getPackageManager().getApplicationInfo(packageName, flags);
                    }
                    catch (PackageManager.NameNotFoundException e) {
                        return null;
                    }
                }
                if (method.getName().equals("notifyPackageUse")) {
                    return null;
                }
                if (method.getName().equals("getPackageInstaller")) {
                    return null;
                }
                String string2 = String.valueOf(method);
                throw new UnsupportedOperationException(new StringBuilder(27 + String.valueOf(string2).length()).append("sorry, not supporting ").append(string2).append(" yet!").toString());
            }
        });
    }

    @Implementation
    public static Object currentActivityThread() {
        return RuntimeEnvironment.getActivityThread();
    }

    @Implementation(minSdk=30)
    public static Object getPermissionManager() {
        Class<?> iPermissionManagerClass;
        ClassLoader classLoader = ShadowActivityThread.class.getClassLoader();
        try {
            iPermissionManagerClass = classLoader.loadClass("android.permission.IPermissionManager");
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        return Proxy.newProxyInstance(classLoader, new Class[]{iPermissionManagerClass}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, @Nonnull Method method, Object[] args) throws Exception {
                if (method.getName().equals("getSplitPermissions")) {
                    return Collections.emptyList();
                }
                return method.getDefaultValue();
            }
        });
    }

    @Deprecated
    public static void setApplicationInfo(ApplicationInfo applicationInfo) {
        ShadowActivityThread.applicationInfo = applicationInfo;
    }

    @ForType(className="android.app.ActivityThread$AppBindData")
    public static interface _AppBindData_ {
        @Accessor(value="appInfo")
        public void setAppInfo(ApplicationInfo var1);

        @Accessor(value="processName")
        public void setProcessName(String var1);
    }

    @ForType(value=ActivityThread.class)
    public static interface _ActivityThread_ {
        @Accessor(value="mBoundApplication")
        public void setBoundApplication(Object var1);

        @Accessor(value="mBoundApplication")
        public Object getBoundApplication();

        @Accessor(value="mCompatConfiguration")
        public void setCompatConfiguration(Configuration var1);

        @Accessor(value="mInitialApplication")
        public void setInitialApplication(Application var1);

        @Accessor(value="mInstrumentation")
        public void setInstrumentation(Instrumentation var1);
    }
}

