/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accessibilityservice.AccessibilityService;
import android.accessibilityservice.GestureDescription;
import android.os.Handler;
import android.view.accessibility.AccessibilityWindowInfo;
import java.util.ArrayList;
import java.util.List;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.ShadowService;

@Implements(value=AccessibilityService.class)
public class ShadowAccessibilityService
extends ShadowService {
    private final List<Integer> globalActionsPerformed = new ArrayList<Integer>();
    private final List<AccessibilityWindowInfo> windows = new ArrayList<AccessibilityWindowInfo>();
    private final List<GestureDispatch> gesturesDispatched = new ArrayList<GestureDispatch>();
    private boolean canDispatchGestures = true;

    @Implementation
    protected final boolean performGlobalAction(int action) {
        this.globalActionsPerformed.add(action);
        return true;
    }

    public List<Integer> getGlobalActionsPerformed() {
        return this.globalActionsPerformed;
    }

    @Implementation(minSdk=21)
    protected List<AccessibilityWindowInfo> getWindows() {
        return new ArrayList<AccessibilityWindowInfo>(this.windows);
    }

    @Implementation(minSdk=24)
    protected boolean dispatchGesture(GestureDescription gesture, AccessibilityService.GestureResultCallback callback, Handler handler) {
        if (this.canDispatchGestures) {
            this.gesturesDispatched.add(new GestureDispatch(gesture, callback));
        }
        return this.canDispatchGestures;
    }

    public void setWindows(List<AccessibilityWindowInfo> windowList) {
        this.windows.clear();
        if (windowList != null) {
            this.windows.addAll(windowList);
        }
    }

    public List<GestureDispatch> getGesturesDispatched() {
        return this.gesturesDispatched;
    }

    public void setCanDispatchGestures(boolean canDispatchGestures) {
        this.canDispatchGestures = canDispatchGestures;
    }

    public static final class GestureDispatch {
        private final GestureDescription description;
        private final AccessibilityService.GestureResultCallback callback;

        public GestureDispatch(GestureDescription description, AccessibilityService.GestureResultCallback callback) {
            this.description = description;
            this.callback = callback;
        }

        public GestureDescription description() {
            return this.description;
        }

        public AccessibilityService.GestureResultCallback callback() {
            return this.callback;
        }
    }
}

