/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.view.View;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.accessibility.AccessibilityRecord;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AccessibilityRecord.class)
public class ShadowAccessibilityRecord {
    @RealObject
    private AccessibilityRecord realRecord;
    public static final int NO_VIRTUAL_ID = -1;
    private View sourceRoot;
    private int virtualDescendantId;
    private AccessibilityNodeInfo sourceNode;
    private int windowId = -1;

    @Implementation
    protected void setSource(View root, int virtualDescendantId) {
        this.sourceRoot = root;
        this.virtualDescendantId = virtualDescendantId;
        Shadow.directlyOn((Object)this.realRecord, AccessibilityRecord.class, (String)"setSource", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(View.class, (Object)root), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)virtualDescendantId)});
    }

    @Implementation
    protected void setSource(View root) {
        this.sourceRoot = root;
        this.virtualDescendantId = -1;
        Shadow.directlyOn((Object)this.realRecord, AccessibilityRecord.class, (String)"setSource", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(View.class, (Object)root)});
    }

    public void setSourceNode(AccessibilityNodeInfo node) {
        this.sourceNode = node;
    }

    @Implementation
    protected AccessibilityNodeInfo getSource() {
        if (this.sourceNode == null) {
            return null;
        }
        return AccessibilityNodeInfo.obtain((AccessibilityNodeInfo)this.sourceNode);
    }

    public void setWindowId(int id2) {
        this.windowId = id2;
    }

    @Implementation
    protected int getWindowId() {
        return this.windowId;
    }

    public View getSourceRoot() {
        return this.sourceRoot;
    }

    public int getVirtualDescendantId() {
        return this.virtualDescendantId;
    }
}

