/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.util.DisplayMetrics;
import android.view.ViewConfiguration;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=ViewConfiguration.class)
public class ShadowViewConfiguration {
    private static final int SCROLL_BAR_SIZE = 10;
    private static final int SCROLL_BAR_FADE_DURATION = 250;
    private static final int SCROLL_BAR_DEFAULT_DELAY = 300;
    private static final int FADING_EDGE_LENGTH = 12;
    private static final int PRESSED_STATE_DURATION = 125;
    private static final int LONG_PRESS_TIMEOUT = 500;
    private static final int GLOBAL_ACTIONS_KEY_TIMEOUT = 500;
    private static final int TAP_TIMEOUT = 115;
    private static final int JUMP_TAP_TIMEOUT = 500;
    private static final int DOUBLE_TAP_TIMEOUT = 300;
    private static final int ZOOM_CONTROLS_TIMEOUT = 3000;
    private static final int EDGE_SLOP = 12;
    private static final int TOUCH_SLOP = 16;
    private static final int PAGING_TOUCH_SLOP = 32;
    private static final int DOUBLE_TAP_SLOP = 100;
    private static final int WINDOW_TOUCH_SLOP = 16;
    private static final int MINIMUM_FLING_VELOCITY = 50;
    private static final int MAXIMUM_FLING_VELOCITY = 4000;
    private static final int MAXIMUM_DRAWING_CACHE_SIZE = 614400;
    private static final int OVERSCROLL_DISTANCE = 0;
    private static final int OVERFLING_DISTANCE = 4;
    private static final float SCROLL_FRICTION = 0.015f;
    private int edgeSlop;
    private int fadingEdgeLength;
    private int minimumFlingVelocity;
    private int maximumFlingVelocity;
    private int scrollbarSize;
    private int touchSlop;
    private int pagingTouchSlop;
    private int doubleTapSlop;
    private int windowTouchSlop;
    private static boolean hasPermanentMenuKey = true;
    @RealObject
    private ViewConfiguration realViewConfiguration;

    private void setup(Context context) {
        DisplayMetrics metrics = context.getResources().getDisplayMetrics();
        float density = metrics.density;
        this.edgeSlop = (int)(density * 12.0f + 0.5f);
        this.fadingEdgeLength = (int)(density * 12.0f + 0.5f);
        this.minimumFlingVelocity = (int)(density * 50.0f + 0.5f);
        this.maximumFlingVelocity = (int)(density * 4000.0f + 0.5f);
        this.scrollbarSize = (int)(density * 10.0f + 0.5f);
        this.touchSlop = (int)(density * 16.0f + 0.5f);
        this.pagingTouchSlop = (int)(density * 32.0f + 0.5f);
        this.doubleTapSlop = (int)(density * 100.0f + 0.5f);
        this.windowTouchSlop = (int)(density * 16.0f + 0.5f);
    }

    @Implementation
    protected static ViewConfiguration get(Context context) {
        ViewConfiguration viewConfiguration = (ViewConfiguration)Shadow.newInstanceOf(ViewConfiguration.class);
        ShadowViewConfiguration shadowViewConfiguration = (ShadowViewConfiguration)Shadow.extract((Object)viewConfiguration);
        shadowViewConfiguration.setup(context);
        if (RuntimeEnvironment.getApiLevel() >= 29) {
            ReflectionHelpers.setField((Object)viewConfiguration, (String)"mConstructedWithContext", (Object)true);
        }
        return viewConfiguration;
    }

    @Implementation
    protected static int getScrollBarSize() {
        return 10;
    }

    @Implementation
    protected int getScaledScrollBarSize() {
        return this.scrollbarSize;
    }

    @Implementation
    protected static int getScrollBarFadeDuration() {
        return 250;
    }

    @Implementation
    protected static int getScrollDefaultDelay() {
        return 300;
    }

    @Implementation
    protected static int getFadingEdgeLength() {
        return 12;
    }

    @Implementation
    protected int getScaledFadingEdgeLength() {
        return this.fadingEdgeLength;
    }

    @Implementation
    protected static int getPressedStateDuration() {
        return 125;
    }

    @Implementation
    protected static int getLongPressTimeout() {
        return 500;
    }

    @Implementation
    protected static int getTapTimeout() {
        return 115;
    }

    @Implementation
    protected static int getJumpTapTimeout() {
        return 500;
    }

    @Implementation
    protected static int getDoubleTapTimeout() {
        return 300;
    }

    @Implementation
    protected static int getEdgeSlop() {
        return 12;
    }

    @Implementation
    protected int getScaledEdgeSlop() {
        return this.edgeSlop;
    }

    @Implementation
    protected static int getTouchSlop() {
        return 16;
    }

    @Implementation
    protected int getScaledTouchSlop() {
        return this.touchSlop;
    }

    @Implementation
    protected int getScaledPagingTouchSlop() {
        return this.pagingTouchSlop;
    }

    @Implementation
    protected int getScaledDoubleTapSlop() {
        return this.doubleTapSlop;
    }

    @Implementation
    protected static int getWindowTouchSlop() {
        return 16;
    }

    @Implementation
    protected int getScaledWindowTouchSlop() {
        return this.windowTouchSlop;
    }

    @Implementation
    protected static int getMinimumFlingVelocity() {
        return 50;
    }

    @Implementation
    protected int getScaledMinimumFlingVelocity() {
        return this.minimumFlingVelocity;
    }

    @Implementation
    protected static int getMaximumFlingVelocity() {
        return 4000;
    }

    @Implementation
    protected int getScaledMaximumFlingVelocity() {
        return this.maximumFlingVelocity;
    }

    @Implementation
    protected static int getMaximumDrawingCacheSize() {
        return 614400;
    }

    @Implementation
    protected static long getZoomControlsTimeout() {
        return 3000L;
    }

    @Implementation
    protected static long getGlobalActionKeyTimeout() {
        return 500L;
    }

    @Implementation
    protected static float getScrollFriction() {
        return 0.015f;
    }

    @Implementation
    protected boolean hasPermanentMenuKey() {
        return hasPermanentMenuKey;
    }

    public static void setHasPermanentMenuKey(boolean value) {
        hasPermanentMenuKey = value;
    }
}

