/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.UiModeManager;
import com.google.common.collect.ImmutableSet;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;

@Implements(value=UiModeManager.class)
public class ShadowUIModeManager {
    public int currentModeType = 0;
    public int currentNightMode = 0;
    public int lastFlags;
    private static final ImmutableSet<Integer> VALID_NIGHT_MODES = ImmutableSet.of((Object)0, (Object)1, (Object)2);

    @Implementation
    public int getCurrentModeType() {
        return this.currentModeType;
    }

    @Implementation
    public void enableCarMode(int flags) {
        this.currentModeType = 3;
        this.lastFlags = flags;
    }

    @Implementation
    public void disableCarMode(int flags) {
        this.currentModeType = 1;
        this.lastFlags = flags;
    }

    @Implementation
    public int getNightMode() {
        return this.currentNightMode;
    }

    @Implementation
    public void setNightMode(int mode) {
        this.currentNightMode = VALID_NIGHT_MODES.contains((Object)mode) ? mode : 0;
    }
}

