/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.os.StatFs;
import java.io.File;
import java.util.Map;
import java.util.TreeMap;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.Resetter;

@Implements(value=StatFs.class)
public class ShadowStatFs {
    public static final int BLOCK_SIZE = 4096;
    private static final Stats DEFAULT_STATS = new Stats(0, 0, 0);
    private static TreeMap<String, Stats> stats = new TreeMap();
    private Stats stat;

    @Implementation
    protected void __constructor__(String path) {
        this.restat(path);
    }

    @Implementation
    protected int getBlockSize() {
        return 4096;
    }

    @Implementation
    protected int getBlockCount() {
        return this.stat.blockCount;
    }

    @Implementation
    protected int getFreeBlocks() {
        return this.stat.freeBlocks;
    }

    @Implementation(minSdk=18)
    protected long getFreeBlocksLong() {
        return this.stat.freeBlocks;
    }

    @Implementation(minSdk=18)
    protected long getFreeBytes() {
        return this.getBlockSizeLong() * this.getFreeBlocksLong();
    }

    @Implementation(minSdk=18)
    protected long getAvailableBytes() {
        return this.getBlockSizeLong() * this.getAvailableBlocksLong();
    }

    @Implementation(minSdk=18)
    protected long getTotalBytes() {
        return this.getBlockSizeLong() * this.getBlockCountLong();
    }

    @Implementation
    protected int getAvailableBlocks() {
        return this.stat.availableBlocks;
    }

    @Implementation
    protected void restat(String path) {
        Map.Entry<String, Stats> mapEntry = stats.floorEntry(path);
        while (true) {
            if (mapEntry == null) {
                this.stat = DEFAULT_STATS;
                return;
            }
            String key = mapEntry.getKey();
            if (path.startsWith(key)) {
                this.stat = mapEntry.getValue();
                return;
            }
            mapEntry = stats.lowerEntry(key);
        }
    }

    @Implementation(minSdk=18)
    protected long getBlockSizeLong() {
        return 4096L;
    }

    @Implementation(minSdk=18)
    protected long getBlockCountLong() {
        return this.stat.blockCount;
    }

    @Implementation(minSdk=18)
    protected long getAvailableBlocksLong() {
        return this.stat.availableBlocks;
    }

    public static void registerStats(File path, int blockCount, int freeBlocks, int availableBlocks) {
        ShadowStatFs.registerStats(path.getAbsolutePath(), blockCount, freeBlocks, availableBlocks);
    }

    public static void registerStats(String path, int blockCount, int freeBlocks, int availableBlocks) {
        stats.put(path, new Stats(blockCount, freeBlocks, availableBlocks));
    }

    @Resetter
    public static void reset() {
        stats.clear();
    }

    private static class Stats {
        int blockCount;
        int freeBlocks;
        int availableBlocks;

        Stats(int blockCount, int freeBlocks, int availableBlocks) {
            this.blockCount = blockCount;
            this.freeBlocks = freeBlocks;
            this.availableBlocks = availableBlocks;
        }
    }
}

