/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothDevice;
import android.os.Build;
import android.telecom.Call;
import android.telecom.CallAudioState;
import android.telecom.InCallAdapter;
import android.telecom.InCallService;
import android.telecom.Phone;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowPhone;
import org.robolectric.shadows.ShadowService;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=InCallService.class, minSdk=23)
public class ShadowInCallService
extends ShadowService {
    @RealObject
    private InCallService inCallService;
    private ShadowPhone shadowPhone;
    private boolean canAddCall;
    private boolean muted;
    private int audioRoute = 1;
    private BluetoothDevice bluetoothDevice;

    @Implementation
    protected void __constructor__() {
        InCallAdapter adapter = (InCallAdapter)Shadow.newInstanceOf(InCallAdapter.class);
        Phone phone = Build.VERSION.SDK_INT > 25 ? (Phone)ReflectionHelpers.callConstructor(Phone.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(InCallAdapter.class, (Object)adapter), ReflectionHelpers.ClassParameter.from(String.class, (Object)""), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)0)}) : (Phone)ReflectionHelpers.callConstructor(Phone.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(InCallAdapter.class, (Object)adapter)});
        this.shadowPhone = (ShadowPhone)Shadow.extract((Object)phone);
        ReflectionHelpers.setField((Object)this.inCallService, (String)"mPhone", (Object)phone);
    }

    public void addCall(Call call) {
        this.shadowPhone.addCall(call);
    }

    @Implementation
    protected boolean canAddCall() {
        return this.canAddCall;
    }

    public void setCanAddCall(boolean canAddCall) {
        this.canAddCall = canAddCall;
    }

    @Implementation
    protected void setMuted(boolean muted) {
        this.muted = muted;
    }

    @Implementation
    protected void setAudioRoute(int audioRoute) {
        this.audioRoute = audioRoute;
    }

    @Implementation
    protected CallAudioState getCallAudioState() {
        return new CallAudioState(this.muted, this.audioRoute, 15);
    }

    @Implementation(minSdk=28)
    protected void requestBluetoothAudio(BluetoothDevice bluetoothDevice) {
        this.bluetoothDevice = bluetoothDevice;
    }

    @TargetApi(value=28)
    public BluetoothDevice getBluetoothAudio() {
        return this.bluetoothDevice;
    }
}

