/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.hardware.camera2.CameraAccessException;
import android.hardware.camera2.CameraCharacteristics;
import android.hardware.camera2.CameraDevice;
import android.hardware.camera2.CameraManager;
import android.hardware.camera2.impl.CameraDeviceImpl;
import android.os.Build;
import android.os.Handler;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=CameraManager.class, minSdk=21)
public class ShadowCameraManager {
    @RealObject
    private CameraManager realObject;
    private final Map<String, CameraCharacteristics> cameraIdToCharacteristics = new LinkedHashMap<String, CameraCharacteristics>();
    private final Map<String, Boolean> cameraTorches = new HashMap<String, Boolean>();

    @Implementation
    protected String[] getCameraIdList() throws CameraAccessException {
        Set<String> cameraIds = this.cameraIdToCharacteristics.keySet();
        return cameraIds.toArray(new String[0]);
    }

    @Implementation
    protected CameraCharacteristics getCameraCharacteristics(String cameraId) {
        Preconditions.checkNotNull((Object)cameraId);
        CameraCharacteristics characteristics = this.cameraIdToCharacteristics.get(cameraId);
        Preconditions.checkArgument((characteristics != null ? 1 : 0) != 0);
        return characteristics;
    }

    @Implementation(minSdk=23)
    protected void setTorchMode(String cameraId, boolean enabled) {
        Preconditions.checkNotNull((Object)cameraId);
        Preconditions.checkArgument((boolean)this.cameraIdToCharacteristics.keySet().contains(cameraId));
        this.cameraTorches.put(cameraId, enabled);
    }

    @Implementation(minSdk=28)
    protected CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Executor executor, int uid) throws CameraAccessException {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        Context context = ((ReflectorCameraManager)Reflector.reflector(ReflectorCameraManager.class, (Object)this.realObject)).getContext();
        CameraDeviceImpl deviceImpl = new CameraDeviceImpl(cameraId, callback, executor, characteristics, context.getApplicationInfo().targetSdkVersion);
        executor.execute(() -> callback.onOpened((CameraDevice)deviceImpl));
        return deviceImpl;
    }

    @Implementation(minSdk=25, maxSdk=27)
    protected CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Handler handler, int uid) throws CameraAccessException {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        Context context = ((ReflectorCameraManager)Reflector.reflector(ReflectorCameraManager.class, (Object)this.realObject)).getContext();
        CameraDeviceImpl deviceImpl = Build.VERSION.SDK_INT == 25 ? (CameraDeviceImpl)ReflectionHelpers.callConstructor(CameraDeviceImpl.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)cameraId), ReflectionHelpers.ClassParameter.from(CameraDevice.StateCallback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(Handler.class, (Object)handler), ReflectionHelpers.ClassParameter.from(CameraCharacteristics.class, (Object)characteristics)}) : (CameraDeviceImpl)ReflectionHelpers.callConstructor(CameraDeviceImpl.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)cameraId), ReflectionHelpers.ClassParameter.from(CameraDevice.StateCallback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(Handler.class, (Object)handler), ReflectionHelpers.ClassParameter.from(CameraCharacteristics.class, (Object)characteristics), ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)context.getApplicationInfo().targetSdkVersion)});
        handler.post(() -> callback.onOpened((CameraDevice)deviceImpl));
        return deviceImpl;
    }

    @Implementation(minSdk=21, maxSdk=24)
    protected CameraDevice openCameraDeviceUserAsync(String cameraId, CameraDevice.StateCallback callback, Handler handler) throws CameraAccessException {
        CameraCharacteristics characteristics = this.getCameraCharacteristics(cameraId);
        CameraDeviceImpl deviceImpl = (CameraDeviceImpl)ReflectionHelpers.callConstructor(CameraDeviceImpl.class, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(String.class, (Object)cameraId), ReflectionHelpers.ClassParameter.from(CameraDevice.StateCallback.class, (Object)callback), ReflectionHelpers.ClassParameter.from(Handler.class, (Object)handler), ReflectionHelpers.ClassParameter.from(CameraCharacteristics.class, (Object)characteristics)});
        handler.post(() -> callback.onOpened((CameraDevice)deviceImpl));
        return deviceImpl;
    }

    public void addCamera(String cameraId, CameraCharacteristics characteristics) {
        Preconditions.checkNotNull((Object)cameraId);
        Preconditions.checkNotNull((Object)characteristics);
        Preconditions.checkArgument((!this.cameraIdToCharacteristics.containsKey(cameraId) ? 1 : 0) != 0);
        this.cameraIdToCharacteristics.put(cameraId, characteristics);
    }

    public void removeCamera(String cameraId) {
        Preconditions.checkNotNull((Object)cameraId);
        Preconditions.checkArgument((boolean)this.cameraIdToCharacteristics.containsKey(cameraId));
        this.cameraIdToCharacteristics.remove(cameraId);
    }

    public boolean getTorchMode(String cameraId) {
        Preconditions.checkNotNull((Object)cameraId);
        Preconditions.checkArgument((boolean)this.cameraIdToCharacteristics.keySet().contains(cameraId));
        Boolean torchState = this.cameraTorches.get(cameraId);
        return torchState;
    }

    @Implements(className="android.hardware.camera2.CameraManager$CameraManagerGlobal", minSdk=21)
    public static class ShadowCameraManagerGlobal {
        @Implementation(minSdk=24)
        protected void scheduleCameraServiceReconnectionLocked() {
        }
    }

    @ForType(value=CameraManager.class)
    private static interface ReflectorCameraManager {
        @Accessor(value="mContext")
        public Context getContext();
    }
}

