/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.app.ApplicationPackageManager;
import android.app.admin.DevicePolicyManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.IntentSender;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ChangedPackages;
import android.content.pm.ComponentInfo;
import android.content.pm.FeatureInfo;
import android.content.pm.IPackageDataObserver;
import android.content.pm.IPackageDeleteObserver;
import android.content.pm.IPackageStatsObserver;
import android.content.pm.InstrumentationInfo;
import android.content.pm.IntentFilterVerificationInfo;
import android.content.pm.ModuleInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageItemInfo;
import android.content.pm.PackageManager;
import android.content.pm.PackageStats;
import android.content.pm.PermissionGroupInfo;
import android.content.pm.PermissionInfo;
import android.content.pm.ProviderInfo;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.content.pm.VerifierDeviceIdentity;
import android.content.res.AssetManager;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.os.Parcel;
import android.os.PersistableBundle;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.storage.VolumeInfo;
import android.telecom.TelecomManager;
import android.util.Log;
import android.util.Pair;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.function.BiConsumer;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.GetInstallerPackageNameMode;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.config.ConfigurationRegistry;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowPackageManager;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=ApplicationPackageManager.class, isInAndroidSdk=false, looseSignatures=true)
public class ShadowApplicationPackageManager
extends ShadowPackageManager {
    private static final String PLATFORM_PACKAGE_NAME = "android";
    private static final String PACKAGE_MIME_TYPE = "application/vnd.android.package-archive";
    private static final String PACKAGE_SCHEME = "package";
    @RealObject
    private ApplicationPackageManager realObject;

    @Implementation
    public List<PackageInfo> getInstalledPackages(int flags) {
        ArrayList<PackageInfo> result = new ArrayList<PackageInfo>();
        for (String packageName : packageInfos.keySet()) {
            try {
                PackageInfo packageInfo = this.getPackageInfo(packageName, flags);
                result.add(packageInfo);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.i((String)"PackageManager", (String)String.format("Package %s filtered out: %s", packageName, e.getMessage()));
            }
        }
        return result;
    }

    @Implementation(minSdk=29)
    protected List<ModuleInfo> getInstalledModules(int flags) {
        ArrayList<ModuleInfo> result = new ArrayList<ModuleInfo>();
        for (String moduleName : moduleInfos.keySet()) {
            try {
                ModuleInfo moduleInfo = (ModuleInfo)this.getModuleInfo(moduleName, flags);
                result.add(moduleInfo);
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.i((String)"PackageManager", (String)String.format("Module %s filtered out: %s", moduleName, e.getMessage()));
            }
        }
        return result;
    }

    @Implementation(minSdk=29)
    protected Object getModuleInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        this.getPackageInfo(packageName, flags);
        Object info = moduleInfos.get(packageName);
        if (info == null) {
            throw new PackageManager.NameNotFoundException(new StringBuilder(26 + String.valueOf(packageName).length()).append("Module: ").append(packageName).append(" is not installed.").toString());
        }
        return info;
    }

    @Implementation
    protected ActivityInfo getActivityInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
        return (ActivityInfo)this.getComponentInfo(component, flags, (Function<PackageInfo, T[]>)((Function)packageInfo -> packageInfo.activities), resolveInfo -> resolveInfo.activityInfo, ActivityInfo::new);
    }

    private <T extends ComponentInfo> T getComponentInfo(ComponentName component, int flags, Function<PackageInfo, T[]> componentsInPackage, Function<ResolveInfo, T> componentInResolveInfo, Function<T, T> copyConstructor) throws PackageManager.NameNotFoundException {
        String activityName = component.getClassName();
        String packageName = component.getPackageName();
        PackageInfo packageInfo = (PackageInfo)packageInfos.get(packageName);
        ComponentInfo result = null;
        ApplicationInfo appInfo = null;
        if (packageInfo != null) {
            ComponentInfo[] components;
            if (packageInfo.applicationInfo != null) {
                appInfo = packageInfo.applicationInfo;
            }
            if ((components = (ComponentInfo[])componentsInPackage.apply((Object)packageInfo)) != null) {
                for (ComponentInfo activity : components) {
                    if (!activityName.equals(activity.name)) continue;
                    result = (ComponentInfo)copyConstructor.apply((Object)activity);
                    break;
                }
            }
        }
        if (result == null) {
            block1: for (List listOfResolveInfo : resolveInfoForIntent.values()) {
                for (ResolveInfo resolveInfo : listOfResolveInfo) {
                    ComponentInfo info = (ComponentInfo)componentInResolveInfo.apply((Object)resolveInfo);
                    if (!ShadowApplicationPackageManager.isValidComponentInfo(info) || !component.equals((Object)new ComponentName(info.applicationInfo.packageName, info.name))) continue;
                    result = (ComponentInfo)copyConstructor.apply((Object)info);
                    if (appInfo != null) break block1;
                    appInfo = result.applicationInfo;
                    break block1;
                }
            }
        }
        if (result == null) {
            String string = String.valueOf(component);
            throw new PackageManager.NameNotFoundException(new StringBuilder(21 + String.valueOf(string).length()).append("Component not found: ").append(string).toString());
        }
        if (appInfo == null) {
            appInfo = new ApplicationInfo();
            appInfo.packageName = packageName;
            appInfo.flags = 0x800000;
        } else {
            appInfo = new ApplicationInfo(appInfo);
        }
        result.applicationInfo = appInfo;
        this.applyFlagsToComponentInfo(result, flags);
        return (T)result;
    }

    @Implementation
    protected boolean hasSystemFeature(String name) {
        return systemFeatureList.containsKey(name) ? (Boolean)systemFeatureList.get(name) : false;
    }

    @Implementation
    protected int getComponentEnabledSetting(ComponentName componentName) {
        ShadowPackageManager.ComponentState state = (ShadowPackageManager.ComponentState)componentList.get(componentName);
        return state != null ? state.newState : 0;
    }

    @Implementation
    protected String getNameForUid(int uid) {
        return (String)namesForUid.get(uid);
    }

    @Override
    @Implementation
    protected String[] getPackagesForUid(int uid) {
        String[] packageNames = (String[])packagesForUid.get(uid);
        if (packageNames != null) {
            return packageNames;
        }
        HashSet<String> results = new HashSet<String>();
        for (PackageInfo packageInfo : packageInfos.values()) {
            if (packageInfo.applicationInfo == null || packageInfo.applicationInfo.uid != uid) continue;
            results.add(packageInfo.packageName);
        }
        return results.isEmpty() ? null : results.toArray(new String[results.size()]);
    }

    @Implementation
    protected int getApplicationEnabledSetting(String packageName) {
        if (!packageInfos.containsKey(packageName)) {
            String string = String.valueOf(packageName);
            throw new IllegalArgumentException(string.length() != 0 ? "Package doesn't exist: ".concat(string) : new String("Package doesn't exist: "));
        }
        return (Integer)applicationEnabledSettingMap.get(packageName);
    }

    @Implementation
    protected ProviderInfo getProviderInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
        return (ProviderInfo)this.getComponentInfo(component, flags, (Function<PackageInfo, T[]>)((Function)packageInfo -> packageInfo.providers), resolveInfo -> resolveInfo.providerInfo, ProviderInfo::new);
    }

    @Implementation
    protected void setComponentEnabledSetting(ComponentName componentName, int newState, int flags) {
        componentList.put(componentName, new ShadowPackageManager.ComponentState(newState, flags));
    }

    @Implementation
    protected void setApplicationEnabledSetting(String packageName, int newState, int flags) {
        applicationEnabledSettingMap.put(packageName, newState);
    }

    @Implementation
    protected ResolveInfo resolveActivity(Intent intent, int flags) {
        List<ResolveInfo> candidates = this.queryIntentActivities(intent, flags);
        if (candidates.isEmpty()) {
            return null;
        }
        if (candidates.size() == 1) {
            return candidates.get(0);
        }
        ResolveInfo persistentPreferredResolveInfo = this.resolvePreferredActivity(intent, candidates, persistentPreferredActivities);
        if (persistentPreferredResolveInfo != null) {
            return persistentPreferredResolveInfo;
        }
        ResolveInfo preferredResolveInfo = this.resolvePreferredActivity(intent, candidates, preferredActivities);
        if (preferredResolveInfo != null) {
            return preferredResolveInfo;
        }
        if (!this.shouldShowActivityChooser) {
            return candidates.get(0);
        }
        ResolveInfo c1 = candidates.get(0);
        ResolveInfo c2 = candidates.get(1);
        if (c1.preferredOrder == c2.preferredOrder && ShadowApplicationPackageManager.isValidComponentInfo((ComponentInfo)c1.activityInfo) && ShadowApplicationPackageManager.isValidComponentInfo((ComponentInfo)c2.activityInfo)) {
            ResolveInfo result = new ResolveInfo();
            result.activityInfo = new ActivityInfo();
            result.activityInfo.name = "ActivityResolver";
            result.activityInfo.packageName = PLATFORM_PACKAGE_NAME;
            result.activityInfo.applicationInfo = new ApplicationInfo();
            result.activityInfo.applicationInfo.flags = 0x800001;
            result.activityInfo.applicationInfo.packageName = PLATFORM_PACKAGE_NAME;
            return result;
        }
        return c1;
    }

    private ResolveInfo resolvePreferredActivity(Intent intent, List<ResolveInfo> candidates, SortedMap<ComponentName, List<IntentFilter>> preferredActivities) {
        preferredActivities = ShadowApplicationPackageManager.mapForPackage(preferredActivities, intent.getPackage());
        for (ResolveInfo candidate : candidates) {
            ComponentName candidateName;
            List intentFilters;
            ActivityInfo activityInfo = candidate.activityInfo;
            if (!ShadowApplicationPackageManager.isValidComponentInfo((ComponentInfo)activityInfo) || (intentFilters = (List)preferredActivities.get(candidateName = new ComponentName(activityInfo.applicationInfo.packageName, activityInfo.name))) == null) continue;
            for (IntentFilter filter : intentFilters) {
                if ((filter.match(this.getContext().getContentResolver(), intent, false, "robo") & 0xFFF0000) == 0) continue;
                return candidate;
            }
        }
        return null;
    }

    @Implementation
    protected ProviderInfo resolveContentProvider(String name, int flags) {
        if (name == null) {
            return null;
        }
        for (PackageInfo packageInfo : packageInfos.values()) {
            if (packageInfo.providers == null) continue;
            for (ProviderInfo providerInfo : packageInfo.providers) {
                if (!name.equals(providerInfo.authority)) continue;
                return new ProviderInfo(providerInfo);
            }
        }
        return null;
    }

    @Implementation(minSdk=21)
    protected ProviderInfo resolveContentProviderAsUser(String name, int flags, int userId) {
        return null;
    }

    @Implementation
    protected synchronized PackageInfo getPackageInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        PackageInfo info = (PackageInfo)packageInfos.get(packageName);
        if (info == null && (flags & 0x2000) != 0 && deletedPackages.contains(packageName)) {
            info = new PackageInfo();
            info.packageName = packageName;
            info.applicationInfo = new ApplicationInfo();
            info.applicationInfo.packageName = packageName;
        }
        if (info == null) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        info = ShadowApplicationPackageManager.newPackageInfo(info);
        if (info.applicationInfo == null) {
            return info;
        }
        if (hiddenPackages.contains(packageName) && !ShadowApplicationPackageManager.isFlagSet(flags, 8192)) {
            throw new PackageManager.NameNotFoundException("Package is hidden, can't find");
        }
        this.applyFlagsToApplicationInfo(info.applicationInfo, flags);
        info.activities = (ActivityInfo[])this.applyFlagsToComponentInfoList((ComponentInfo[])info.activities, flags, 1, ActivityInfo::new);
        info.services = (ServiceInfo[])this.applyFlagsToComponentInfoList((ComponentInfo[])info.services, flags, 4, ServiceInfo::new);
        info.receivers = (ActivityInfo[])this.applyFlagsToComponentInfoList((ComponentInfo[])info.receivers, flags, 2, ActivityInfo::new);
        info.providers = (ProviderInfo[])this.applyFlagsToComponentInfoList((ComponentInfo[])info.providers, flags, 8, ProviderInfo::new);
        return info;
    }

    private static PackageInfo newPackageInfo(PackageInfo orig) {
        Parcel parcel = Parcel.obtain();
        orig.writeToParcel(parcel, 0);
        parcel.setDataPosition(0);
        return (PackageInfo)PackageInfo.CREATOR.createFromParcel(parcel);
    }

    private <T extends ComponentInfo> T[] applyFlagsToComponentInfoList(T[] components, int flags, int activationFlag, Function<T, T> copyConstructor) {
        if (components == null || (flags & activationFlag) == 0) {
            return null;
        }
        ArrayList<T> returned = new ArrayList<T>(components.length);
        for (Object component : components) {
            component = (ComponentInfo)copyConstructor.apply(component);
            try {
                this.applyFlagsToComponentInfo((ComponentInfo)component, flags);
                returned.add(component);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
        if (returned.isEmpty()) {
            return null;
        }
        Class<?> componentArrayType = components.getClass();
        ComponentInfo[] result = (ComponentInfo[])Arrays.copyOf(components, returned.size(), componentArrayType);
        return returned.toArray(result);
    }

    @Implementation
    protected List<ResolveInfo> queryIntentServices(Intent intent, int flags) {
        return this.queryIntentComponents(intent, flags, (Function<PackageInfo, I[]>)((Function)pkg -> pkg.services), serviceFilters, (resolveInfo, serviceInfo) -> {
            resolveInfo.serviceInfo = serviceInfo;
        }, resolveInfo -> resolveInfo.serviceInfo, ServiceInfo::new);
    }

    private boolean hasSomeComponentInfo(ResolveInfo resolveInfo) {
        return resolveInfo.activityInfo != null || resolveInfo.serviceInfo != null || Build.VERSION.SDK_INT >= 19 && resolveInfo.providerInfo != null;
    }

    private static boolean isFlagSet(int flags, int matchFlag) {
        return (flags & matchFlag) == matchFlag;
    }

    private static boolean isValidComponentInfo(ComponentInfo componentInfo) {
        return componentInfo != null && componentInfo.applicationInfo != null && componentInfo.applicationInfo.packageName != null && componentInfo.name != null;
    }

    @Implementation(minSdk=17)
    protected List<ResolveInfo> queryIntentServicesAsUser(Intent intent, int flags, int userId) {
        return this.queryIntentServices(intent, flags);
    }

    @Implementation
    protected List<ResolveInfo> queryIntentActivities(Intent intent, int flags) {
        return this.queryIntentComponents(intent, flags, (Function<PackageInfo, I[]>)((Function)pkg -> pkg.activities), activityFilters, (resolveInfo, activityInfo) -> {
            resolveInfo.activityInfo = activityInfo;
        }, resolveInfo -> resolveInfo.activityInfo, ActivityInfo::new);
    }

    private <I extends ComponentInfo> List<ResolveInfo> queryIntentComponents(Intent intent, int flags, Function<PackageInfo, I[]> componentsInPackage, SortedMap<ComponentName, List<IntentFilter>> filters, BiConsumer<ResolveInfo, I> componentSetter, Function<ResolveInfo, I> componentInResolveInfo, Function<I, I> copyConstructor) {
        if (intent.getComponent() != null) {
            flags &= 0xFFFEFFFF;
        }
        ArrayList<ResolveInfo> result = new ArrayList<ResolveInfo>();
        List<ResolveInfo> resolveInfoList = this.queryOverriddenIntents(intent, flags);
        if (!resolveInfoList.isEmpty()) {
            result.addAll(resolveInfoList);
        }
        result.addAll(this.queryComponentsInManifest(intent, componentsInPackage, filters, componentSetter));
        Iterator iterator = result.iterator();
        while (iterator.hasNext()) {
            ResolveInfo resolveInfo = (ResolveInfo)iterator.next();
            ComponentInfo componentInfo = (ComponentInfo)componentInResolveInfo.apply((Object)resolveInfo);
            if (this.hasSomeComponentInfo(resolveInfo) && componentInfo == null) {
                Log.d((String)"PackageManager", (String)"ResolveInfo for different component type");
                iterator.remove();
                continue;
            }
            if (componentInfo == null) continue;
            if (!this.applyFlagsToResolveInfo(resolveInfo, flags)) {
                Log.d((String)"PackageManager", (String)"ResolveInfo doesn't match flags");
                iterator.remove();
                continue;
            }
            ApplicationInfo applicationInfo = componentInfo.applicationInfo;
            if (applicationInfo == null) {
                String packageName = null;
                if (ShadowApplicationPackageManager.getComponentForIntent(intent) != null) {
                    packageName = ShadowApplicationPackageManager.getComponentForIntent(intent).getPackageName();
                } else if (intent.getPackage() != null) {
                    packageName = intent.getPackage();
                } else if (componentInfo.packageName != null) {
                    packageName = componentInfo.packageName;
                }
                if (packageName != null) {
                    PackageInfo packageInfo = (PackageInfo)packageInfos.get(packageName);
                    if (packageInfo != null && packageInfo.applicationInfo != null) {
                        applicationInfo = new ApplicationInfo(packageInfo.applicationInfo);
                    } else {
                        applicationInfo = new ApplicationInfo();
                        applicationInfo.packageName = packageName;
                        applicationInfo.flags = 0x800000;
                    }
                }
            } else {
                applicationInfo = new ApplicationInfo(applicationInfo);
            }
            componentInfo = (ComponentInfo)copyConstructor.apply((Object)componentInfo);
            componentSetter.accept(resolveInfo, componentInfo);
            componentInfo.applicationInfo = applicationInfo;
            try {
                this.applyFlagsToComponentInfo(componentInfo, flags);
            }
            catch (PackageManager.NameNotFoundException e) {
                String string = String.valueOf(e.getMessage());
                Log.d((String)"PackageManager", (String)(string.length() != 0 ? "ComponentInfo doesn't match flags:".concat(string) : new String("ComponentInfo doesn't match flags:")));
                iterator.remove();
            }
        }
        Collections.sort(result, new ShadowPackageManager.ResolveInfoComparator());
        return result;
    }

    private boolean applyFlagsToResolveInfo(ResolveInfo resolveInfo, int flags) {
        if ((flags & 0x40) == 0) {
            resolveInfo.filter = null;
        }
        return (flags & 0x10000) == 0 || resolveInfo.isDefault;
    }

    private <I extends ComponentInfo> List<ResolveInfo> queryComponentsInManifest(Intent intent, Function<PackageInfo, I[]> componentsInPackage, SortedMap<ComponentName, List<IntentFilter>> filters, BiConsumer<ResolveInfo, I> componentSetter) {
        if (ShadowApplicationPackageManager.isExplicitIntent(intent)) {
            ComponentName component = ShadowApplicationPackageManager.getComponentForIntent(intent);
            PackageInfo appPackage = (PackageInfo)packageInfos.get(component.getPackageName());
            if (appPackage == null) {
                return Collections.emptyList();
            }
            ComponentInfo componentInfo = ShadowApplicationPackageManager.findMatchingComponent((ComponentName)component, (ComponentInfo[])((ComponentInfo[])componentsInPackage.apply((Object)appPackage)));
            if (componentInfo != null) {
                ResolveInfo resolveInfo = ShadowApplicationPackageManager.buildResolveInfo(componentInfo);
                componentSetter.accept(resolveInfo, componentInfo);
                return Collections.singletonList(resolveInfo);
            }
            return Collections.emptyList();
        }
        ArrayList<ResolveInfo> resolveInfoList = new ArrayList<ResolveInfo>();
        SortedMap<ComponentName, List<IntentFilter>> filtersForPackage = ShadowApplicationPackageManager.mapForPackage(filters, intent.getPackage());
        block0: for (Map.Entry componentEntry : filtersForPackage.entrySet()) {
            ComponentName componentName = (ComponentName)componentEntry.getKey();
            for (IntentFilter filter : (List)componentEntry.getValue()) {
                ComponentInfo[] componentInfoArray;
                int match = ShadowApplicationPackageManager.matchIntentFilter(intent, filter);
                if (match <= 0) continue;
                PackageInfo packageInfo = (PackageInfo)packageInfos.get(componentName.getPackageName());
                for (ComponentInfo componentInfo : componentInfoArray = (ComponentInfo[])componentsInPackage.apply((Object)packageInfo)) {
                    if (!componentInfo.name.equals(componentName.getClassName())) continue;
                    ResolveInfo resolveInfo = ShadowApplicationPackageManager.buildResolveInfo(componentInfo, filter);
                    resolveInfo.match = match;
                    componentSetter.accept(resolveInfo, componentInfo);
                    resolveInfoList.add(resolveInfo);
                    continue block0;
                }
            }
        }
        return resolveInfoList;
    }

    @Implementation(minSdk=17)
    protected List<ResolveInfo> queryIntentActivitiesAsUser(Intent intent, int flags, int userId) {
        return this.queryIntentActivities(intent, flags);
    }

    private static boolean isExplicitIntent(Intent intent) {
        return ShadowApplicationPackageManager.getComponentForIntent(intent) != null;
    }

    private static <T extends ComponentInfo> T findMatchingComponent(ComponentName componentName, T[] components) {
        if (components == null) {
            return null;
        }
        for (T component : components) {
            if (!componentName.equals((Object)new ComponentName(((ComponentInfo)component).packageName, ((ComponentInfo)component).name))) continue;
            return component;
        }
        return null;
    }

    private static ComponentName getComponentForIntent(Intent intent) {
        ComponentName component = intent.getComponent();
        if (component == null && intent.getSelector() != null) {
            intent = intent.getSelector();
            component = intent.getComponent();
        }
        return component;
    }

    private static ResolveInfo buildResolveInfo(ComponentInfo componentInfo) {
        ResolveInfo resolveInfo = new ResolveInfo();
        resolveInfo.resolvePackageName = componentInfo.applicationInfo.packageName;
        resolveInfo.labelRes = componentInfo.labelRes;
        resolveInfo.icon = componentInfo.icon;
        resolveInfo.nonLocalizedLabel = componentInfo.nonLocalizedLabel;
        return resolveInfo;
    }

    static ResolveInfo buildResolveInfo(ComponentInfo componentInfo, IntentFilter intentFilter) {
        ResolveInfo info = ShadowApplicationPackageManager.buildResolveInfo(componentInfo);
        info.isDefault = intentFilter.hasCategory("android.intent.category.DEFAULT");
        info.filter = new IntentFilter(intentFilter);
        info.priority = intentFilter.getPriority();
        return info;
    }

    @Implementation
    protected int checkPermission(String permName, String pkgName) {
        PackageInfo permissionsInfo = (PackageInfo)packageInfos.get(pkgName);
        if (permissionsInfo == null || permissionsInfo.requestedPermissions == null) {
            return -1;
        }
        for (int i = 0; i < permissionsInfo.requestedPermissions.length; ++i) {
            String permission2 = permissionsInfo.requestedPermissions[i];
            if (permission2 == null || !permission2.equals(permName)) continue;
            if (this.isGrantedForBackwardsCompatibility(pkgName, permissionsInfo)) {
                return 0;
            }
            if ((permissionsInfo.requestedPermissionsFlags[i] & 2) != 2) continue;
            return 0;
        }
        return -1;
    }

    private boolean isGrantedForBackwardsCompatibility(String pkgName, PackageInfo permissionsInfo) {
        return permissionsInfo.requestedPermissionsFlags == null || pkgName.equals(RuntimeEnvironment.application.getPackageName());
    }

    @Implementation
    protected ActivityInfo getReceiverInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
        return (ActivityInfo)this.getComponentInfo(component, flags, (Function<PackageInfo, T[]>)((Function)packageInfo -> packageInfo.receivers), resolveInfo -> resolveInfo.activityInfo, ActivityInfo::new);
    }

    @Implementation
    protected List<ResolveInfo> queryBroadcastReceivers(Intent intent, int flags) {
        return this.queryIntentComponents(intent, flags, (Function<PackageInfo, I[]>)((Function)pkg -> pkg.receivers), receiverFilters, (resolveInfo, activityInfo) -> {
            resolveInfo.activityInfo = activityInfo;
        }, resolveInfo -> resolveInfo.activityInfo, ActivityInfo::new);
    }

    private static int matchIntentFilter(Intent intent, IntentFilter intentFilter) {
        return intentFilter.match(intent.getAction(), intent.getType(), intent.getScheme(), intent.getData(), intent.getCategories(), "PackageManager");
    }

    @Implementation
    protected ResolveInfo resolveService(Intent intent, int flags) {
        List<ResolveInfo> candidates = this.queryIntentServices(intent, flags);
        return candidates.isEmpty() ? null : candidates.get(0);
    }

    @Implementation
    protected ServiceInfo getServiceInfo(ComponentName component, int flags) throws PackageManager.NameNotFoundException {
        return (ServiceInfo)this.getComponentInfo(component, flags, (Function<PackageInfo, T[]>)((Function)packageInfo -> packageInfo.services), resolveInfo -> resolveInfo.serviceInfo, ServiceInfo::new);
    }

    private void applyFlagsToComponentInfo(ComponentInfo componentInfo, int flags) throws PackageManager.NameNotFoundException {
        int applicationFlags;
        boolean isEnabledForFiltering;
        componentInfo.name = componentInfo.name == null ? "" : componentInfo.name;
        ApplicationInfo applicationInfo = componentInfo.applicationInfo;
        boolean isApplicationEnabled = true;
        if (applicationInfo != null) {
            if (applicationInfo.packageName == null) {
                applicationInfo.packageName = componentInfo.packageName;
            }
            this.applyFlagsToApplicationInfo(componentInfo.applicationInfo, flags);
            componentInfo.packageName = applicationInfo.packageName;
            isApplicationEnabled = applicationInfo.enabled;
        }
        if ((flags & 0x80) == 0) {
            componentInfo.metaData = null;
        }
        boolean isComponentEnabled = ShadowApplicationPackageManager.isComponentEnabled(componentInfo);
        if ((flags & 0x20000) != 0 && Build.VERSION.SDK_INT >= 23) {
            return;
        }
        boolean bl = isEnabledForFiltering = isComponentEnabled && (Build.VERSION.SDK_INT < 24 || isApplicationEnabled);
        if ((flags & 0x200) == 0 && !isEnabledForFiltering) {
            String string = String.valueOf(componentInfo);
            throw new PackageManager.NameNotFoundException(new StringBuilder(20 + String.valueOf(string).length()).append("Disabled component: ").append(string).toString());
        }
        if (ShadowApplicationPackageManager.isFlagSet(flags, 0x100000) && applicationInfo != null && ((applicationFlags = applicationInfo.flags) & 1) != 1) {
            String string = String.valueOf(componentInfo);
            throw new PackageManager.NameNotFoundException(new StringBuilder(22 + String.valueOf(string).length()).append("Not system component: ").append(string).toString());
        }
        if (!ShadowApplicationPackageManager.isFlagSet(flags, 8192) && ShadowApplicationPackageManager.isValidComponentInfo(componentInfo) && hiddenPackages.contains(componentInfo.applicationInfo.packageName)) {
            String string = String.valueOf(componentInfo);
            throw new PackageManager.NameNotFoundException(new StringBuilder(21 + String.valueOf(string).length()).append("Uninstalled package: ").append(string).toString());
        }
    }

    @Implementation
    protected Resources getResourcesForApplication(ApplicationInfo applicationInfo) throws PackageManager.NameNotFoundException {
        if (this.getContext().getPackageName().equals(applicationInfo.packageName)) {
            return this.getContext().getResources();
        }
        if (packageInfos.containsKey(applicationInfo.packageName)) {
            Resources appResources = (Resources)resources.get(applicationInfo.packageName);
            if (appResources == null) {
                appResources = new Resources(new AssetManager(), null, null);
                resources.put(applicationInfo.packageName, appResources);
            }
            return appResources;
        }
        Resources resources = null;
        if (RuntimeEnvironment.useLegacyResources() && (applicationInfo.publicSourceDir == null || !new File(applicationInfo.publicSourceDir).exists())) {
            throw new PackageManager.NameNotFoundException(applicationInfo.packageName);
        }
        try {
            resources = ((ApplicationPackageManager)Shadow.directlyOn((Object)this.realObject, ApplicationPackageManager.class)).getResourcesForApplication(applicationInfo);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (resources == null) {
            throw new PackageManager.NameNotFoundException(applicationInfo.packageName);
        }
        return resources;
    }

    @Implementation
    protected List<ApplicationInfo> getInstalledApplications(int flags) {
        List<PackageInfo> packageInfos = this.getInstalledPackages(flags);
        ArrayList<ApplicationInfo> result = new ArrayList<ApplicationInfo>(packageInfos.size());
        for (PackageInfo packageInfo : packageInfos) {
            if (packageInfo.applicationInfo == null) continue;
            result.add(packageInfo.applicationInfo);
        }
        return result;
    }

    @Implementation
    protected String getInstallerPackageName(String packageName) {
        if (ConfigurationRegistry.get(GetInstallerPackageNameMode.Mode.class) == GetInstallerPackageNameMode.Mode.REALISTIC && !packageInstallerMap.containsKey(packageName)) {
            String string = String.valueOf(packageName);
            throw new IllegalArgumentException(string.length() != 0 ? "Package is not installed: ".concat(string) : new String("Package is not installed: "));
        }
        if (!packageInstallerMap.containsKey(packageName)) {
            Log.w((String)"PackageManager", (String)String.format("Call to getInstallerPackageName returns null for package: '%s'. Please run setInstallerPackageName to set installer package name before making the call.", packageName));
        }
        return (String)packageInstallerMap.get(packageName);
    }

    @Implementation
    protected PermissionInfo getPermissionInfo(String name, int flags) throws PackageManager.NameNotFoundException {
        PermissionInfo permissionInfo = (PermissionInfo)extraPermissions.get(name);
        if (permissionInfo != null) {
            return permissionInfo;
        }
        for (PackageInfo packageInfo : packageInfos.values()) {
            if (packageInfo.permissions == null) continue;
            for (PermissionInfo permission2 : packageInfo.permissions) {
                if (!name.equals(permission2.name)) continue;
                return ShadowApplicationPackageManager.createCopyPermissionInfo(permission2, flags);
            }
        }
        throw new PackageManager.NameNotFoundException(name);
    }

    @Implementation(minSdk=23)
    protected boolean shouldShowRequestPermissionRationale(String permission2) {
        return permissionRationaleMap.containsKey(permission2) ? (Boolean)permissionRationaleMap.get(permission2) : false;
    }

    @Implementation
    protected FeatureInfo[] getSystemAvailableFeatures() {
        return systemAvailableFeatures.isEmpty() ? null : systemAvailableFeatures.toArray(new FeatureInfo[systemAvailableFeatures.size()]);
    }

    @Implementation
    protected void verifyPendingInstall(int id2, int verificationCode) {
        if (verificationResults.containsKey(id2)) {
            throw new IllegalStateException(new StringBuilder(41).append("Multiple verifications for id=").append(id2).toString());
        }
        verificationResults.put(id2, verificationCode);
    }

    @Implementation(minSdk=17)
    protected void extendVerificationTimeout(int id2, int verificationCodeAtTimeout, long millisecondsToDelay) {
        verificationTimeoutExtension.put(id2, millisecondsToDelay);
    }

    @Override
    @Implementation(maxSdk=22)
    protected void freeStorageAndNotify(long freeStorageSize, IPackageDataObserver observer) {
    }

    @Implementation(minSdk=23)
    protected void freeStorageAndNotify(String volumeUuid, long freeStorageSize, IPackageDataObserver observer) {
    }

    @Implementation
    protected void setInstallerPackageName(String targetPackage, String installerPackageName) {
        packageInstallerMap.put(targetPackage, installerPackageName);
    }

    @Implementation(minSdk=19)
    protected List<ResolveInfo> queryIntentContentProviders(Intent intent, int flags) {
        return this.queryIntentComponents(intent, flags, (Function<PackageInfo, I[]>)((Function)pkg -> pkg.providers), providerFilters, (resolveInfo, providerInfo) -> {
            resolveInfo.providerInfo = providerInfo;
        }, resolveInfo -> resolveInfo.providerInfo, ProviderInfo::new);
    }

    @Implementation(minSdk=19)
    protected List<ResolveInfo> queryIntentContentProvidersAsUser(Intent intent, int flags, int userId) {
        return Collections.emptyList();
    }

    @Implementation(minSdk=23)
    protected String getPermissionControllerPackageName() {
        return null;
    }

    @Implementation(maxSdk=16)
    protected void getPackageSizeInfo(Object pkgName, Object observer) {
        PackageStats packageStats = (PackageStats)packageStatsMap.get((String)pkgName);
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                ((IPackageStatsObserver)observer).onGetStatsCompleted(packageStats, packageStats != null);
            }
            catch (RemoteException remoteException) {
                remoteException.rethrowFromSystemServer();
            }
        });
    }

    @Implementation(minSdk=17, maxSdk=23)
    protected void getPackageSizeInfo(Object pkgName, Object uid, Object observer) {
        PackageStats packageStats = (PackageStats)packageStatsMap.get((String)pkgName);
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                ((IPackageStatsObserver)observer).onGetStatsCompleted(packageStats, packageStats != null);
            }
            catch (RemoteException remoteException) {
                remoteException.rethrowFromSystemServer();
            }
        });
    }

    @Implementation(minSdk=24)
    protected void getPackageSizeInfoAsUser(Object pkgName, Object uid, Object observer) {
        PackageStats packageStats = (PackageStats)packageStatsMap.get((String)pkgName);
        new Handler(Looper.getMainLooper()).post(() -> {
            try {
                ((IPackageStatsObserver)observer).onGetStatsCompleted(packageStats, packageStats != null);
            }
            catch (RemoteException remoteException) {
                remoteException.rethrowFromSystemServer();
            }
        });
    }

    @Override
    @Implementation
    protected void deletePackage(String packageName, IPackageDeleteObserver observer, int flags) {
        super.deletePackage(packageName, observer, flags);
    }

    @Implementation
    protected String[] currentToCanonicalPackageNames(String[] names) {
        String[] out = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            out[i] = currentToCanonicalNames.getOrDefault(names[i], names[i]);
        }
        return out;
    }

    @Implementation
    protected String[] canonicalToCurrentPackageNames(String[] names) {
        String[] out = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            out[i] = canonicalToCurrentNames.getOrDefault(names[i], names[i]);
        }
        return out;
    }

    @Implementation
    protected boolean isSafeMode() {
        return safeMode;
    }

    @Implementation
    protected Drawable getApplicationIcon(String packageName) throws PackageManager.NameNotFoundException {
        return (Drawable)applicationIcons.get(packageName);
    }

    @Implementation
    protected Drawable getApplicationIcon(ApplicationInfo info) throws PackageManager.NameNotFoundException {
        return this.getApplicationIcon(info.packageName);
    }

    @Implementation(minSdk=21)
    protected Drawable getUserBadgeForDensity(UserHandle userHandle, int i) {
        return null;
    }

    @Implementation
    protected int checkSignatures(String pkg1, String pkg2) {
        try {
            PackageInfo packageInfo1 = this.getPackageInfo(pkg1, 64);
            PackageInfo packageInfo2 = this.getPackageInfo(pkg2, 64);
            return ShadowApplicationPackageManager.compareSignature(packageInfo1.signatures, packageInfo2.signatures);
        }
        catch (PackageManager.NameNotFoundException e) {
            return -4;
        }
    }

    @Implementation
    protected int checkSignatures(int uid1, int uid2) {
        return 0;
    }

    @Implementation
    protected List<PermissionInfo> queryPermissionsByGroup(String group, int flags) throws PackageManager.NameNotFoundException {
        ArrayList<PermissionInfo> result = new ArrayList<PermissionInfo>();
        for (PermissionInfo permissionInfo : extraPermissions.values()) {
            if (!Objects.equals(permissionInfo.group, group)) continue;
            result.add(permissionInfo);
        }
        for (PackageInfo packageInfo : packageInfos.values()) {
            if (packageInfo.permissions == null) continue;
            for (PermissionInfo permission2 : packageInfo.permissions) {
                if (!Objects.equals(group, permission2.group)) continue;
                result.add(ShadowApplicationPackageManager.createCopyPermissionInfo(permission2, flags));
            }
        }
        if (result.isEmpty()) {
            throw new PackageManager.NameNotFoundException(group);
        }
        return result;
    }

    private static PermissionInfo createCopyPermissionInfo(PermissionInfo src, int flags) {
        PermissionInfo matchedPermission = new PermissionInfo(src);
        if ((flags & 0x80) != 128) {
            matchedPermission.metaData = null;
        }
        return matchedPermission;
    }

    private Intent getLaunchIntentForPackage(String packageName, String launcherCategory) {
        Intent intentToResolve = new Intent("android.intent.action.MAIN");
        intentToResolve.addCategory("android.intent.category.INFO");
        intentToResolve.setPackage(packageName);
        List<ResolveInfo> ris = this.queryIntentActivities(intentToResolve, 0);
        if (ris == null || ris.isEmpty()) {
            intentToResolve.removeCategory("android.intent.category.INFO");
            intentToResolve.addCategory(launcherCategory);
            intentToResolve.setPackage(packageName);
            ris = this.queryIntentActivities(intentToResolve, 0);
        }
        if (ris == null || ris.isEmpty()) {
            return null;
        }
        Intent intent = new Intent(intentToResolve);
        intent.setFlags(0x10000000);
        intent.setClassName(packageName, ris.get((int)0).activityInfo.name);
        return intent;
    }

    @Implementation
    protected Intent getLaunchIntentForPackage(String packageName) {
        return this.getLaunchIntentForPackage(packageName, "android.intent.category.LAUNCHER");
    }

    @Implementation(minSdk=21)
    protected Intent getLeanbackLaunchIntentForPackage(String packageName) {
        return this.getLaunchIntentForPackage(packageName, "android.intent.category.LEANBACK_LAUNCHER");
    }

    @Implementation(minSdk=24)
    protected PackageInfo getPackageInfoAsUser(String packageName, int flags, int userId) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected int[] getPackageGids(String packageName) throws PackageManager.NameNotFoundException {
        return new int[0];
    }

    @Implementation(minSdk=24)
    protected int[] getPackageGids(String packageName, int flags) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation(minSdk=18)
    protected int getPackageUid(String packageName, int flags) throws PackageManager.NameNotFoundException {
        Integer uid = (Integer)uidForPackage.get(packageName);
        if (uid == null) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        return uid;
    }

    @Implementation(minSdk=24)
    protected int getPackageUidAsUser(String packageName, int userId) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation(minSdk=24)
    protected int getPackageUidAsUser(String packageName, int flags, int userId) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation
    protected PermissionGroupInfo getPermissionGroupInfo(String name, int flags) throws PackageManager.NameNotFoundException {
        if (permissionGroups.containsKey(name)) {
            return new PermissionGroupInfo((PermissionGroupInfo)permissionGroups.get(name));
        }
        throw new PackageManager.NameNotFoundException(name);
    }

    @Implementation
    protected List<PermissionGroupInfo> getAllPermissionGroups(int flags) {
        ArrayList<PermissionGroupInfo> allPermissionGroups = new ArrayList<PermissionGroupInfo>();
        for (PermissionGroupInfo permissionGroupInfo : permissionGroups.values()) {
            allPermissionGroups.add(new PermissionGroupInfo(permissionGroupInfo));
        }
        return allPermissionGroups;
    }

    @Implementation
    protected ApplicationInfo getApplicationInfo(String packageName, int flags) throws PackageManager.NameNotFoundException {
        PackageInfo packageInfo = this.getPackageInfo(packageName, flags);
        if (packageInfo.applicationInfo == null) {
            throw new PackageManager.NameNotFoundException("Package found but without application info");
        }
        return packageInfo.applicationInfo;
    }

    private void applyFlagsToApplicationInfo(ApplicationInfo appInfo, int flags) throws PackageManager.NameNotFoundException {
        if (appInfo == null) {
            return;
        }
        String packageName = appInfo.packageName;
        Integer stateOverride = (Integer)applicationEnabledSettingMap.get(packageName);
        if (stateOverride == null) {
            stateOverride = 0;
        }
        boolean bl = appInfo.enabled = appInfo.enabled && stateOverride == 0 || stateOverride == 1;
        if (deletedPackages.contains(packageName)) {
            appInfo.flags &= 0xFF7FFFFF;
        }
        if ((flags & 0x20000) != 0 && Build.VERSION.SDK_INT >= 23) {
            return;
        }
        if ((flags & 0x2000) == 0 && (appInfo.flags & 0x800000) == 0) {
            String string = String.valueOf(packageName);
            throw new PackageManager.NameNotFoundException(string.length() != 0 ? "Package not installed: ".concat(string) : new String("Package not installed: "));
        }
        if ((flags & 0x2000) == 0 && hiddenPackages.contains(packageName)) {
            String string = String.valueOf(packageName);
            throw new PackageManager.NameNotFoundException(string.length() != 0 ? "Package hidden: ".concat(string) : new String("Package hidden: "));
        }
    }

    @Implementation
    protected String[] getSystemSharedLibraryNames() {
        return systemSharedLibraryNames.toArray(new String[systemSharedLibraryNames.size()]);
    }

    @Implementation(minSdk=24)
    protected String getServicesSystemSharedLibraryPackageName() {
        return null;
    }

    @Implementation(minSdk=24)
    protected String getSharedSystemSharedLibraryPackageName() {
        return "";
    }

    @Implementation(minSdk=24)
    protected boolean hasSystemFeature(String name, int version) {
        return false;
    }

    @Implementation(minSdk=23)
    protected boolean isPermissionRevokedByPolicy(String permName, String pkgName) {
        return false;
    }

    @Implementation
    protected boolean addPermission(PermissionInfo info) {
        return false;
    }

    @Implementation
    protected boolean addPermissionAsync(PermissionInfo info) {
        return false;
    }

    @Implementation
    protected void removePermission(String name) {
    }

    @Implementation(minSdk=23)
    protected void grantRuntimePermission(String packageName, String permissionName, UserHandle user) {
        if (!packageInfos.containsKey(packageName)) {
            String string = String.valueOf(packageName);
            throw new SecurityException(string.length() != 0 ? "Package not found: ".concat(string) : new String("Package not found: "));
        }
        PackageInfo packageInfo = (PackageInfo)packageInfos.get(packageName);
        this.checkPermissionGrantStateInitialized(packageInfo);
        int permissionIndex = this.getPermissionIndex(packageInfo, permissionName);
        if (permissionIndex < 0) {
            throw new SecurityException(new StringBuilder(37 + String.valueOf(permissionName).length() + String.valueOf(packageName).length()).append("Permission ").append(permissionName).append(" not requested by package ").append(packageName).toString());
        }
        int n = permissionIndex;
        packageInfo.requestedPermissionsFlags[n] = packageInfo.requestedPermissionsFlags[n] | 2;
    }

    @Implementation(minSdk=23)
    protected void revokeRuntimePermission(String packageName, String permissionName, UserHandle user) {
        if (!packageInfos.containsKey(packageName)) {
            String string = String.valueOf(packageName);
            throw new SecurityException(string.length() != 0 ? "Package not found: ".concat(string) : new String("Package not found: "));
        }
        PackageInfo packageInfo = (PackageInfo)packageInfos.get(packageName);
        this.checkPermissionGrantStateInitialized(packageInfo);
        int permissionIndex = this.getPermissionIndex(packageInfo, permissionName);
        if (permissionIndex < 0) {
            throw new SecurityException(new StringBuilder(37 + String.valueOf(permissionName).length() + String.valueOf(packageName).length()).append("Permission ").append(permissionName).append(" not requested by package ").append(packageName).toString());
        }
        int n = permissionIndex;
        packageInfo.requestedPermissionsFlags[n] = packageInfo.requestedPermissionsFlags[n] & 0xFFFFFFFD;
    }

    private void checkPermissionGrantStateInitialized(PackageInfo packageInfo) {
        if (packageInfo.requestedPermissionsFlags == null) {
            throw new SecurityException("Permission grant state (PackageInfo.requestedPermissionFlags) is null. This operation requires this variable to be initialized.");
        }
    }

    private int getPermissionIndex(PackageInfo packageInfo, String permissionName) {
        if (packageInfo.requestedPermissions != null) {
            for (int i = 0; i < packageInfo.requestedPermissions.length; ++i) {
                if (!permissionName.equals(packageInfo.requestedPermissions[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Implementation(minSdk=23)
    protected int getPermissionFlags(String permissionName, String packageName, UserHandle user) {
        return 0;
    }

    @Implementation(minSdk=23)
    protected void updatePermissionFlags(String permissionName, String packageName, int flagMask, int flagValues, UserHandle user) {
    }

    @Implementation
    protected int getUidForSharedUser(String sharedUserName) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation(minSdk=24)
    protected List<PackageInfo> getInstalledPackagesAsUser(int flags, int userId) {
        return null;
    }

    @Implementation(minSdk=18)
    protected List<PackageInfo> getPackagesHoldingPermissions(String[] permissions, int flags) {
        ArrayList<PackageInfo> packageInfosWithPermissions = new ArrayList<PackageInfo>();
        block0: for (PackageInfo packageInfo : packageInfos.values()) {
            for (String permission2 : permissions) {
                int permissionIndex = this.getPermissionIndex(packageInfo, permission2);
                if (permissionIndex < 0) continue;
                packageInfosWithPermissions.add(packageInfo);
                continue block0;
            }
        }
        return packageInfosWithPermissions;
    }

    @Implementation(minSdk=17)
    protected ResolveInfo resolveActivityAsUser(Intent intent, int flags, int userId) {
        return this.resolveActivity(intent, flags);
    }

    @Implementation
    protected List<ResolveInfo> queryIntentActivityOptions(ComponentName caller, Intent[] specifics, Intent intent, int flags) {
        return null;
    }

    @Implementation(minSdk=24)
    protected List<ResolveInfo> queryBroadcastReceiversAsUser(Intent intent, int flags, int userId) {
        return null;
    }

    @Implementation
    protected List<ProviderInfo> queryContentProviders(String processName, int uid, int flags) {
        return null;
    }

    @Implementation
    protected InstrumentationInfo getInstrumentationInfo(ComponentName className, int flags) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation
    protected List<InstrumentationInfo> queryInstrumentation(String targetPackage, int flags) {
        return null;
    }

    @Implementation
    protected Drawable getDrawable(String packageName, int resId, ApplicationInfo appInfo) {
        Drawable result = (Drawable)drawables.get(new Pair((Object)packageName, (Object)resId));
        if (result != null) {
            return result;
        }
        return ((ApplicationPackageManager)Shadow.directlyOn((Object)this.realObject, ApplicationPackageManager.class)).getDrawable(packageName, resId, appInfo);
    }

    @Implementation
    protected Drawable getActivityIcon(ComponentName activityName) throws PackageManager.NameNotFoundException {
        Drawable result = (Drawable)drawableList.get(activityName);
        if (result != null) {
            return result;
        }
        return ((ApplicationPackageManager)Shadow.directlyOn((Object)this.realObject, ApplicationPackageManager.class)).getActivityIcon(activityName);
    }

    @Implementation
    protected Drawable getDefaultActivityIcon() {
        return Resources.getSystem().getDrawable(17301651);
    }

    @Implementation
    protected Resources getResourcesForActivity(ComponentName activityName) throws PackageManager.NameNotFoundException {
        return this.getResourcesForApplication(activityName.getPackageName());
    }

    @Implementation
    protected Resources getResourcesForApplication(String appPackageName) throws PackageManager.NameNotFoundException {
        if (this.getContext().getPackageName().equals(appPackageName)) {
            return this.getContext().getResources();
        }
        if (packageInfos.containsKey(appPackageName)) {
            Resources appResources = (Resources)resources.get(appPackageName);
            if (appResources == null) {
                appResources = new Resources(new AssetManager(), null, null);
                resources.put(appPackageName, appResources);
            }
            return appResources;
        }
        throw new PackageManager.NameNotFoundException(appPackageName);
    }

    @Implementation(minSdk=17)
    protected Resources getResourcesForApplicationAsUser(String appPackageName, int userId) throws PackageManager.NameNotFoundException {
        return null;
    }

    @Implementation(minSdk=23)
    protected void addOnPermissionsChangeListener(Object listener) {
    }

    @Implementation(minSdk=23)
    protected void removeOnPermissionsChangeListener(Object listener) {
    }

    @Implementation(maxSdk=27)
    protected void installPackage(Object packageURI, Object observer, Object flags, Object installerPackageName) {
    }

    @Implementation(minSdk=17)
    protected int installExistingPackage(String packageName) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation(minSdk=24)
    protected int installExistingPackageAsUser(String packageName, int userId) throws PackageManager.NameNotFoundException {
        return 0;
    }

    @Implementation(minSdk=23)
    protected void verifyIntentFilter(int id2, int verificationCode, List<String> failedDomains) {
    }

    @Implementation(minSdk=24)
    protected int getIntentVerificationStatusAsUser(String packageName, int userId) {
        return 0;
    }

    @Implementation(minSdk=24)
    protected boolean updateIntentVerificationStatusAsUser(String packageName, int status, int userId) {
        return false;
    }

    @Implementation(minSdk=23)
    protected List<IntentFilterVerificationInfo> getIntentFilterVerifications(String packageName) {
        return null;
    }

    @Implementation(minSdk=23)
    protected List<IntentFilter> getAllIntentFilters(String packageName) {
        return null;
    }

    @Implementation(minSdk=24)
    protected String getDefaultBrowserPackageNameAsUser(int userId) {
        return null;
    }

    @Implementation(minSdk=24)
    protected boolean setDefaultBrowserPackageNameAsUser(String packageName, int userId) {
        return false;
    }

    @Implementation(minSdk=23)
    protected int getMoveStatus(int moveId) {
        return 0;
    }

    @Implementation(minSdk=23)
    protected void registerMoveCallback(Object callback, Object handler) {
    }

    @Implementation(minSdk=23)
    protected void unregisterMoveCallback(Object callback) {
    }

    @Implementation(minSdk=23)
    protected Object movePackage(Object packageName, Object vol) {
        return 0;
    }

    @Implementation(minSdk=23)
    protected Object getPackageCurrentVolume(Object app) {
        return null;
    }

    @Implementation(minSdk=23)
    protected List<VolumeInfo> getPackageCandidateVolumes(ApplicationInfo app) {
        return null;
    }

    @Implementation(minSdk=23)
    protected Object movePrimaryStorage(Object vol) {
        return 0;
    }

    @Implementation(minSdk=23)
    protected Object getPrimaryStorageCurrentVolume() {
        return null;
    }

    @Implementation(minSdk=23)
    protected List<VolumeInfo> getPrimaryStorageCandidateVolumes() {
        return null;
    }

    @Implementation(minSdk=24)
    protected void deletePackageAsUser(String packageName, IPackageDeleteObserver observer, int flags, int userId) {
    }

    @Implementation
    protected void clearApplicationUserData(String packageName, IPackageDataObserver observer) {
    }

    @Implementation
    protected void deleteApplicationCacheFiles(String packageName, IPackageDataObserver observer) {
    }

    @Implementation(minSdk=24)
    protected void deleteApplicationCacheFilesAsUser(String packageName, int userId, IPackageDataObserver observer) {
    }

    @Implementation(minSdk=23)
    protected void freeStorage(String volumeUuid, long freeStorageSize, IntentSender pi) {
    }

    @Implementation(minSdk=24, maxSdk=27)
    protected String[] setPackagesSuspendedAsUser(String[] packageNames, boolean suspended, int userId) {
        return null;
    }

    @Implementation(minSdk=24)
    protected boolean isPackageSuspendedForUser(String packageName, int userId) {
        return false;
    }

    @Implementation
    protected void addPackageToPreferred(String packageName) {
    }

    @Implementation
    protected void removePackageFromPreferred(String packageName) {
    }

    @Implementation
    protected List<PackageInfo> getPreferredPackages(int flags) {
        return null;
    }

    @Implementation
    public void addPreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        ShadowApplicationPackageManager.addPreferredActivityInternal(filter, activity, preferredActivities);
    }

    @Implementation
    protected void replacePreferredActivity(IntentFilter filter, int match, ComponentName[] set, ComponentName activity) {
        this.addPreferredActivity(filter, match, set, activity);
    }

    @Implementation
    public int getPreferredActivities(List<IntentFilter> outFilters, List<ComponentName> outActivities, String packageName) {
        return ShadowApplicationPackageManager.getPreferredActivitiesInternal(outFilters, outActivities, packageName, preferredActivities);
    }

    @Implementation
    protected void clearPackagePreferredActivities(String packageName) {
        ShadowApplicationPackageManager.clearPackagePreferredActivitiesInternal(packageName, preferredActivities);
    }

    @Implementation(minSdk=19)
    protected ComponentName getHomeActivities(List<ResolveInfo> outActivities) {
        return null;
    }

    @Implementation(minSdk=24)
    protected void flushPackageRestrictionsAsUser(int userId) {
    }

    @Implementation(minSdk=21)
    protected boolean setApplicationHiddenSettingAsUser(String packageName, boolean hidden, UserHandle user) {
        if (!packageInfos.containsKey(packageName)) {
            return false;
        }
        if (hidden) {
            hiddenPackages.add(packageName);
        } else {
            hiddenPackages.remove(packageName);
        }
        return true;
    }

    @Implementation(minSdk=21)
    protected boolean getApplicationHiddenSettingAsUser(String packageName, UserHandle user) {
        if (!packageInfos.containsKey(packageName)) {
            return true;
        }
        return hiddenPackages.contains(packageName);
    }

    @Implementation(minSdk=21)
    protected Object getKeySetByAlias(String packageName, String alias) {
        return null;
    }

    @Implementation(minSdk=21)
    protected Object getSigningKeySet(String packageName) {
        return null;
    }

    @Implementation(minSdk=21)
    protected boolean isSignedBy(String packageName, Object ks) {
        return false;
    }

    @Implementation(minSdk=21)
    protected boolean isSignedByExactly(String packageName, Object ks) {
        return false;
    }

    @Implementation
    protected VerifierDeviceIdentity getVerifierDeviceIdentity() {
        return null;
    }

    @Implementation(minSdk=22)
    protected boolean isUpgrade() {
        return false;
    }

    @Implementation(minSdk=21)
    protected boolean isPackageAvailable(String packageName) {
        return false;
    }

    @Implementation(minSdk=21)
    protected void addCrossProfileIntentFilter(IntentFilter filter, int sourceUserId, int targetUserId, int flags) {
    }

    @Implementation(minSdk=21)
    protected void clearCrossProfileIntentFilters(int sourceUserId) {
    }

    @Implementation(minSdk=22)
    protected Drawable loadUnbadgedItemIcon(PackageItemInfo itemInfo, ApplicationInfo appInfo) {
        Drawable result = (Drawable)unbadgedApplicationIcons.get(itemInfo.packageName);
        if (result != null) {
            return result;
        }
        return ((ApplicationPackageManager)Shadow.directlyOn((Object)this.realObject, ApplicationPackageManager.class)).loadUnbadgedItemIcon(itemInfo, appInfo);
    }

    @Implementation(minSdk=21)
    protected Drawable getUserBadgedIcon(Drawable icon, UserHandle user) {
        return icon;
    }

    @Implementation(minSdk=26)
    protected boolean canRequestPackageInstalls() {
        return canRequestPackageInstalls;
    }

    @Implementation(minSdk=26)
    protected Object getChangedPackages(int sequenceNumber) {
        if (sequenceNumber < 0 || sequenceNumberChangedPackagesMap.get((Object)sequenceNumber).isEmpty()) {
            return null;
        }
        return new ChangedPackages(sequenceNumber + 1, new ArrayList(sequenceNumberChangedPackagesMap.get((Object)sequenceNumber)));
    }

    @Implementation(minSdk=28)
    public String getSystemTextClassifierPackageName() {
        return "";
    }

    @Implementation(minSdk=28)
    @HiddenApi
    protected String[] setPackagesSuspended(String[] packageNames, boolean suspended, PersistableBundle appExtras, PersistableBundle launcherExtras, String dialogMessage) {
        return this.setPackagesSuspended(packageNames, suspended, appExtras, launcherExtras, dialogMessage, null);
    }

    @Implementation(minSdk=29)
    @HiddenApi
    protected Object setPackagesSuspended(Object packageNames, Object suspended, Object appExtras, Object launcherExtras, Object dialogInfo) {
        return this.setPackagesSuspended((String[])packageNames, (Boolean)suspended, (PersistableBundle)appExtras, (PersistableBundle)launcherExtras, null, dialogInfo);
    }

    private String[] setPackagesSuspended(String[] packageNames, boolean suspended, PersistableBundle appExtras, PersistableBundle launcherExtras, String dialogMessage, Object dialogInfo) {
        if (this.hasProfileOwnerOrDeviceOwnerOnCurrentUser()) {
            throw new UnsupportedOperationException();
        }
        ArrayList<String> unupdatedPackages = new ArrayList<String>();
        for (String packageName : packageNames) {
            if (!this.canSuspendPackage(packageName)) {
                unupdatedPackages.add(packageName);
                continue;
            }
            ShadowPackageManager.PackageSetting setting = (ShadowPackageManager.PackageSetting)packageSettings.get(packageName);
            if (setting == null) {
                unupdatedPackages.add(packageName);
                continue;
            }
            setting.setSuspended(suspended, dialogMessage, dialogInfo, appExtras, launcherExtras);
        }
        return unupdatedPackages.toArray(new String[0]);
    }

    private boolean hasProfileOwnerOrDeviceOwnerOnCurrentUser() {
        DevicePolicyManager devicePolicyManager = (DevicePolicyManager)this.getContext().getSystemService("device_policy");
        return devicePolicyManager.getProfileOwner() != null || UserHandle.of((int)UserHandle.myUserId()).isSystem() && devicePolicyManager.getDeviceOwner() != null;
    }

    private boolean canSuspendPackage(String packageName) {
        return !packageName.equals(this.getContext().getPackageName()) && !this.isPackageDeviceAdmin(packageName) && !this.isPackageActiveLauncher(packageName) && !this.isPackageRequiredInstaller(packageName) && !this.isPackageRequiredUninstaller(packageName) && !this.isPackageRequiredVerifier(packageName) && !this.isPackageDefaultDialer(packageName) && !packageName.equals(PLATFORM_PACKAGE_NAME);
    }

    private boolean isPackageDeviceAdmin(String packageName) {
        DevicePolicyManager devicePolicyManager = (DevicePolicyManager)this.getContext().getSystemService("device_policy");
        return packageName.equals(devicePolicyManager.getDeviceOwner());
    }

    private boolean isPackageActiveLauncher(String packageName) {
        Intent intent = new Intent("android.intent.action.MAIN").addCategory("android.intent.category.HOME");
        ResolveInfo info = this.resolveActivity(intent, 65536);
        return info != null && packageName.equals(info.activityInfo.packageName);
    }

    private boolean isPackageRequiredInstaller(String packageName) {
        Intent intent = new Intent("android.intent.action.INSTALL_PACKAGE");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setDataAndType(Uri.fromFile((File)new File("foo.apk")), PACKAGE_MIME_TYPE);
        ResolveInfo info = this.resolveActivity(intent, 0x1C0000);
        return info != null && packageName.equals(info.activityInfo.packageName);
    }

    private boolean isPackageRequiredUninstaller(String packageName) {
        Intent intent = new Intent("android.intent.action.UNINSTALL_PACKAGE");
        intent.addCategory("android.intent.category.DEFAULT");
        intent.setData(Uri.fromParts((String)PACKAGE_SCHEME, (String)"foo.bar", null));
        ResolveInfo info = this.resolveActivity(intent, 0x1C0000);
        return info != null && packageName.equals(info.activityInfo.packageName);
    }

    private boolean isPackageRequiredVerifier(String packageName) {
        Intent intent = new Intent("android.intent.action.PACKAGE_NEEDS_VERIFICATION");
        List<ResolveInfo> infos = this.queryBroadcastReceivers(intent, 0x1C0000);
        if (infos != null) {
            for (ResolveInfo info : infos) {
                if (!packageName.equals(info.activityInfo.packageName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isPackageDefaultDialer(String packageName) {
        TelecomManager telecomManager = (TelecomManager)this.getContext().getSystemService("telecom");
        return packageName.equals(telecomManager.getDefaultDialerPackage());
    }

    @HiddenApi
    @Implementation(minSdk=29)
    protected String[] getUnsuspendablePackages(String[] packageNames) {
        Preconditions.checkNotNull((Object)packageNames, (Object)"packageNames cannot be null");
        if (this.getContext().checkSelfPermission("android.permission.SUSPEND_APPS") != 0) {
            throw new SecurityException("Current process does not have android.permission.SUSPEND_APPS");
        }
        ArrayList<String> unsuspendablePackages = new ArrayList<String>();
        for (String packageName : packageNames) {
            if (this.canSuspendPackage(packageName)) continue;
            unsuspendablePackages.add(packageName);
        }
        return unsuspendablePackages.toArray(new String[0]);
    }

    @HiddenApi
    @Implementation(minSdk=28)
    protected boolean isPackageSuspended(String packageName) throws PackageManager.NameNotFoundException {
        ShadowPackageManager.PackageSetting setting = (ShadowPackageManager.PackageSetting)packageSettings.get(packageName);
        if (setting == null) {
            throw new PackageManager.NameNotFoundException(packageName);
        }
        return setting.isSuspended();
    }

    @Implementation(minSdk=26)
    protected boolean isInstantApp(String packageName) {
        PackageInfo pi = (PackageInfo)packageInfos.get(packageName);
        if (pi == null) {
            return false;
        }
        ApplicationInfo ai = pi.applicationInfo;
        if (ai == null) {
            return false;
        }
        return ai.isInstantApp();
    }

    @HiddenApi
    @Implementation(minSdk=29)
    protected String[] setDistractingPackageRestrictions(String[] packages, int restrictionFlags) {
        for (String pkg : packages) {
            distractingPackageRestrictions.put(pkg, restrictionFlags);
        }
        return new String[0];
    }

    private Context getContext() {
        return ((ReflectorApplicationPackageManager)Reflector.reflector(ReflectorApplicationPackageManager.class, (Object)this.realObject)).getContext();
    }

    @ForType(value=ApplicationPackageManager.class)
    private static interface ReflectorApplicationPackageManager {
        @Accessor(value="mContext")
        public Context getContext();
    }
}

