/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.system.ErrnoException;
import android.system.StructStat;
import java.io.File;
import java.io.FileDescriptor;
import java.lang.reflect.Field;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadows.OsConstantsValues;
import org.robolectric.util.ReflectionHelpers;

@Implements(className="libcore.io.Posix", maxSdk=25, isInAndroidSdk=false)
public class ShadowPosix {
    @Implementation
    public static void mkdir(String path, int mode) throws ErrnoException {
        new File(path).mkdirs();
    }

    @Implementation
    public static Object stat(String path) throws ErrnoException {
        int mode = OsConstantsValues.getMode(path);
        if (RuntimeEnvironment.getApiLevel() >= 21) {
            return new StructStat(1L, 0L, mode, 0L, 0, 0, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        }
        Object structStat = ReflectionHelpers.newInstance((Class)ReflectionHelpers.loadClass((ClassLoader)ShadowPosix.class.getClassLoader(), (String)"libcore.io.StructStat"));
        ShadowPosix.setMode(mode, structStat);
        return structStat;
    }

    @Implementation
    protected static Object lstat(String path) throws ErrnoException {
        return ShadowPosix.stat(path);
    }

    @Implementation
    protected static Object fstat(FileDescriptor fd) throws ErrnoException {
        return ShadowPosix.stat(null);
    }

    private static void setMode(int mode, Object structStat) {
        try {
            Field f = structStat.getClass().getDeclaredField("st_mode");
            f.setAccessible(true);
            f.setInt(structStat, mode);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

