/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.IntentSender;
import android.content.pm.PackageInstaller;
import android.os.Handler;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.shadow.api.Shadow;

@Implements(value=PackageInstaller.class, minSdk=21)
@SuppressLint(value={"NewApi"})
public class ShadowPackageInstaller {
    private int nextSessionId;
    private Map<Integer, PackageInstaller.SessionInfo> sessionInfos = new HashMap<Integer, PackageInstaller.SessionInfo>();
    private Map<Integer, PackageInstaller.Session> sessions = new HashMap<Integer, PackageInstaller.Session>();
    private Set<CallbackInfo> callbackInfos = new HashSet<CallbackInfo>();

    @Implementation
    protected List<PackageInstaller.SessionInfo> getAllSessions() {
        return ImmutableList.copyOf(this.sessionInfos.values());
    }

    @Implementation
    protected void registerSessionCallback(PackageInstaller.SessionCallback callback, Handler handler) {
        CallbackInfo callbackInfo = new CallbackInfo();
        callbackInfo.callback = callback;
        callbackInfo.handler = handler;
        this.callbackInfos.add(callbackInfo);
    }

    @Implementation
    protected PackageInstaller.SessionInfo getSessionInfo(int sessionId) {
        return this.sessionInfos.get(sessionId);
    }

    @Implementation
    protected int createSession(PackageInstaller.SessionParams params) throws IOException {
        final PackageInstaller.SessionInfo sessionInfo = new PackageInstaller.SessionInfo();
        sessionInfo.sessionId = this.nextSessionId++;
        sessionInfo.active = true;
        sessionInfo.appPackageName = params.appPackageName;
        this.sessionInfos.put(sessionInfo.getSessionId(), sessionInfo);
        for (final CallbackInfo callbackInfo : this.callbackInfos) {
            callbackInfo.handler.post(new Runnable(){

                @Override
                public void run() {
                    callbackInfo.callback.onCreated(sessionInfo.sessionId);
                }
            });
        }
        return sessionInfo.sessionId;
    }

    @Implementation
    protected void abandonSession(final int sessionId) {
        this.sessionInfos.remove(sessionId);
        this.sessions.remove(sessionId);
        for (final CallbackInfo callbackInfo : this.callbackInfos) {
            callbackInfo.handler.post(new Runnable(){

                @Override
                public void run() {
                    callbackInfo.callback.onFinished(sessionId, false);
                }
            });
        }
    }

    @Implementation
    protected PackageInstaller.Session openSession(int sessionId) throws IOException {
        if (!this.sessionInfos.containsKey(sessionId)) {
            throw new SecurityException("Invalid session Id: " + sessionId);
        }
        PackageInstaller.Session session = new PackageInstaller.Session(null);
        ShadowSession shadowSession = (ShadowSession)Shadow.extract((Object)session);
        shadowSession.setShadowPackageInstaller(sessionId, this);
        this.sessions.put(sessionId, session);
        return session;
    }

    public void setSessionProgress(final int sessionId, final float progress) {
        for (final CallbackInfo callbackInfo : this.callbackInfos) {
            callbackInfo.handler.post(new Runnable(){

                @Override
                public void run() {
                    callbackInfo.callback.onProgressChanged(sessionId, progress);
                }
            });
        }
    }

    @Deprecated
    public void setSessionSucceeds(int sessionId) {
        this.setSessionFinishes(sessionId, true);
    }

    public void setSessionFails(int sessionId) {
        this.setSessionFinishes(sessionId, false);
    }

    private void setSessionFinishes(final int sessionId, final boolean success) {
        for (final CallbackInfo callbackInfo : this.callbackInfos) {
            callbackInfo.handler.post(new Runnable(){

                @Override
                public void run() {
                    callbackInfo.callback.onFinished(sessionId, success);
                }
            });
        }
        PackageInstaller.Session session = this.sessions.get(sessionId);
        ShadowSession shadowSession = (ShadowSession)Shadow.extract((Object)session);
        if (success) {
            try {
                shadowSession.statusReceiver.sendIntent((Context)RuntimeEnvironment.application, 0, null, null, null, null);
            }
            catch (IntentSender.SendIntentException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Implements(value=PackageInstaller.Session.class, minSdk=21)
    public static class ShadowSession {
        private OutputStream outputStream;
        private boolean outputStreamOpen;
        private IntentSender statusReceiver;
        private int sessionId;
        private ShadowPackageInstaller shadowPackageInstaller;

        @Implementation(maxSdk=20)
        protected void __constructor__() {
        }

        @Implementation
        protected OutputStream openWrite(String name, long offsetBytes, long lengthBytes) throws IOException {
            this.outputStream = new OutputStream(){

                @Override
                public void write(int aByte) throws IOException {
                }

                @Override
                public void close() throws IOException {
                    outputStreamOpen = false;
                }
            };
            this.outputStreamOpen = true;
            return this.outputStream;
        }

        @Implementation
        protected void fsync(OutputStream out) throws IOException {
        }

        @Implementation
        protected void commit(IntentSender statusReceiver) {
            this.statusReceiver = statusReceiver;
            if (this.outputStreamOpen) {
                throw new SecurityException("OutputStream still open");
            }
            this.shadowPackageInstaller.setSessionSucceeds(this.sessionId);
        }

        @Implementation
        protected void close() {
        }

        @Implementation
        protected void abandon() {
            this.shadowPackageInstaller.abandonSession(this.sessionId);
        }

        private void setShadowPackageInstaller(int sessionId, ShadowPackageInstaller shadowPackageInstaller) {
            this.sessionId = sessionId;
            this.shadowPackageInstaller = shadowPackageInstaller;
        }
    }

    private static class CallbackInfo {
        PackageInstaller.SessionCallback callback;
        Handler handler;

        private CallbackInfo() {
        }
    }
}

