/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.res.Configuration;
import android.graphics.Point;
import android.util.DisplayMetrics;
import android.view.Display;
import android.view.WindowManager;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.android.internal.DisplayConfig;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.ShadowDisplayManager;
import org.robolectric.util.Consumer;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=Display.class)
public class ShadowDisplay {
    @RealObject
    Display realObject;
    private Float refreshRate;
    private String name;
    private Integer displayId;
    private Integer width;
    private Integer height;
    private Integer realWidth;
    private Integer realHeight;
    private Integer densityDpi;
    private Float xdpi;
    private Float ydpi;
    private Float scaledDensity;
    private Integer rotation;
    private Integer pixelFormat;

    public static Display getDefaultDisplay() {
        WindowManager windowManager = (WindowManager)RuntimeEnvironment.application.getSystemService("window");
        return windowManager.getDefaultDisplay();
    }

    @Deprecated
    @Implementation
    protected void getMetrics(DisplayMetrics outMetrics) {
        if (this.isJB()) {
            outMetrics.density = (float)this.densityDpi.intValue() * 0.00625f;
            outMetrics.densityDpi = this.densityDpi;
            outMetrics.scaledDensity = this.scaledDensity.floatValue();
            outMetrics.widthPixels = this.width;
            outMetrics.heightPixels = this.height;
            outMetrics.xdpi = this.xdpi.floatValue();
            outMetrics.ydpi = this.ydpi.floatValue();
        } else {
            ((Display)Shadow.directlyOn((Object)this.realObject, Display.class)).getMetrics(outMetrics);
            if (this.scaledDensity != null) {
                outMetrics.scaledDensity = this.scaledDensity.floatValue();
            }
        }
    }

    @Deprecated
    @Implementation
    protected void getRealMetrics(DisplayMetrics outMetrics) {
        if (this.isJB()) {
            this.getMetrics(outMetrics);
            outMetrics.widthPixels = this.realWidth;
            outMetrics.heightPixels = this.realHeight;
        } else {
            ((Display)Shadow.directlyOn((Object)this.realObject, Display.class)).getRealMetrics(outMetrics);
            if (this.scaledDensity != null) {
                outMetrics.scaledDensity = this.scaledDensity.floatValue();
            }
        }
    }

    @Deprecated
    @Implementation
    protected int getDisplayId() {
        return this.displayId == null ? ((Display)Shadow.directlyOn((Object)this.realObject, Display.class)).getDisplayId() : this.displayId.intValue();
    }

    @Deprecated
    @Implementation
    protected float getRefreshRate() {
        if (this.refreshRate != null) {
            return this.refreshRate.floatValue();
        }
        float realRefreshRate = ((Display)Shadow.directlyOn((Object)this.realObject, Display.class)).getRefreshRate();
        if ((double)realRefreshRate < 0.1) {
            realRefreshRate = 60.0f;
        }
        return realRefreshRate;
    }

    @Deprecated
    @Implementation
    protected int getPixelFormat() {
        return this.pixelFormat == null ? ((Display)Shadow.directlyOn((Object)this.realObject, Display.class)).getPixelFormat() : this.pixelFormat.intValue();
    }

    @Implementation(maxSdk=16)
    protected void getSizeInternal(Point outSize, boolean doCompat) {
        outSize.x = this.width;
        outSize.y = this.height;
    }

    @Implementation(maxSdk=16)
    protected void getCurrentSizeRange(Point outSmallestSize, Point outLargestSize) {
        int minimum = Math.min(this.width, this.height);
        int maximum = Math.max(this.width, this.height);
        outSmallestSize.set(minimum, minimum);
        outLargestSize.set(maximum, maximum);
    }

    @Implementation(maxSdk=16)
    protected void getRealSize(Point outSize) {
        outSize.set(this.realWidth.intValue(), this.realHeight.intValue());
    }

    public void setDensity(float density) {
        this.setDensityDpi((int)(density * 160.0f));
    }

    public void setDensityDpi(int densityDpi) {
        if (this.isJB()) {
            this.densityDpi = densityDpi;
        } else {
            ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
                di.logicalDensityDpi = densityDpi;
            }));
        }
    }

    public void setXdpi(float xdpi) {
        if (this.isJB()) {
            this.xdpi = Float.valueOf(xdpi);
        } else {
            ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
                di.physicalXDpi = xdpi;
            }));
        }
    }

    public void setYdpi(float ydpi) {
        if (this.isJB()) {
            this.ydpi = Float.valueOf(ydpi);
        } else {
            ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
                di.physicalYDpi = ydpi;
            }));
        }
    }

    @Deprecated
    public void setScaledDensity(float scaledDensity) {
        this.scaledDensity = Float.valueOf(scaledDensity);
    }

    @Deprecated
    public void setDisplayId(int displayId) {
        this.displayId = displayId;
    }

    public void setName(String name) {
        if (this.isJB()) {
            this.name = name;
        } else {
            ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
                di.name = name;
            }));
        }
    }

    public void setFlags(int flags) {
        ((_Display_)Reflector.reflector(_Display_.class, (Object)this.realObject)).setFlags(flags);
        if (!this.isJB()) {
            ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
                di.flags = flags;
            }));
        }
    }

    public void setWidth(int width) {
        if (this.isJB()) {
            this.width = width;
        } else {
            ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
                di.appWidth = width;
            }));
        }
    }

    public void setHeight(int height) {
        if (this.isJB()) {
            this.height = height;
        } else {
            ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
                di.appHeight = height;
            }));
        }
    }

    public void setRealWidth(int width) {
        if (this.isJB()) {
            this.realWidth = width;
        } else {
            ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
                di.logicalWidth = width;
            }));
        }
    }

    public void setRealHeight(int height) {
        if (this.isJB()) {
            this.realHeight = height;
        } else {
            ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
                di.logicalHeight = height;
            }));
        }
    }

    public void setRefreshRate(float refreshRate) {
        this.refreshRate = Float.valueOf(refreshRate);
    }

    public void setRotation(int rotation) {
        if (this.isJB()) {
            this.rotation = rotation;
        } else {
            ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
                di.rotation = rotation;
            }));
        }
    }

    @Deprecated
    public void setPixelFormat(int pixelFormat) {
        this.pixelFormat = pixelFormat;
    }

    public void setState(int state) {
        if (!this.isJB()) {
            ShadowDisplayManager.changeDisplay(this.realObject.getDisplayId(), (Consumer<DisplayConfig>)((Consumer)di -> {
                di.state = state;
            }));
        }
    }

    private boolean isJB() {
        return RuntimeEnvironment.getApiLevel() == 16;
    }

    void configureForJBOnly(Configuration configuration, DisplayMetrics displayMetrics) {
        int widthPx = (int)((float)configuration.screenWidthDp * displayMetrics.density);
        int heightPx = (int)((float)configuration.screenHeightDp * displayMetrics.density);
        this.name = "Built-in screen";
        this.displayId = 0;
        this.width = widthPx;
        this.height = heightPx;
        this.realWidth = widthPx;
        this.realHeight = heightPx;
        this.densityDpi = displayMetrics.densityDpi;
        this.xdpi = Float.valueOf(displayMetrics.densityDpi);
        this.ydpi = Float.valueOf(displayMetrics.densityDpi);
        this.scaledDensity = Float.valueOf((float)displayMetrics.densityDpi * 0.00625f);
        this.rotation = configuration.orientation == 1 ? 0 : 1;
    }

    @ForType(value=Display.class)
    static interface _Display_ {
        @Accessor(value="mFlags")
        public void setFlags(int var1);
    }
}

