/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.accessibilityservice.AccessibilityServiceInfo;
import android.content.Context;
import android.content.pm.ServiceInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.Log;
import android.view.accessibility.AccessibilityManager;
import android.view.accessibility.IAccessibilityManager;
import java.util.List;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.HiddenApi;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.annotation.Resetter;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.util.ReflectionHelpers;

@Implements(value=AccessibilityManager.class)
public class ShadowAccessibilityManager {
    private static AccessibilityManager sInstance;
    private static final Object sInstanceSync;
    @RealObject
    AccessibilityManager realAccessibilityManager;
    private boolean enabled;
    private List<AccessibilityServiceInfo> installedAccessibilityServiceList;
    private List<AccessibilityServiceInfo> enabledAccessibilityServiceList;
    private List<ServiceInfo> accessibilityServiceList;
    private boolean touchExplorationEnabled;
    private static boolean isAccessibilityButtonSupported;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Resetter
    public static void reset() {
        Object object = sInstanceSync;
        synchronized (object) {
            sInstance = null;
        }
        isAccessibilityButtonSupported = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @HiddenApi
    @Implementation
    public static AccessibilityManager getInstance(Context context) throws Exception {
        Object object = sInstanceSync;
        synchronized (object) {
            if (sInstance == null) {
                sInstance = ShadowAccessibilityManager.createInstance(context);
            }
        }
        return sInstance;
    }

    private static AccessibilityManager createInstance(Context context) throws Exception {
        if (RuntimeEnvironment.getApiLevel() >= 19) {
            AccessibilityManager accessibilityManager = (AccessibilityManager)Shadow.newInstance(AccessibilityManager.class, (Class[])new Class[]{Context.class, IAccessibilityManager.class, Integer.TYPE}, (Object[])new Object[]{context, ReflectionHelpers.createNullProxy(IAccessibilityManager.class), 0});
            ReflectionHelpers.setField((Object)accessibilityManager, (String)"mHandler", (Object)((Object)new MyHandler(context.getMainLooper(), accessibilityManager)));
            return accessibilityManager;
        }
        AccessibilityManager accessibilityManager = (AccessibilityManager)Shadow.newInstance(AccessibilityManager.class, (Class[])new Class[0], (Object[])new Object[0]);
        ReflectionHelpers.setField((Object)accessibilityManager, (String)"mHandler", (Object)((Object)new MyHandler(context.getMainLooper(), accessibilityManager)));
        return accessibilityManager;
    }

    @Implementation
    protected boolean addAccessibilityStateChangeListener(AccessibilityManager.AccessibilityStateChangeListener listener) {
        return true;
    }

    @Implementation(minSdk=26)
    protected void addAccessibilityStateChangeListener(AccessibilityManager.AccessibilityStateChangeListener listener, Handler handler) {
    }

    @Implementation
    protected boolean removeAccessibilityStateChangeListener(AccessibilityManager.AccessibilityStateChangeListener listener) {
        return true;
    }

    @Implementation
    protected List<ServiceInfo> getAccessibilityServiceList() {
        return this.accessibilityServiceList;
    }

    public void setAccessibilityServiceList(List<ServiceInfo> accessibilityServiceList) {
        this.accessibilityServiceList = accessibilityServiceList;
    }

    @Implementation
    protected List<AccessibilityServiceInfo> getEnabledAccessibilityServiceList(int feedbackTypeFlags) {
        return this.enabledAccessibilityServiceList;
    }

    public void setEnabledAccessibilityServiceList(List<AccessibilityServiceInfo> enabledAccessibilityServiceList) {
        this.enabledAccessibilityServiceList = enabledAccessibilityServiceList;
    }

    @Implementation
    protected List<AccessibilityServiceInfo> getInstalledAccessibilityServiceList() {
        return this.installedAccessibilityServiceList;
    }

    public void setInstalledAccessibilityServiceList(List<AccessibilityServiceInfo> installedAccessibilityServiceList) {
        this.installedAccessibilityServiceList = installedAccessibilityServiceList;
    }

    @Implementation
    protected boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
        ReflectionHelpers.setField((Object)this.realAccessibilityManager, (String)"mIsEnabled", (Object)enabled);
    }

    @Implementation
    protected boolean isTouchExplorationEnabled() {
        return this.touchExplorationEnabled;
    }

    public void setTouchExplorationEnabled(boolean touchExplorationEnabled) {
        this.touchExplorationEnabled = touchExplorationEnabled;
    }

    @Implementation(minSdk=27)
    protected static boolean isAccessibilityButtonSupported() {
        return isAccessibilityButtonSupported;
    }

    @HiddenApi
    @Implementation(minSdk=26)
    protected void performAccessibilityShortcut() {
        this.setEnabled(true);
        this.setTouchExplorationEnabled(true);
    }

    public static void setAccessibilityButtonSupported(boolean supported) {
        isAccessibilityButtonSupported = supported;
    }

    static {
        sInstanceSync = new Object();
        isAccessibilityButtonSupported = true;
    }

    static class MyHandler
    extends Handler {
        private static final int DO_SET_STATE = 10;
        private final AccessibilityManager accessibilityManager;

        MyHandler(Looper mainLooper, AccessibilityManager accessibilityManager) {
            super(mainLooper);
            this.accessibilityManager = accessibilityManager;
        }

        public void handleMessage(Message message) {
            switch (message.what) {
                case 10: {
                    ReflectionHelpers.callInstanceMethod((Object)this.accessibilityManager, (String)"setState", (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(Integer.TYPE, (Object)message.arg1)});
                    return;
                }
            }
            Log.w((String)"AccessibilityManager", (String)("Unknown message type: " + message.what));
        }
    }
}

