/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import android.content.Context;
import android.content.om.OverlayInfo;
import android.content.om.OverlayManager;
import android.os.UserHandle;
import com.android.internal.content.om.OverlayManagerImpl;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.robolectric.RuntimeEnvironment;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=OverlayManager.class, minSdk=34, isInAndroidSdk=false)
public final class ShadowOverlayManager {
    private final Map<String, OverlayInfo> overlaysByPackageName = new HashMap<String, OverlayInfo>();
    @RealObject
    private OverlayManager realOverlayManager;

    public void addOverlayInfo(OverlayInfo overlayInfo) {
        this.overlaysByPackageName.put(overlayInfo.packageName, overlayInfo);
    }

    public void removeOverlayInfo(String packageName) {
        this.overlaysByPackageName.remove(packageName);
    }

    @Implementation
    @Nullable
    protected OverlayInfo getOverlayInfo(@Nonnull String packageName, @Nonnull UserHandle userHandle) {
        return this.overlaysByPackageName.get(packageName);
    }

    @Implementation
    protected void setEnabled(@Nonnull String packageName, boolean enable, @Nonnull UserHandle user) {
        this.checkPermission();
        OverlayInfo overlay = this.overlaysByPackageName.get(packageName);
        if (overlay == null) {
            throw new IllegalStateException("setEnabled failed; overlay name " + packageName + " not found");
        }
        if (!overlay.isMutable) {
            throw new IllegalStateException("setEnabled failed; overlay name " + packageName + " is not mutable");
        }
        int state = enable ? 3 : 2;
        this.addOverlayInfo(new OverlayInfo(overlay, state));
    }

    private void checkPermission() {
        Context context = null;
        if (RuntimeEnvironment.getApiLevel() >= 36) {
            OverlayManagerImpl overlayManagerImpl = ((OverlayManagerReflector)Reflector.reflector(OverlayManagerReflector.class, (Object)this.realOverlayManager)).getOverlayManagerImpl();
            context = ((OverlayManagerImplReflector)Reflector.reflector(OverlayManagerImplReflector.class, (Object)overlayManagerImpl)).getContext();
        } else {
            context = ((OverlayManagerReflector)Reflector.reflector(OverlayManagerReflector.class, (Object)this.realOverlayManager)).getContext();
        }
        if (context.checkSelfPermission("android.permission.CHANGE_OVERLAY_PACKAGES") != 0) {
            throw new SecurityException("Missing required permission: android.permission.CHANGE_OVERLAY_PACKAGES");
        }
    }

    @ForType(value=OverlayManager.class)
    static interface OverlayManagerReflector {
        @Accessor(value="mContext")
        public Context getContext();

        @Accessor(value="mOverlayManagerImpl")
        public OverlayManagerImpl getOverlayManagerImpl();
    }

    @ForType(value=OverlayManagerImpl.class)
    static interface OverlayManagerImplReflector {
        @Accessor(value="mContext")
        public Context getContext();
    }
}

