/*
 * Decompiled with CFR 0.152.
 */
package org.robolectric.shadows;

import libcore.util.NativeAllocationRegistry;
import org.robolectric.annotation.Implementation;
import org.robolectric.annotation.Implements;
import org.robolectric.annotation.RealObject;
import org.robolectric.nativeruntime.NativeAllocationRegistryNatives;
import org.robolectric.shadow.api.Shadow;
import org.robolectric.shadows.GraphicsShadowPicker;
import org.robolectric.shadows.ShadowNoopNativeAllocationRegistry;
import org.robolectric.util.ReflectionHelpers;
import org.robolectric.util.reflector.Accessor;
import org.robolectric.util.reflector.Direct;
import org.robolectric.util.reflector.ForType;
import org.robolectric.util.reflector.Reflector;

@Implements(value=NativeAllocationRegistry.class, minSdk=26, isInAndroidSdk=false, shadowPicker=Picker.class, callNativeMethodsByDefault=true)
public class ShadowNativeAllocationRegistry {
    @RealObject
    protected NativeAllocationRegistry realNativeAllocationRegistry;

    @Implementation(minSdk=36)
    protected void __constructor__(ClassLoader classLoader, Class<?> clazz, long freeFunction, long size, boolean mallocAllocation) {
        ClassLoader loader = classLoader == null ? Thread.currentThread().getContextClassLoader() : classLoader;
        Shadow.invokeConstructor(NativeAllocationRegistry.class, (Object)this.realNativeAllocationRegistry, (ReflectionHelpers.ClassParameter[])new ReflectionHelpers.ClassParameter[]{ReflectionHelpers.ClassParameter.from(ClassLoader.class, (Object)loader), ReflectionHelpers.ClassParameter.from(Class.class, clazz), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)freeFunction), ReflectionHelpers.ClassParameter.from(Long.TYPE, (Object)size), ReflectionHelpers.ClassParameter.from(Boolean.TYPE, (Object)mallocAllocation)});
    }

    @Implementation
    protected Runnable registerNativeAllocation(Object referent, long nativePtr) {
        if (nativePtr != 0L && this.hasValidFreeFunction()) {
            return ((NativeAllocationRegistryReflector)Reflector.reflector(NativeAllocationRegistryReflector.class, (Object)this.realNativeAllocationRegistry)).registerNativeAllocation(referent, nativePtr);
        }
        return () -> {};
    }

    private boolean hasValidFreeFunction() {
        return ((NativeAllocationRegistryReflector)Reflector.reflector(NativeAllocationRegistryReflector.class, (Object)this.realNativeAllocationRegistry)).getFreeFunction() != 0L;
    }

    @Implementation(maxSdk=34)
    protected static void applyFreeFunction(long freeFunction, long nativePtr) {
        NativeAllocationRegistryNatives.applyFreeFunction((long)freeFunction, (long)nativePtr);
    }

    @ForType(value=NativeAllocationRegistry.class)
    static interface NativeAllocationRegistryReflector {
        @Direct
        public Runnable registerNativeAllocation(Object var1, long var2);

        @Accessor(value="freeFunction")
        public long getFreeFunction();
    }

    public static final class Picker
    extends GraphicsShadowPicker<Object> {
        public Picker() {
            super(ShadowNoopNativeAllocationRegistry.class, ShadowNativeAllocationRegistry.class);
        }
    }
}

